/*
 * Decompiled with CFR 0.152.
 */
package ext.libx.swg.docviewer;

import ext.base.core.BcNumberUtil;
import ext.base.log.BcLogUtil;
import ext.base.util.BcWords;
import ext.lib.awt.AwtImageHelper;
import ext.lib.doc.util.DcfPageReader;
import ext.lib.swg.SwgButton;
import ext.lib.swg.SwgComboBox;
import ext.lib.swg.SwgControlPanel;
import ext.lib.swg.SwgLabel;
import ext.libx.swg.docviewer.DcfDocumentViewer;
import ext.libx.swg.docviewer.DcfViewerPanel;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ImageIcon;
import javax.swing.JLabel;

public class DcfViewerControlPanel
extends SwgControlPanel
implements ItemListener {
    protected SwgButton createPdfButton;
    protected SwgButton closeButton;
    protected SwgButton previousButton;
    protected SwgButton nextButton;
    protected SwgComboBox pageNoCombo;
    protected SwgComboBox scaleComboBox;
    protected SwgLabel statusLabel;
    protected SwgButton printButton;
    protected int currentPageIndex;
    protected DcfDocumentViewer viewer;
    protected DcfViewerPanel viewerPanel;
    protected DcfPageReader pageReader;

    public DcfViewerControlPanel(DcfDocumentViewer viewer, DcfViewerPanel viewerPanel) throws Exception {
        this.viewer = viewer;
        this.viewerPanel = viewerPanel;
        this.createPdfButton = new SwgButton("PDF \u51fa\u529b", new ImageIcon(AwtImageHelper.getImageAsIcon("export_64x64.png")));
        this.closeButton = new SwgButton(BcWords.getInstance().close);
        this.previousButton = new SwgButton(new ImageIcon(AwtImageHelper.getImageAsIcon("navigate_left_64x64.png")));
        this.nextButton = new SwgButton(new ImageIcon(AwtImageHelper.getImageAsIcon("navigate_right_64x64.png")));
        this.pageNoCombo = new SwgComboBox();
        this.scaleComboBox = new SwgComboBox();
        this.statusLabel = new SwgLabel();
        this.printButton = new SwgButton(BcWords.getInstance().print);
        this.add(new JLabel(BcWords.getInstance().page));
        this.pageNoCombo.setMaximumRowCount(32);
        this.pageNoCombo.setEditable(true);
        this.add(this.pageNoCombo);
        this.pageNoCombo.addItemListener(this);
        this.previousButton.addActionListener(this.actionListener);
        this.add(this.previousButton);
        this.nextButton.addActionListener(this.actionListener);
        this.add(this.nextButton);
        this.scaleComboBox.addItem("400 %");
        this.scaleComboBox.addItem("250 %");
        this.scaleComboBox.addItem("200 %");
        this.scaleComboBox.addItem("150 %");
        this.scaleComboBox.addItem("125 %");
        this.scaleComboBox.addItem("100 %");
        this.scaleComboBox.addItem(" 75 %");
        this.scaleComboBox.addItem(" 50 %");
        this.scaleComboBox.addItem(" 25 %");
        this.scaleComboBox.setSelectedIndex(5);
        this.scaleComboBox.addItemListener(this);
        this.add(this.scaleComboBox);
        if (viewer.printButtonEnabled) {
            this.printButton.addActionListener(this.actionListener);
            this.add(this.printButton);
        }
        this.createPdfButton.addActionListener(this.actionListener);
        this.add(this.createPdfButton);
        this.closeButton.addActionListener(this.actionListener);
        this.add(this.closeButton);
    }

    protected void checkOption() throws Exception {
        if (this.viewer.getPageReader().getPageCount() > 0) {
            this.pageNoCombo.setEnabled(true);
            this.printButton.setEnabled(true);
        } else {
            this.pageNoCombo.setEnabled(false);
            this.printButton.setEnabled(false);
        }
    }

    public DcfPageReader getPageReader() {
        return this.pageReader;
    }

    public void setPageReader(DcfPageReader pageReader) throws Exception {
        this.pageReader = pageReader;
        this.currentPageIndex = 0;
        if (this.pageNoCombo.getItemCount() > 0) {
            this.pageNoCombo.removeAllItems();
        }
        int i = 0;
        while (i < pageReader.getPageCount()) {
            this.pageNoCombo.addItem(Integer.toString(i + 1));
            ++i;
        }
        this.previousButton.setEnabled(false);
        if (pageReader.getPageCount() > 1) {
            this.pageNoCombo.setEnabled(true);
            this.nextButton.setEnabled(true);
        } else {
            this.pageNoCombo.setEnabled(false);
            this.nextButton.setEnabled(false);
        }
    }

    @Override
    protected void actionPerformed2(ActionEvent ev) throws Exception {
        super.actionPerformed2(ev);
        if (ev.getSource() == this.closeButton) {
            this.viewer.closeTransaction();
        } else if (ev.getSource() == this.previousButton) {
            int pageIndex = this.viewerPanel.paperPane2.getDispPages()[0] - 1;
            this.viewerPanel.pageSelected(this, pageIndex);
        } else if (ev.getSource() == this.nextButton) {
            int pageIndex = this.viewerPanel.paperPane2.getDispPages()[0] + 1;
            this.viewerPanel.pageSelected(this, pageIndex);
        } else if (ev.getSource() == this.createPdfButton) {
            this.viewer.createPdf();
        } else if (ev.getSource() == this.printButton) {
            this.viewer.printOut(-1);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent ev) {
        if (ev.getStateChange() != 1) {
            return;
        }
        if (ev.getSource() == this.pageNoCombo) {
            if (ev.getStateChange() == 1) {
                try {
                    String str = (String)this.pageNoCombo.getSelectedItem();
                    int pageIndex = BcNumberUtil.parseInteger(str) - 1;
                    if (pageIndex == this.currentPageIndex) {
                        return;
                    }
                    this.viewerPanel.pageSelected(this, pageIndex);
                }
                catch (Exception ex) {
                    BcLogUtil.error(ex);
                }
            }
        } else if (ev.getSource() == this.scaleComboBox) {
            try {
                String str = (String)this.scaleComboBox.getSelectedItem();
                String str2 = str.substring(0, 3);
                float percent = BcNumberUtil.parseFloat(str2).floatValue();
                this.viewerPanel.setScale(percent / 100.0f);
            }
            catch (Exception ex) {
                BcLogUtil.error(ex);
            }
        }
    }

    public int getCurrentPageIndex() {
        return this.currentPageIndex;
    }

    public void setCurrentPageIndex(int pageIndex) throws Exception {
        if (pageIndex == this.currentPageIndex) {
            return;
        }
        this.currentPageIndex = pageIndex;
        this.pageNoCombo.setSelectedItem(Integer.toString(pageIndex + 1));
        if (pageIndex > 0) {
            this.previousButton.setEnabled(true);
        } else {
            this.previousButton.setEnabled(false);
        }
        if (pageIndex < this.pageReader.getPageCount() - 1) {
            this.nextButton.setEnabled(true);
        } else {
            this.nextButton.setEnabled(false);
        }
    }
}

