/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.swg;

import ext.base.log.BcLogUtil;
import ext.base.util.BcCompareUtil;
import ext.base.util.BcExceptionHandler;
import ext.base.util.BcMessageCreator;
import ext.base.util.BcWords;
import ext.lib.awt.AwtFontUtil;
import ext.lib.awt.AwtImageHelper;
import ext.lib.awt.AwtUtil;
import ext.lib.swg.SwgButton;
import ext.lib.swg.SwgComponentUnit;
import ext.lib.swg.SwgDialog;
import ext.lib.swg.SwgExceptionHandler;
import ext.lib.swg.SwgFrame;
import ext.lib.swg.SwgTextArea;
import java.awt.Button;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.TextComponent;
import java.awt.Toolkit;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;

public final class SwgUtil {
    public static final int FIELD_MARGIN_H = 12;
    public static final int FIELD_MARGIN_V = 12;
    static int sizeDiff = 4;
    protected static BcExceptionHandler exceptionHandler = new SwgExceptionHandler();

    private SwgUtil() {
    }

    public static Window getWindow(Component component) {
        if (component == null) {
            return null;
        }
        Window window = null;
        window = component instanceof Window ? (Window)component : SwingUtilities.windowForComponent(component);
        return window;
    }

    public static Dimension getTextSize(JComponent jComponent, int textLength) {
        Dimension dim = SwgUtil.getTextSize(jComponent, textLength);
        dim = new Dimension(dim.width * textLength, dim.height);
        return dim;
    }

    public static Dimension getTextFieldSize(Font font, String text) {
        Dimension textSize = AwtFontUtil.getTextSize(font, text);
        int width = textSize.width + 12;
        int height = textSize.height + 12;
        Dimension dim = new Dimension(width, height);
        return dim;
    }

    public static Dimension getTextFieldSize(Font font, int textLength, int rowCount) {
        Dimension textSize = AwtFontUtil.getTextSize(font, textLength);
        int width = textSize.width + 12;
        int height = textSize.height * rowCount + 12;
        Dimension dim = new Dimension(width, height);
        return dim;
    }

    public static Dimension getTextFieldSize(Font font, int textLength) {
        return SwgUtil.getTextFieldSize(font, textLength, 1);
    }

    public static Dimension getTextFieldSize(Font font) {
        return SwgUtil.getTextFieldSize(font, 1);
    }

    public static Dimension getButtonSize(AbstractButton button, String text) {
        Dimension dim = AwtFontUtil.getTextSize(button.getFont(), text);
        int width = dim.width;
        if (button.getMargin() != null) {
            width += button.getMargin().left + button.getMargin().right;
        }
        if (button.getIcon() != null) {
            width += button.getIcon().getIconWidth();
        }
        width += 24;
        int height = dim.height;
        if (button.getMargin() != null) {
            height += button.getMargin().top + button.getMargin().bottom;
        }
        if (button.getIcon() != null) {
            height = Math.max(height, button.getIcon().getIconHeight());
        }
        dim.setSize(width, height += 10);
        return dim;
    }

    public static Dimension getButtonSize(AbstractButton button) {
        return SwgUtil.getButtonSize(button, button.getText());
    }

    public static Dimension getRadioButtonSize(Font font, String text) {
        Dimension dim = SwgUtil.getTextFieldSize(font, text);
        dim.width += 20;
        return dim;
    }

    public static Dimension getRadioButtonSize(JRadioButton radioButton) {
        return SwgUtil.getRadioButtonSize(radioButton.getFont(), radioButton.getText());
    }

    public static Dimension getCheckBoxSize(Font font, String text) {
        Dimension dim = SwgUtil.getTextFieldSize(font, text);
        dim.width += 18;
        return dim;
    }

    public static Dimension getCheckBoxSize(JCheckBox checkBox) {
        return SwgUtil.getCheckBoxSize(checkBox.getFont(), checkBox.getText());
    }

    public static Dimension getComboBoxSize(Font font, int textLength) {
        Dimension dim = SwgUtil.getTextFieldSize(font, textLength);
        dim.width += 8;
        return dim;
    }

    public static int getRowDiff(Font font) {
        return AwtFontUtil.getTextSize((Font)font, (int)1).height / 6;
    }

    public static int getColDiff(Font font) {
        return AwtFontUtil.getTextSize((Font)font, (int)1).width / 6;
    }

    public static int getTextFieldWidth(Font font, int textLength) throws Exception {
        return SwgUtil.getTextFieldSize((Font)font, (int)textLength).width;
    }

    public static int getTextFieldHeight(Font font, String text) {
        return SwgUtil.getTextFieldSize((Font)font, (String)text).height;
    }

    public static int getBrowsButtonHeight(Font font, String text) {
        return SwgUtil.getTextFieldSize((Font)font, (String)text).height;
    }

    public static Font getBrowsButtonFont(Font font) {
        return new Font("Dialog", 0, font.getSize() - sizeDiff);
    }

    public static Dimension getBrowsButtonSize(Font font) {
        Font tmpFont = new Font("Dialog", 0, font.getSize() + sizeDiff);
        Dimension textFieldSize = SwgUtil.getTextFieldSize(tmpFont);
        Dimension size = new Dimension(textFieldSize.width + 24, textFieldSize.height);
        return size;
    }

    public static void setLocation(Container container, Component component, double x, double y, double width, double height) {
        if (width < 0.0) {
            width = component.getPreferredSize().width;
        }
        if (height < 0.0) {
            height = component.getPreferredSize().height;
        }
        component.setLocation((int)x, (int)y);
        component.setSize((int)width, (int)height);
        container.add(component);
    }

    public static void setLocation(Container container, Component component, double x, double y) {
        SwgUtil.setLocation(container, component, x, y, (double)component.getPreferredSize().width, (double)component.getPreferredSize().height);
    }

    public static void setLocation(JComponent container, JComponent component, double x, double y, double width, double height) {
        if (width < 0.0) {
            width = component.getPreferredSize().width;
        }
        if (height < 0.0) {
            height = component.getPreferredSize().height;
        }
        component.setLocation((int)x, (int)y);
        component.setSize((int)width, (int)height);
        container.setLayout(null);
        container.add(component);
    }

    public static void setLocation(JComponent container, JComponent component, double x, double y) {
        SwgUtil.setLocation(container, component, x, y, (double)component.getPreferredSize().width, (double)component.getPreferredSize().height);
    }

    public static void setFont(Component component, Font font) {
        component.setFont(font);
        if (Container.class.isAssignableFrom(component.getClass())) {
            Container container = (Container)component;
            Component[] components = container.getComponents();
            int i = 0;
            while (i < components.length) {
                SwgUtil.setFont(components[i], font);
                ++i;
            }
        }
    }

    public static void setEnabled(Component component, boolean isEnabled, Class targetClass) {
        if (targetClass.isAssignableFrom(component.getClass())) {
            component.setEnabled(isEnabled);
        }
        if (Container.class.isAssignableFrom(component.getClass())) {
            Container container = (Container)component;
            Component[] components = container.getComponents();
            int i = 0;
            while (i < components.length) {
                SwgUtil.setEnabled(components[i], isEnabled, targetClass);
                ++i;
            }
        }
    }

    public static void setEnabled(Component component, boolean isEnabled) {
        SwgUtil.setEnabled(component, isEnabled, Component.class);
    }

    public static void setEnabled(Collection<? extends Component> componentCollection, boolean isEnabled) throws Exception {
        for (Component component : componentCollection) {
            component.setEnabled(isEnabled);
        }
    }

    public static void setEnabled(Component[] components, boolean isEnabled) {
        int i = 0;
        while (i < components.length) {
            components[i].setEnabled(isEnabled);
            ++i;
        }
    }

    public static void setEnabledComponentUnit(Collection<? extends SwgComponentUnit> componentUnitCollection, boolean isEnabled) throws Exception {
        for (SwgComponentUnit swgComponentUnit : componentUnitCollection) {
            swgComponentUnit.setEnabled(isEnabled);
        }
    }

    public static void setEditable(Component component, boolean isEditable) {
        if (TextComponent.class.isAssignableFrom(component.getClass())) {
            TextComponent textComponent = (TextComponent)component;
            textComponent.setEditable(isEditable);
        } else if (JTextComponent.class.isAssignableFrom(component.getClass())) {
            JTextComponent jTextComponent = (JTextComponent)component;
            jTextComponent.setEditable(isEditable);
        } else if (JComboBox.class.isAssignableFrom(component.getClass())) {
            JComboBox jComboBox = (JComboBox)component;
            jComboBox.setEditable(isEditable);
            jComboBox.setEnabled(isEditable);
        } else if (Button.class.isAssignableFrom(component.getClass())) {
            Button button = (Button)component;
            button.setEnabled(isEditable);
        } else if (AbstractButton.class.isAssignableFrom(component.getClass())) {
            AbstractButton abstractButton = (AbstractButton)component;
            abstractButton.setEnabled(isEditable);
        }
        if (Container.class.isAssignableFrom(component.getClass())) {
            Container container = (Container)component;
            Component[] components = container.getComponents();
            int i = 0;
            while (i < components.length) {
                SwgUtil.setEditable(components[i], isEditable);
                ++i;
            }
        }
    }

    public static void setOpaque(Component component, boolean isOpaque, Class targetClass) {
        if (targetClass.isAssignableFrom(component.getClass()) && JComponent.class.isAssignableFrom(component.getClass())) {
            JComponent jComponent = (JComponent)component;
            jComponent.setOpaque(isOpaque);
        }
        if (Container.class.isAssignableFrom(component.getClass())) {
            Container container = (Container)component;
            Component[] components = container.getComponents();
            int i = 0;
            while (i < components.length) {
                SwgUtil.setOpaque(components[i], isOpaque, targetClass);
                ++i;
            }
        }
    }

    public static void setOpaque(Component component, boolean isOpaque) {
        SwgUtil.setOpaque(component, isOpaque, Component.class);
    }

    public static void setOpaque(Component[] components, boolean isOpaque) {
        int i = 0;
        while (i < components.length) {
            SwgUtil.setOpaque(components[i], isOpaque);
            ++i;
        }
    }

    public static void setPreferredWidth(Component component, int width) {
        Dimension dim1 = component.getPreferredSize();
        Dimension dim2 = new Dimension(width, dim1.height);
        component.setPreferredSize(dim2);
    }

    public static void setPreferredHeight(Component component, int height) {
        Dimension dim1 = component.getPreferredSize();
        Dimension dim2 = new Dimension(dim1.width, height);
        component.setPreferredSize(dim2);
    }

    public static void addPreferredWidth(Component component, int width) {
        Dimension dim1 = component.getPreferredSize();
        Dimension dim2 = new Dimension(dim1.width + width, dim1.height);
        component.setPreferredSize(dim2);
    }

    public static void addPreferredHeight(Component component, int height) {
        Dimension dim1 = component.getPreferredSize();
        Dimension dim2 = new Dimension(dim1.width, dim1.height + height);
        component.setPreferredSize(dim2);
    }

    public static boolean isEnabledToRoot(Component component1) {
        boolean isEnabled = true;
        for (Component component2 = component1; component2 != null; component2 = component2.getParent()) {
            if (component2.isEnabled()) continue;
            isEnabled = false;
            break;
        }
        return isEnabled;
    }

    public static void setWindowMax(Window window) {
        if (window instanceof Frame) {
            Frame frame = (Frame)window;
            frame.setExtendedState(6);
        } else {
            Rectangle windowRectangleMax = AwtUtil.getWindowRectangleMax();
            window.setBounds(windowRectangleMax);
        }
    }

    public static void setCascadeRectangle(Window window, int baseX, int baseY, double ratio) throws Exception {
        Dimension dimension = AwtUtil.calcDimensionByRatio(ratio);
        Rectangle cascadeRectangle = AwtUtil.calcCascadeRectangle(baseX, baseY, dimension.width, dimension.height);
        window.setBounds(cascadeRectangle);
    }

    public static void setCascadeRectangle(Window window, Component baseComponent, double ratio) throws Exception {
        Window baseWindow = SwgUtil.getWindow(baseComponent);
        Rectangle baseRectangle = baseWindow.getBounds();
        SwgUtil.setCascadeRectangle(window, baseRectangle.x, baseRectangle.y, ratio);
    }

    public static void setCenter(Component component, double width, double height) {
        Rectangle windowRectangleMax = AwtUtil.getWindowRectangleMax();
        double width2 = Math.min((double)windowRectangleMax.width, width);
        double height2 = Math.min((double)windowRectangleMax.height, height);
        component.setSize((int)width2, (int)height2);
        component.setLocation((windowRectangleMax.width - (int)width2) / 2, (windowRectangleMax.height - (int)height2) / 2);
    }

    public static void setCenter(Component component, double margin) {
        Rectangle windowRectangleMax = AwtUtil.getWindowRectangleMax();
        double width = windowRectangleMax.width - (int)margin * 2;
        double height = windowRectangleMax.height - (int)margin * 2;
        SwgUtil.setCenter(component, width, height);
    }

    public static void setCenterByRatio(Window window, double ratio) throws Exception {
        Dimension windowSize = AwtUtil.calcDimensionByRatio(ratio);
        SwgUtil.setCenter(window, windowSize.width, windowSize.height);
    }

    public static void setSelectWindow(Component component) {
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        component.setSize(480, dim.height - 64);
        component.setLocation(dim.width - 480 - 20, 20);
    }

    public static SwgDialog createDialog(Component component) {
        Window window = SwgUtil.getWindow(component);
        if (window == null) {
            window = new SwgFrame();
        }
        SwgDialog dialog = null;
        if (window instanceof Frame) {
            dialog = new SwgDialog((Frame)window);
        } else if (window instanceof Dialog) {
            dialog = new SwgDialog((Dialog)window);
        }
        return dialog;
    }

    public static void windowTiles(List<Window> windowList, int colMax, int rowMax) {
        Rectangle windowRectangleMax = AwtUtil.getWindowRectangleMax();
        int windowWidth = (int)(windowRectangleMax.getWidth() / (double)colMax);
        int windowHeight = (int)(windowRectangleMax.getHeight() / (double)rowMax);
        int i = 0;
        while (i < windowList.size()) {
            int colCnt = i - i / colMax * colMax + 1;
            int rowCnt = i / colMax + 1;
            int x = (colCnt - 1) * windowWidth;
            int y = (rowCnt - 1) * windowHeight;
            Window window = windowList.get(i);
            window.setSize(windowWidth, windowHeight);
            window.setLocation(x, y);
            ++i;
        }
    }

    public static void setHtmlDisabled(JComponent jComponent, boolean disabled) {
        jComponent.putClientProperty("html.disable", disabled);
    }

    public static String createMessage(String subject, Collection elementCollection, Object appendix) {
        StringBuilder sb = new StringBuilder();
        sb.append(BcMessageCreator.getInstance().createMessage(subject, elementCollection));
        if (appendix != null) {
            sb.append("\n\n");
            sb.append(appendix);
        }
        return sb.toString();
    }

    public static Component createMessageComponent(String subject, Collection elementCollection, Object appendix) {
        String sb = SwgUtil.createMessage(subject, elementCollection, appendix);
        SwgTextArea textArea = null;
        try {
            textArea = new SwgTextArea();
        }
        catch (Exception ex) {
            BcLogUtil.error(ex);
        }
        textArea.setEditable(false);
        textArea.setText(sb.toString());
        JScrollPane scrollPane = new JScrollPane(textArea);
        return scrollPane;
    }

    public static Component createMessageComponent(String subject, Collection elementCollection) {
        return SwgUtil.createMessageComponent(subject, elementCollection, null);
    }

    public static Component createMessageComponent(String subject, Object element) {
        ArrayList<Object> elementList = new ArrayList<Object>();
        elementList.add(element);
        return SwgUtil.createMessageComponent(subject, elementList);
    }

    public static boolean addItemNotExists(JComboBox comboBox, Object item1, boolean doSelected) throws Exception {
        int i = 0;
        while (i < comboBox.getItemCount()) {
            Object item2 = comboBox.getItemAt(i);
            if (BcCompareUtil.equals(item1, item2, true)) {
                if (doSelected) {
                    comboBox.setSelectedItem(item1);
                }
                return false;
            }
            ++i;
        }
        comboBox.addItem(item1);
        if (doSelected) {
            comboBox.setSelectedItem(item1);
        }
        return true;
    }

    public static BcExceptionHandler getExceptionHandler() {
        return exceptionHandler;
    }

    public static void setExceptionHandler(BcExceptionHandler exceptionHandler) {
        SwgUtil.exceptionHandler = exceptionHandler;
    }

    public static void exceptionHandle(Throwable throwable, Object source) {
        if (exceptionHandler != null) {
            exceptionHandler.handleException(throwable, source);
        } else {
            try {
                String msg = BcLogUtil.convertMessage(throwable);
                if (source instanceof Component) {
                    Component parentComponent = (Component)source;
                    JOptionPane.showMessageDialog(parentComponent, msg, BcWords.getInstance().exception, 0);
                } else {
                    BcLogUtil.error(msg);
                }
            }
            catch (Exception ex) {
                BcLogUtil.error(ex);
            }
        }
    }

    public static String toPositionName(int positionId) throws Exception {
        switch (positionId) {
            case 0: {
                return BcWords.getInstance().center;
            }
            case 1: {
                return BcWords.getInstance().top;
            }
            case 3: {
                return BcWords.getInstance().bottom;
            }
            case 2: {
                return BcWords.getInstance().left;
            }
            case 4: {
                return BcWords.getInstance().right;
            }
        }
        throw new Exception("ERROR:positionId=" + positionId);
    }

    public static SwgButton createOkButton(String text, String tooltipText) throws Exception {
        SwgButton button = new SwgButton();
        button.setText(text);
        button.setToolTipText(tooltipText);
        ImageIcon imageIcon = new ImageIcon(AwtImageHelper.getImageAsIcon("check_64x64.png"));
        button.setIcon(imageIcon);
        return button;
    }

    public static SwgButton createOkButton() throws Exception {
        return SwgUtil.createOkButton(BcWords.getInstance().ok, null);
    }

    public static SwgButton createCancelButton(String text, String tooltipText) throws Exception {
        SwgButton button = new SwgButton();
        button.setText(text);
        button.setToolTipText(tooltipText);
        ImageIcon imageIcon = new ImageIcon(AwtImageHelper.getImageAsIcon("cancel_64x64.png"));
        button.setIcon(imageIcon);
        return button;
    }

    public static SwgButton createCancelButton() throws Exception {
        return SwgUtil.createCancelButton(BcWords.getInstance().cancel, null);
    }

    public static SwgButton createOpenButton(String text, String tooltipText) throws Exception {
        SwgButton button = new SwgButton();
        button.setText(text);
        button.setToolTipText(tooltipText);
        ImageIcon imageIcon = new ImageIcon(AwtImageHelper.getImageAsIcon("folder_up_64x64.png"));
        button.setIcon(imageIcon);
        return button;
    }

    public static SwgButton createOpenButton() throws Exception {
        return SwgUtil.createOpenButton(BcWords.getInstance().open, null);
    }

    public static SwgButton createAddButton(String text, String tooltipText) throws Exception {
        SwgButton button = new SwgButton();
        button.setText(text);
        button.setToolTipText(tooltipText);
        ImageIcon imageIcon = new ImageIcon(AwtImageHelper.getImageAsIcon("add_64x64.png"));
        button.setIcon(imageIcon);
        return button;
    }

    public static SwgButton createAddButton() throws Exception {
        return SwgUtil.createAddButton(BcWords.getInstance().add, null);
    }

    public static SwgButton createDeleteButton(String text, String tooltipText) throws Exception {
        SwgButton button = new SwgButton();
        button.setText(text);
        button.setToolTipText(tooltipText);
        ImageIcon imageIcon = new ImageIcon(AwtImageHelper.getImageAsIcon("cancel_64x64.png"));
        button.setIcon(imageIcon);
        return button;
    }

    public static SwgButton createDeleteButton() throws Exception {
        return SwgUtil.createDeleteButton(BcWords.getInstance().delete, null);
    }

    public static SwgButton createEditButton(String text, String tooltipText) throws Exception {
        SwgButton button = new SwgButton();
        button.setText(text);
        button.setToolTipText(tooltipText);
        ImageIcon imageIcon = new ImageIcon(AwtImageHelper.getImageAsIcon("edit_64x64.png"));
        button.setIcon(imageIcon);
        return button;
    }

    public static SwgButton createEditButton() throws Exception {
        return SwgUtil.createEditButton(BcWords.getInstance().edit, null);
    }

    public static SwgButton createOpenDirectoryButton(String text, String tooltipText) throws Exception {
        SwgButton button = new SwgButton();
        button.setText(text);
        button.setToolTipText(tooltipText);
        ImageIcon imageIcon = new ImageIcon(AwtImageHelper.getImageAsIcon("folder_opened_64x64.png"));
        button.setIcon(imageIcon);
        return button;
    }

    public static SwgButton createOpenDirectoryButton() throws Exception {
        return SwgUtil.createOpenDirectoryButton(BcWords.getInstance().openDirectory, null);
    }

    public static SwgButton createExecuteButton(String text, String tooltipText) throws Exception {
        SwgButton button = new SwgButton();
        button.setText(text);
        button.setToolTipText(tooltipText);
        ImageIcon imageIcon = new ImageIcon(AwtImageHelper.getImageAsIcon("bullet_triangle_blue_64x64.png"));
        button.setIcon(imageIcon);
        return button;
    }

    public static SwgButton createExecuteButton() throws Exception {
        return SwgUtil.createExecuteButton(BcWords.getInstance().execute, null);
    }

    public static SwgButton createSelectAllBbutton(String text, String tooltipText) throws Exception {
        SwgButton button = new SwgButton();
        button.setText(text);
        button.setToolTipText(tooltipText);
        return button;
    }

    public static SwgButton createSelectAllBbutton() throws Exception {
        return SwgUtil.createSelectAllBbutton(BcWords.getInstance().selectAll.toPlain(), null);
    }

    public static SwgButton createReleaseAllButton(String text, String tooltipText) throws Exception {
        SwgButton button = new SwgButton();
        button.setText(text);
        button.setToolTipText(tooltipText);
        return button;
    }

    public static SwgButton createReleaseAllButton() throws Exception {
        return SwgUtil.createReleaseAllButton(BcWords.getInstance().releaseAll.toPlain(), null);
    }
}

