/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.swg;

import ext.base.core.BcTimeUtil;
import ext.lib.swg.SwgDateTimeField;
import ext.lib.swg.SwgLabel;
import ext.lib.swg.SwgPanel;
import ext.lib.swg.SwgUtil;
import java.awt.Dimension;
import java.awt.Font;
import java.util.Calendar;

public class SwgPeriodPanel
extends SwgPanel {
    private static final long serialVersionUID = -2377116656800705372L;
    public SwgDateTimeField dateTimeField1;
    public SwgDateTimeField dateTimeField2;
    protected SwgLabel waveLabel = new SwgLabel("\uff5e", 0);
    private int mode;

    public SwgPeriodPanel(int mode) throws Exception {
        this.mode = mode;
        this.dateTimeField1 = this.createStartField();
        this.dateTimeField2 = this.createEndField();
        this.initComponent();
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (this.dateTimeField1 != null) {
            this.dateTimeField1.setFont(font);
            this.dateTimeField2.setFont(font);
            this.waveLabel.setFont(font);
            this.initComponent();
        }
    }

    public int getMode() {
        return this.mode;
    }

    public void initComponent() {
        this.dateTimeField1.initComponent();
        this.dateTimeField2.initComponent();
        Dimension dim = SwgUtil.getTextFieldSize(this.getFont());
        int colDiff = SwgUtil.getColDiff(this.getFont());
        int xPos = 0;
        SwgUtil.setLocation(this, this.dateTimeField1, (double)xPos, 0.0, (double)((int)this.dateTimeField1.getPreferredSize().getWidth()), (double)dim.height);
        xPos = (int)((double)xPos + (this.dateTimeField1.getPreferredSize().getWidth() + (double)colDiff));
        SwgUtil.setLocation(this, this.waveLabel, (double)xPos, 0.0, (double)((int)this.waveLabel.getPreferredSize().getWidth()), (double)dim.height);
        xPos = (int)((double)xPos + (this.waveLabel.getPreferredSize().getWidth() + (double)colDiff));
        SwgUtil.setLocation(this, this.dateTimeField2, (double)xPos, 0.0, (double)((int)this.dateTimeField2.getPreferredSize().getWidth()), (double)dim.height);
        xPos = (int)((double)xPos + (this.dateTimeField2.getPreferredSize().getWidth() + (double)colDiff));
        this.setPreferredSize(new Dimension(xPos, dim.height));
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        this.dateTimeField1.setEnabled(isEnabled);
        this.dateTimeField2.setEnabled(isEnabled);
        this.waveLabel.setEnabled(isEnabled);
    }

    public void setEditable(boolean isEditable) {
        this.dateTimeField1.setEditable(isEditable);
        this.dateTimeField2.setEditable(isEditable);
    }

    public Calendar[] getCalendars() {
        Calendar calendar1 = this.dateTimeField1.getCalendar();
        Calendar calendar2 = this.dateTimeField2.getCalendar();
        if (this.mode == 11) {
            if (calendar1 != null) {
                BcTimeUtil.setMonthStart(calendar1);
            }
            if (calendar2 != null) {
                BcTimeUtil.setMonthEnd(calendar2);
            }
        }
        Calendar[] calendars = new Calendar[]{calendar1, calendar2};
        return calendars;
    }

    public SwgDateTimeField createStartField() throws Exception {
        return new SwgDateTimeField(this.mode);
    }

    public SwgDateTimeField createEndField() throws Exception {
        return new SwgDateTimeField(this.mode);
    }
}

