/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.swg;

import ext.base.log.BcLogUtil;
import ext.base.runtime.BcRuntimeUtil;
import ext.base.util.BcWords;
import ext.lib.swg.SwgDecoratePanel;
import ext.lib.swg.SwgImagePanel;
import ext.lib.swg.SwgTextArea;
import ext.lib.swg.SwgUtil;
import ext.lib.swg.sounds.SwgJarDataSource;
import ext.lib.swg.sounds.SwgSoundUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import javax.media.Manager;
import javax.media.Player;
import javax.media.protocol.DataSource;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTextField;

class SwgOptionWorkPanel
extends SwgDecoratePanel {
    private static final long serialVersionUID = -5368215673935628399L;
    protected int optionType;
    protected int resValue = -1;
    protected JPanel westPanel2 = new JPanel();
    protected JTextField textField = new JTextField();
    protected URL soundUrl;
    protected Player player;
    protected Object message;
    protected String title;
    protected Icon icon;
    protected Image image;
    protected Window window;

    public void setup() throws Exception {
        this.setLine();
        if (this.optionType == -1) {
            this.setOkButton(BcWords.getInstance().yes);
        } else if (this.optionType == 0) {
            this.setOkButton(BcWords.getInstance().yes);
            this.setCancelButton(BcWords.getInstance().no);
        } else if (this.optionType != 1 && this.optionType == 2) {
            this.setOkButton(BcWords.getInstance().ok);
            this.setCancelButton(BcWords.getInstance().cancel);
        }
        this.centerPanel.setLayout(new BorderLayout());
        this.westPanel2.setLayout(new BorderLayout());
        this.westPanel2.setPreferredSize(new Dimension(56, 0));
        if (this.image != null) {
            SwgImagePanel imagePanel = new SwgImagePanel(this.image);
            imagePanel.keepRatio = true;
            imagePanel.isScaling = true;
            imagePanel.setPreferredSize(new Dimension(48, 48));
            this.westPanel2.add((Component)imagePanel, "North");
        }
        this.textField.setPreferredSize(new Dimension(0, 0));
        this.westPanel2.add((Component)this.textField, "South");
        this.centerPanel.add((Component)this.westPanel2, "West");
        if (this.message != null) {
            if (JComponent.class.isAssignableFrom(this.message.getClass())) {
                JComponent jComponent = (JComponent)this.message;
                this.centerPanel.add((Component)jComponent, "Center");
            } else {
                SwgTextArea textArea = new SwgTextArea();
                textArea.setEditable(false);
                textArea.setText(this.message.toString());
                this.centerPanel.add((Component)textArea, "Center");
            }
        }
        this.soundUrl = SwgSoundUtil.getNotifyUrl();
        URL jarUrl = BcRuntimeUtil.getJarFileUrl(this.soundUrl);
        if (jarUrl == null) {
            this.player = Manager.createRealizedPlayer((URL)this.soundUrl);
        } else {
            SwgJarDataSource jarDataSource = new SwgJarDataSource(this.soundUrl);
            jarDataSource.connect();
            this.player = Manager.createPlayer((DataSource)jarDataSource);
        }
    }

    @Override
    protected void okButtonAction() throws Exception {
        this.resValue = 0;
        this.close();
    }

    @Override
    protected void cancelButtonAction() throws Exception {
        this.resValue = 1;
        this.close();
    }

    @Override
    public void close() {
        this.window.dispose();
    }

    public int showAsDialog(Component parentComponent) throws Exception {
        JDialog dialog = new JDialog(SwgUtil.getWindow(parentComponent));
        dialog.getContentPane().add((Component)this, "Center");
        dialog.setDefaultCloseOperation(0);
        dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent ev) {
                try {
                    SwgOptionWorkPanel.this.player.start();
                    SwgOptionWorkPanel.this.textField.requestFocus();
                }
                catch (Exception ex) {
                    BcLogUtil.error(ex);
                }
            }

            @Override
            public void windowClosing(WindowEvent ev) {
                try {
                    SwgOptionWorkPanel.this.close();
                }
                catch (Exception ex) {
                    BcLogUtil.error(ex);
                }
            }
        });
        dialog.setModal(true);
        dialog.setResizable(true);
        dialog.setTitle(this.title);
        if (this.image != null) {
            dialog.setIconImage(this.image);
        }
        this.window = dialog;
        SwgUtil.setCenter(dialog, 520.0, 280.0);
        this.window.setVisible(true);
        this.window.toFront();
        return this.resValue;
    }
}

