/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.sql.context;

import ext.base.core.BcStringUtil;
import ext.base.core.BcUnicode;
import ext.base.log.BcLogUtil;
import ext.base.mmd.MmdField;
import ext.lib.sql.SqlConnection;
import ext.lib.sql.SqlConstants;
import ext.lib.sql.SqlDefinitionCondition;
import ext.lib.sql.SqlResultSet;
import ext.lib.sql.SqlResultSet_PostgreSQL;
import ext.lib.sql.SqlStatement;
import ext.lib.sql.SqlUtil;
import ext.lib.sql.context.SqlContext;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.binary.Hex;

public class SqlContext_PostgreSQL
extends SqlContext {
    public static final String DRIVER_CLASS_NAME = "org.postgresql.Driver";
    public static final String[] DRIVER_CLASS_NAMES = new String[]{"org.postgresql.Driver"};
    public static final int PORT_DEFAULT = 5432;
    public final long SIZE_1GB = (long)Math.pow(1024.0, 3.0) - 1000L;
    private Map<Character, String> escapeCharacterMap;
    boolean NO_BACKSLASH_ESCAPES = true;
    public static final String NANO = "ffffff";

    public SqlContext_PostgreSQL(SqlConstants.DatabaseProduct productName) throws Exception {
        super(productName);
    }

    @Override
    public String[] getDriverClassNames() {
        return DRIVER_CLASS_NAMES;
    }

    @Override
    public int getDefaultPort() {
        return 5432;
    }

    @Override
    public Map<Character, String> getEscapeCharacterMap() {
        if (this.escapeCharacterMap == null) {
            this.escapeCharacterMap = new HashMap<Character, String>();
            this.escapeCharacterMap.put(Character.valueOf(BcUnicode.Unicode.BS.char_), String.valueOf(String.valueOf(BcUnicode.Unicode.reverseSolidus.char_)) + String.valueOf(BcUnicode.Unicode.BS.char_));
            this.escapeCharacterMap.put(Character.valueOf(BcUnicode.Unicode.HT.char_), String.valueOf(String.valueOf(BcUnicode.Unicode.reverseSolidus.char_)) + String.valueOf(BcUnicode.Unicode.HT.char_));
            this.escapeCharacterMap.put(Character.valueOf(BcUnicode.Unicode.LF.char_), String.valueOf(String.valueOf(BcUnicode.Unicode.reverseSolidus.char_)) + String.valueOf(BcUnicode.Unicode.LF.char_));
            this.escapeCharacterMap.put(Character.valueOf(BcUnicode.Unicode.FF.char_), String.valueOf(String.valueOf(BcUnicode.Unicode.reverseSolidus.char_)) + String.valueOf(BcUnicode.Unicode.FF.char_));
            this.escapeCharacterMap.put(Character.valueOf(BcUnicode.Unicode.CR.char_), String.valueOf(String.valueOf(BcUnicode.Unicode.reverseSolidus.char_)) + String.valueOf(BcUnicode.Unicode.CR.char_));
            if (this.NO_BACKSLASH_ESCAPES) {
                this.escapeCharacterMap.put(Character.valueOf(BcUnicode.Unicode.quotationMark.char_), String.valueOf(String.valueOf(BcUnicode.Unicode.quotationMark.char_)) + String.valueOf(BcUnicode.Unicode.quotationMark.char_));
                this.escapeCharacterMap.put(Character.valueOf(BcUnicode.Unicode.apostrophe.char_), String.valueOf(String.valueOf(BcUnicode.Unicode.apostrophe.char_)) + String.valueOf(BcUnicode.Unicode.apostrophe.char_));
            } else {
                this.escapeCharacterMap.put(Character.valueOf(BcUnicode.Unicode.quotationMark.char_), String.valueOf(String.valueOf(BcUnicode.Unicode.reverseSolidus.char_)) + String.valueOf(BcUnicode.Unicode.quotationMark.char_));
                this.escapeCharacterMap.put(Character.valueOf(BcUnicode.Unicode.apostrophe.char_), String.valueOf(String.valueOf(BcUnicode.Unicode.reverseSolidus.char_)) + String.valueOf(BcUnicode.Unicode.apostrophe.char_));
            }
        }
        return this.escapeCharacterMap;
    }

    @Override
    public String type_NUMBER(MmdField mmdField, SqlDefinitionCondition definitionCondition) throws Exception {
        String definition = null;
        switch (mmdField.sqlTypeId) {
            case -6: {
                definition = "SMALLINT";
                break;
            }
            case 2: 
            case 3: {
                if (mmdField.dataSize > 1000) break;
                definition = "NUMERIC(" + mmdField.dataSize + ", " + mmdField.decimalDigit + ")";
                break;
            }
            default: {
                definition = super.type_NUMBER(mmdField, definitionCondition);
            }
        }
        return definition;
    }

    @Override
    public String type_CHAR(MmdField mmdField, SqlDefinitionCondition definitionCondition) throws Exception {
        String definition = null;
        switch (mmdField.sqlTypeId) {
            case -15: 
            case 1: {
                definition = "CHARACTER(" + mmdField.dataSize + ")";
                break;
            }
            case -16: 
            case -9: 
            case -1: 
            case 12: 
            case 2005: 
            case 2011: {
                if (mmdField.dataSize <= 65535) {
                    definition = "VARCHAR(" + mmdField.dataSize + ")";
                    break;
                }
                if ((long)mmdField.dataSize > this.SIZE_1GB) break;
                definition = "TEXT";
            }
        }
        return definition;
    }

    @Override
    public String type_BINARY(MmdField mmdField, SqlDefinitionCondition definitionCondition) throws Exception {
        return "BYTEA";
    }

    @Override
    public void setNull_BLOB(PreparedStatement ppst, int colmunIndex) throws Exception {
        ppst.setNull(colmunIndex, -4);
    }

    @Override
    public String getTimestampFormatForUpdate() {
        return "yyyy/MM/dd HH:mm:ss.ffffff";
    }

    @Override
    public String getTimestampFormatForCondition() {
        return this.getTimestampFormatForUpdate();
    }

    @Override
    public String getDateTimeFormatForCondition() {
        return "yyyy/MM/dd HH:mm:ss";
    }

    @Override
    public String getDateFormatForCondition() {
        return "yyyy/MM/dd";
    }

    @Override
    public int dropIndex(SqlConnection sqlConn, String tableName, String indexName) throws Exception {
        String query = "DROP INDEX " + indexName;
        BcLogUtil.info("query=" + query);
        return SqlUtil.executeUpdate(sqlConn, query);
    }

    @Override
    public StringBuilder toNumber(String columnName, int length) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("TO_NUMBER(");
        sb.append(columnName);
        sb.append(",");
        sb.append("'" + BcStringUtil.fill('9', length) + "'");
        sb.append(")");
        return sb;
    }

    @Override
    public String func_clockTimestamp() throws Exception {
        return "clock_timestamp()";
    }

    @Override
    public String func_statementTimestamp() throws Exception {
        return "statement_timestamp()";
    }

    @Override
    public String func_transactionTimestamp() throws Exception {
        return "transaction_timestamp()";
    }

    @Override
    public String func_coalesce(String ... values) throws Exception {
        return "COALESCE(" + BcStringUtil.toCsv(true, values) + ")";
    }

    @Override
    public String func_replace_regexp(String src, String regexp, String replacement) throws Exception {
        return this.func_replace_regexp(src, BcStringUtil.singleQuotation(regexp), BcStringUtil.singleQuotation(replacement), BcStringUtil.singleQuotation(RegexFrag.g.name()));
    }

    @Override
    public String escapeForPatternMatch(String pattern) throws Exception {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < pattern.length()) {
            char curChar = pattern.charAt(i);
            switch (curChar) {
                case '%': 
                case '_': {
                    sb.append('\\');
                    sb.append('\\');
                    sb.append(curChar);
                    break;
                }
                default: {
                    sb.append(curChar);
                }
            }
            ++i;
        }
        return sb.toString();
    }

    @Override
    public String convertSql(String srcSql, Map<String, String> paramMap, SqlContext baseSqlContext) throws Exception {
        StringBuilder sb = new StringBuilder(srcSql);
        sb = BcStringUtil.replace(sb, " DECIMAL", " NUMERIC", false);
        return sb.toString();
    }

    @Override
    public SqlResultSet convToSqlResultSet(ResultSet rs, SqlStatement sqlStatement) throws SQLException {
        return new SqlResultSet_PostgreSQL(rs, sqlStatement);
    }

    @Override
    public String createBinaryInsert(byte[] bytes) throws Exception {
        String hex = new String(Hex.encodeHex((byte[])bytes));
        return "DECODE(" + BcStringUtil.singleQuotation(hex) + ", 'HEX')";
    }

    public static enum RegexFrag {
        i,
        g;

    }
}

