/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.sql.context;

import ext.base.core.BcStringUtil;
import ext.base.core.BcUnicode;
import ext.base.mmd.MmdField;
import ext.base.mmd.MmdIndex;
import ext.base.mmd.MmdIndexElement;
import ext.base.mmd.MmdModel;
import ext.lib.sql.SqlConstants;
import ext.lib.sql.SqlDefinitionCondition;
import ext.lib.sql.SqlUtil;
import ext.lib.sql.context.SqlContext;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.binary.Hex;

public class SqlContext_MySQL
extends SqlContext {
    public static final String DRIVER_CLASS_NAME = "com.mysql.jdbc.Driver";
    public static final String DRIVER_CLASS_NAME_v8 = "com.mysql.cj.jdbc.Driver";
    public static final String[] DRIVER_CLASS_NAMES = new String[]{"com.mysql.jdbc.Driver"};
    public static final int PORT_DEFAULT = 3306;
    private Map<Character, String> escapeCharacterMap;
    boolean NO_BACKSLASH_ESCAPES = true;

    public SqlContext_MySQL(SqlConstants.DatabaseProduct databaseProduct) {
        super(databaseProduct);
    }

    @Override
    public String[] getDriverClassNames() {
        return DRIVER_CLASS_NAMES;
    }

    @Override
    public int getDefaultPort() {
        return 3306;
    }

    @Override
    public Map<Character, String> getEscapeCharacterMap() {
        if (this.escapeCharacterMap == null) {
            this.escapeCharacterMap = new HashMap<Character, String>();
            this.escapeCharacterMap.put(Character.valueOf(BcUnicode.Unicode.BS.char_), String.valueOf(String.valueOf(BcUnicode.Unicode.reverseSolidus.char_)) + String.valueOf(BcUnicode.Unicode.BS.char_));
            this.escapeCharacterMap.put(Character.valueOf(BcUnicode.Unicode.HT.char_), String.valueOf(String.valueOf(BcUnicode.Unicode.reverseSolidus.char_)) + String.valueOf(BcUnicode.Unicode.HT.char_));
            this.escapeCharacterMap.put(Character.valueOf(BcUnicode.Unicode.LF.char_), String.valueOf(String.valueOf(BcUnicode.Unicode.reverseSolidus.char_)) + String.valueOf(BcUnicode.Unicode.LF.char_));
            this.escapeCharacterMap.put(Character.valueOf(BcUnicode.Unicode.FF.char_), String.valueOf(String.valueOf(BcUnicode.Unicode.reverseSolidus.char_)) + String.valueOf(BcUnicode.Unicode.FF.char_));
            this.escapeCharacterMap.put(Character.valueOf(BcUnicode.Unicode.CR.char_), String.valueOf(String.valueOf(BcUnicode.Unicode.reverseSolidus.char_)) + String.valueOf(BcUnicode.Unicode.CR.char_));
            if (this.NO_BACKSLASH_ESCAPES) {
                this.escapeCharacterMap.put(Character.valueOf(BcUnicode.Unicode.quotationMark.char_), String.valueOf(String.valueOf(BcUnicode.Unicode.quotationMark.char_)) + String.valueOf(BcUnicode.Unicode.quotationMark.char_));
                this.escapeCharacterMap.put(Character.valueOf(BcUnicode.Unicode.apostrophe.char_), String.valueOf(String.valueOf(BcUnicode.Unicode.apostrophe.char_)) + String.valueOf(BcUnicode.Unicode.apostrophe.char_));
            } else {
                this.escapeCharacterMap.put(Character.valueOf(BcUnicode.Unicode.quotationMark.char_), String.valueOf(String.valueOf(BcUnicode.Unicode.reverseSolidus.char_)) + String.valueOf(BcUnicode.Unicode.quotationMark.char_));
                this.escapeCharacterMap.put(Character.valueOf(BcUnicode.Unicode.apostrophe.char_), String.valueOf(String.valueOf(BcUnicode.Unicode.reverseSolidus.char_)) + String.valueOf(BcUnicode.Unicode.apostrophe.char_));
            }
        }
        return this.escapeCharacterMap;
    }

    @Override
    public String type_NUMBER(MmdField mmdField, SqlDefinitionCondition definitionCondition) throws Exception {
        String definition = null;
        switch (mmdField.sqlTypeId) {
            case -6: {
                definition = "SMALLINT";
                break;
            }
            case 2: 
            case 3: {
                if (mmdField.dataSize > 65) break;
                definition = "NUMERIC(" + mmdField.dataSize + ", " + mmdField.decimalDigit + ")";
                break;
            }
            default: {
                definition = super.type_NUMBER(mmdField, definitionCondition);
            }
        }
        return definition;
    }

    @Override
    public String type_CHAR(MmdField mmdField, SqlDefinitionCondition definitionCondition) throws Exception {
        String definition = null;
        switch (mmdField.sqlTypeId) {
            case -15: 
            case 1: {
                if (mmdField.dataSize > 255) break;
                definition = "CHAR(" + mmdField.dataSize + ")";
                break;
            }
            case -16: 
            case -9: 
            case -1: 
            case 12: {
                if (mmdField.dataSize > 65535) break;
                definition = "VARCHAR" + SqlUtil.toSizeStr(mmdField.dataSize);
                break;
            }
            case 2005: 
            case 2011: {
                if (mmdField.dataSize <= 255) {
                    definition = "TINYTEXT";
                    break;
                }
                if (mmdField.dataSize <= 65535) {
                    definition = "TEXT";
                    break;
                }
                if (mmdField.dataSize <= 16777255) {
                    definition = "MEDIUMTEXT";
                    break;
                }
                if ((long)mmdField.dataSize > 0xFFFFFFFFL) break;
                definition = "LONGTEXT";
            }
        }
        return definition;
    }

    @Override
    public String type_BINARY(MmdField mmdField, SqlDefinitionCondition definitionCondition) throws Exception {
        String definition = null;
        switch (mmdField.sqlTypeId) {
            case -2: {
                if (mmdField.dataSize > 255) break;
                definition = "BINARY" + SqlUtil.toSizeStr(mmdField.dataSize);
                break;
            }
            case -4: 
            case -3: 
            case 2004: {
                if (mmdField.dataSize <= 65535) {
                    definition = "BLOB";
                    break;
                }
                if (mmdField.dataSize <= 16777255) {
                    definition = "MEDIUMBLOB";
                    break;
                }
                if ((long)mmdField.dataSize > 0xFFFFFFFFL) break;
                definition = "LONGBLOB";
            }
        }
        return definition;
    }

    @Override
    public String getTimestampFormatForUpdate() {
        return "yyyy-MM-dd HH:mm:ss";
    }

    @Override
    public String getDateFormatForCondition() {
        return "yyyy-MM-dd";
    }

    @Override
    public String setLimit(String srcSql, int limit, int offset) throws Exception {
        StringBuilder sb = new StringBuilder(srcSql.length() + 20);
        sb.append(srcSql);
        if (limit > 0) {
            sb.append(" LIMIT " + limit);
        }
        if (offset > 0) {
            sb.append(" OFFSET " + offset);
        }
        return sb.toString();
    }

    @Override
    public String func_substring(String columnName, int startIndex, int length) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("MID(");
        sb.append(columnName);
        if (length > 0) {
            sb.append("," + length);
        }
        if (length > 0) {
            sb.append("," + length);
        }
        return sb.toString();
    }

    @Override
    public String func_substring(String columnName, int startIndex) throws Exception {
        return this.func_substring(columnName, startIndex, -1);
    }

    @Override
    public String createCreateTableQuery_primaryKey(MmdModel mmdModel, String lineSep) throws Exception {
        StringBuilder sb = new StringBuilder();
        MmdIndex primaryKey = mmdModel.getPrimaryIndex();
        if (primaryKey != null) {
            sb.append("PRIMARY KEY");
            sb.append(" (");
            int i = 0;
            while (i < primaryKey.indexElementList.size()) {
                MmdIndexElement indexElement = primaryKey.indexElementList.get(i);
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(indexElement.columnName);
                ++i;
            }
            sb.append(")");
            sb.append(lineSep);
        }
        return sb.toString();
    }

    @Override
    public String createBinaryInsert(byte[] bytes) throws Exception {
        String hex = new String(Hex.encodeHex((byte[])bytes));
        return "UNHEX(" + BcStringUtil.singleQuotation(hex) + ")";
    }
}

