/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.sql.context;

import ext.base.core.BcUnicode;
import ext.base.mmd.MmdField;
import ext.lib.sql.SqlConstants;
import ext.lib.sql.SqlDefinitionCondition;
import ext.lib.sql.context.SqlContext;
import java.util.HashMap;
import java.util.Map;

public class SqlContext_DB2
extends SqlContext {
    public static final String DRIVER_CLASS_NAME = "com.ibm.db2.jcc.DB2Driver";
    public static final String[] DRIVER_CLASS_NAMES = new String[]{"com.ibm.db2.jcc.DB2Driver"};
    public static final int PORT_DEFAULT = 50000;
    private Map<Character, String> escapeCharacterMap;

    public SqlContext_DB2(SqlConstants.DatabaseProduct databaseProduct) {
        super(databaseProduct);
    }

    @Override
    public boolean isSupported(SqlContext.Function function) {
        switch (function) {
            case resultSetScroll: {
                return false;
            }
        }
        return true;
    }

    @Override
    public String[] getDriverClassNames() {
        return DRIVER_CLASS_NAMES;
    }

    @Override
    public int getDefaultPort() {
        return 50000;
    }

    @Override
    public Map<Character, String> getEscapeCharacterMap() {
        if (this.escapeCharacterMap == null) {
            this.escapeCharacterMap = new HashMap<Character, String>();
            this.escapeCharacterMap.put(Character.valueOf(BcUnicode.Unicode.BS.char_), String.valueOf(String.valueOf(BcUnicode.Unicode.reverseSolidus.char_)) + String.valueOf(BcUnicode.Unicode.BS.char_));
            this.escapeCharacterMap.put(Character.valueOf(BcUnicode.Unicode.HT.char_), String.valueOf(String.valueOf(BcUnicode.Unicode.reverseSolidus.char_)) + String.valueOf(BcUnicode.Unicode.HT.char_));
            this.escapeCharacterMap.put(Character.valueOf(BcUnicode.Unicode.LF.char_), String.valueOf(String.valueOf(BcUnicode.Unicode.reverseSolidus.char_)) + String.valueOf(BcUnicode.Unicode.LF.char_));
            this.escapeCharacterMap.put(Character.valueOf(BcUnicode.Unicode.FF.char_), String.valueOf(String.valueOf(BcUnicode.Unicode.reverseSolidus.char_)) + String.valueOf(BcUnicode.Unicode.FF.char_));
            this.escapeCharacterMap.put(Character.valueOf(BcUnicode.Unicode.CR.char_), String.valueOf(String.valueOf(BcUnicode.Unicode.reverseSolidus.char_)) + String.valueOf(BcUnicode.Unicode.CR.char_));
            this.escapeCharacterMap.put(Character.valueOf(BcUnicode.Unicode.apostrophe.char_), String.valueOf(String.valueOf(BcUnicode.Unicode.apostrophe.char_)) + String.valueOf(BcUnicode.Unicode.apostrophe.char_));
        }
        return this.escapeCharacterMap;
    }

    @Override
    public String type_NUMBER(MmdField mmdField, SqlDefinitionCondition definitionCondition) throws Exception {
        String definition = null;
        switch (mmdField.sqlTypeId) {
            case -6: {
                definition = "SMALLINT";
                break;
            }
            case 2: 
            case 3: {
                if (mmdField.dataSize < 1 || mmdField.dataSize > 31 || mmdField.decimalDigit > 30) break;
                definition = "DECIMAL(" + mmdField.dataSize + ", " + mmdField.decimalDigit + ")";
                break;
            }
            default: {
                definition = super.type_NUMBER(mmdField, definitionCondition);
            }
        }
        return definition;
    }

    @Override
    public String type_BINARY(MmdField mmdField, SqlDefinitionCondition definitionCondition) throws Exception {
        String definition = null;
        switch (mmdField.sqlTypeId) {
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                definition = "BLOB";
            }
        }
        return definition;
    }

    @Override
    public String setLimit(String srcSql, int limit, int offset) throws Exception {
        StringBuilder sb = new StringBuilder(srcSql.length() + 20);
        sb.append(srcSql);
        if (limit > 0) {
            sb.append(" LIMIT " + limit);
        }
        if (offset > 0) {
            sb.append(" OFFSET " + offset);
        }
        return sb.toString();
    }

    @Override
    public String func_substring(String columnName, int startIndex, int length) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("SUBSTR(");
        sb.append(columnName);
        if (length > 0) {
            sb.append("," + length);
        }
        if (length > 0) {
            sb.append("," + length);
        }
        return sb.toString();
    }

    @Override
    public String func_substring(String columnName, int startIndex) throws Exception {
        return this.func_substring(columnName, startIndex, -1);
    }
}

