/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.sql.context;

import ext.base.core.BcStringUtil;
import ext.base.core.BcTimeUtil;
import ext.base.log.BcLogUtil;
import ext.base.mmd.MmdField;
import ext.base.mmd.MmdIndex;
import ext.base.mmd.MmdModel;
import ext.lib.sql.SqlConnection;
import ext.lib.sql.SqlConstants;
import ext.lib.sql.SqlDefinitionCondition;
import ext.lib.sql.SqlResultSet;
import ext.lib.sql.SqlResultSet_Access;
import ext.lib.sql.SqlStatement;
import ext.lib.sql.SqlUtil;
import ext.lib.sql.context.SqlContext;
import ext.lib.sql.context.SqlTableMetadata;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.JDBCType;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Map;
import java.util.Properties;

public class SqlContext_Access
extends SqlContext {
    public static final String DRIVER_CLASS_NAME = "sun.jdbc.odbc.JdbcOdbcDriver";
    public static final String[] DRIVER_CLASS_NAMES = new String[]{"sun.jdbc.odbc.JdbcOdbcDriver"};
    public static final String URL_PREFIX = "jdbc:odbc:Driver";
    public static final String DBQ = "DBQ";

    public SqlContext_Access(SqlConstants.DatabaseProduct databaseProduct) {
        super(databaseProduct);
    }

    @Override
    public boolean isSupported(SqlContext.Function function) {
        switch (function) {
            case connectionIsValid: {
                return false;
            }
            case statementIsClosed: {
                return false;
            }
            case queryTimeout: {
                return false;
            }
            case selectForUpdate: {
                return false;
            }
            case resultSetScroll: {
                return false;
            }
            case inputStreamAvailable: {
                return false;
            }
        }
        return true;
    }

    @Override
    public String[] getDriverClassNames() {
        return DRIVER_CLASS_NAMES;
    }

    @Override
    public void setTransactionIsolation(Connection sqlConn) throws Exception {
    }

    @Override
    public String func_substring(String columnName, int startIndex) throws Exception {
        return this.func_substring(columnName, startIndex, -1);
    }

    @Override
    public String getEncoding() throws Exception {
        return "SJIS";
    }

    @Override
    protected void getTableMetadata(ResultSet rs, SqlTableMetadata tableMetadata) throws Exception {
        tableMetadata.TABLE_CAT = rs.getString("TABLE_CAT");
        tableMetadata.TABLE_SCHEM = rs.getString("TABLE_SCHEM");
        tableMetadata.TABLE_NAME = rs.getString("TABLE_NAME");
        tableMetadata.TABLE_TYPE = rs.getString("TABLE_TYPE");
        tableMetadata.REMARKS = rs.getString("REMARKS");
    }

    @Override
    public String type_NUMBER(MmdField mmdField, SqlDefinitionCondition definitionCondition) throws Exception {
        String definition = null;
        switch (mmdField.sqlTypeId) {
            case -6: 
            case 5: {
                definition = "INTEGER";
                break;
            }
            case 4: {
                definition = "LONG";
                break;
            }
            case -5: {
                definition = "MONEY";
                break;
            }
            case 6: 
            case 7: {
                definition = "SINGLE";
                break;
            }
            case 8: {
                definition = "DOUBLE";
                break;
            }
            case 2: 
            case 3: {
                if (mmdField.dataSize > 15) break;
                definition = "MONEY(" + mmdField.dataSize + ", " + mmdField.decimalDigit + ")";
            }
        }
        return definition;
    }

    @Override
    public String type_CHAR(MmdField mmdField, SqlDefinitionCondition definitionCondition) throws Exception {
        String definition = null;
        switch (mmdField.sqlTypeId) {
            case 1: {
                if (mmdField.dataSize > 255) break;
                definition = "CHAR(" + mmdField.dataSize + ")";
                break;
            }
            case -1: 
            case 12: 
            case 2005: {
                definition = "TEXT";
            }
        }
        return definition;
    }

    @Override
    public String type_TIME(MmdField mmdField, SqlDefinitionCondition definitionCondition) throws Exception {
        String definition = null;
        switch (mmdField.sqlTypeId) {
            case 91: 
            case 92: {
                definition = super.type_TIME(mmdField, definitionCondition);
                break;
            }
            case 93: {
                definition = "DATETIME";
            }
        }
        return definition;
    }

    @Override
    public String type_BIT_BOOLEAN(MmdField mmdField, SqlDefinitionCondition definitionCondition) throws Exception {
        String definition = null;
        switch (mmdField.sqlTypeId) {
            case -7: 
            case 16: {
                definition = "BIT";
            }
        }
        return definition;
    }

    @Override
    public String type_BINARY(MmdField mmdField, SqlDefinitionCondition definitionCondition) throws Exception {
        return "LONGBINARY";
    }

    @Override
    public void setNull_LONGVARBINARY(PreparedStatement ppst, int colmunIndex) throws Exception {
        JDBCType[] jDBCTypeArray = JDBCType.values();
        int n = jDBCTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            JDBCType jdbcType = jDBCTypeArray[n2];
            try {
                this.getLogger().warning("colmunIndex=" + colmunIndex + " jdbcType=" + jdbcType);
                ppst.setNull(colmunIndex, jdbcType.getVendorTypeNumber());
                break;
            }
            catch (Exception ex) {
                this.getLogger().error(ex);
                ++n2;
            }
        }
    }

    @Override
    public void setNull_BLOB(PreparedStatement ppst, int colmunIndex) throws Exception {
        JDBCType[] jDBCTypeArray = JDBCType.values();
        int n = jDBCTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            JDBCType jdbcType = jDBCTypeArray[n2];
            try {
                this.getLogger().warning("colmunIndex=" + colmunIndex + " jdbcType=" + jdbcType);
                ppst.setNull(colmunIndex, jdbcType.getVendorTypeNumber());
                break;
            }
            catch (Exception ex) {
                this.getLogger().error(ex);
                ++n2;
            }
        }
    }

    @Override
    public Object toJdbcValue(Object srcValue, int targetSqlTypeId) throws Exception {
        if (srcValue == null) {
            return null;
        }
        Class<?> javaClassType = srcValue.getClass();
        if (Long.class.isAssignableFrom(javaClassType)) {
            return BigDecimal.valueOf((Long)srcValue);
        }
        return super.toJdbcValue(srcValue, -targetSqlTypeId);
    }

    @Override
    public String escapeEncode(String srcStr) throws Exception {
        StringBuilder sb = new StringBuilder();
        if (srcStr == null) {
            return sb.toString();
        }
        char curChar = '\u0000';
        int i = 0;
        while (i < srcStr.length()) {
            curChar = srcStr.charAt(i);
            switch (curChar) {
                case '\'': {
                    sb.append('\'');
                    sb.append('\'');
                    break;
                }
                default: {
                    sb.append(curChar);
                }
            }
            ++i;
        }
        return sb.toString();
    }

    @Override
    public String setLimit(String srcQuery, int limit, int offset) throws Exception {
        StringBuilder sb = new StringBuilder();
        if (limit > 0) {
            String tmpStr = srcQuery.toString().toUpperCase();
            int pos = tmpStr.indexOf("SELECT");
            sb.append(srcQuery.subSequence(0, pos + 6));
            sb.append(" TOP " + limit);
            sb.append(srcQuery.subSequence(pos + 6, srcQuery.length()));
        }
        if (offset > 0) {
            throw new Exception("not suported 'OFFSET'");
        }
        return sb.toString();
    }

    @Override
    public String getDateFormatForCondition() {
        return "MM-dd-yyyy";
    }

    @Override
    public String toCondition_timestamp(Calendar calendar) {
        return "#" + BcTimeUtil.toString(calendar, this.getTimestampFormatForCondition()) + "#";
    }

    @Override
    public String toCondition_datetime(Calendar calendar) {
        return "#" + BcTimeUtil.toString(calendar, this.getDateFormatForCondition()) + "#";
    }

    @Override
    public String toCondition_date(Calendar calendar) {
        return "#" + BcTimeUtil.toString(calendar, this.getDateFormatForCondition()) + "#";
    }

    @Override
    public int dropView(SqlConnection sqlConn, String viewName) throws Exception {
        String sql = "DROP TABLE " + viewName;
        this.getLogger().info("sql=" + sql);
        return SqlUtil.executeUpdate(sqlConn, sql);
    }

    @Override
    public MmdModel convertReservedWord(MmdModel mmdModel) throws Exception {
        MmdModel mmdModel2 = (MmdModel)mmdModel.clone();
        int i = 0;
        while (i < mmdModel2.getFieldCount()) {
            MmdField mmdField = mmdModel2.getField(i);
            if (BcStringUtil.equalsIgnoreCase(mmdField.columnName, "note")) {
                mmdField.columnName = "note_";
                mmdField.tableColumnName = BcStringUtil.replace((CharSequence)mmdField.tableColumnName, "note", "note_").toString();
            }
            ++i;
        }
        return mmdModel2;
    }

    @Override
    public String func_toChar(String columnName, String format) throws Exception {
        String formatStr;
        int idx;
        StringBuilder sb = new StringBuilder();
        sb.append("STR(");
        sb.append(columnName);
        int decimal = -1;
        int length = -1;
        if (!BcStringUtil.isEmpty(format) && (idx = (formatStr = format.toString()).indexOf(46)) >= 0) {
            decimal = formatStr.substring(idx).length();
        }
        if (length > 0) {
            sb.append("," + length);
        }
        if (decimal > 0) {
            sb.append("," + decimal);
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public String func_toChar(String columnName) throws Exception {
        return this.func_toChar(columnName, null);
    }

    @Override
    public String func_substring(String columnName, int startIndex, int length) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("MID(");
        sb.append(columnName);
        if (startIndex > 0) {
            sb.append("," + startIndex);
        }
        if (length > 0) {
            sb.append("," + length);
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public String func_clockTimestamp() throws Exception {
        return "Now()";
    }

    @Override
    public int truncateTable(SqlConnection sqlConn, String tableName) throws Exception {
        return this.deleteAllRow(sqlConn, tableName);
    }

    @Override
    public MmdIndex getPrimaryKey(SqlConnection sqlConn, String tableName) throws Exception {
        return null;
    }

    @Override
    public String getPrimaryKeyName(SqlConnection sqlConn, String tableName) throws Exception {
        return null;
    }

    @Override
    public String convertSql(String srcSql, Map<String, String> paramMap, SqlContext baseSqlContext) throws Exception {
        String tableName;
        BcLogUtil.debug("convertQuery:srcSql=" + srcSql);
        BcLogUtil.debug("convertQuery:paramMap=" + paramMap);
        StringBuilder sb = new StringBuilder(srcSql);
        sb = BcStringUtil.replace(sb, " BIGINT ", " MONEY ", false);
        sb = BcStringUtil.replace(sb, " CHARACTER(", " VARCHAR(", false);
        sb = BcStringUtil.replace(sb, " TEXT ", " LONGTEXT ", false);
        sb = BcStringUtil.replace(sb, " BYTEA ", " LONGBINARY ", false);
        sb = BcStringUtil.replace(sb, "DROP VIEW", "DROP TABLE", false);
        if (srcSql.toUpperCase().indexOf("DROP INDEX") >= 0 && !BcStringUtil.isEmpty(tableName = paramMap.get("$TABLE_NAME"))) {
            sb.append(" ON " + tableName);
        }
        sb = BcStringUtil.replace(sb, "without time zone", "", false);
        sb = BcStringUtil.replace(sb, "USING btree", "", false);
        sb = BcStringUtil.replace(sb, "ALTER TABLE ONLY", "ALTER TABLE", false);
        sb = this.conv1(sb.toString(), "DECIMAL", "MONEY");
        return sb.toString();
    }

    @Override
    public SqlResultSet convToSqlResultSet(ResultSet rs, SqlStatement sqlStatement) throws SQLException {
        return new SqlResultSet_Access(rs, sqlStatement);
    }

    public StringBuilder conv1(String src, String rep1, String rep2) throws Exception {
        String tmpStr = src.toString();
        int idx1;
        while ((idx1 = tmpStr.toUpperCase().indexOf(" " + rep1 + "(")) >= 0) {
            StringBuilder sb = new StringBuilder();
            sb.append(tmpStr.substring(0, idx1));
            String rest = tmpStr.substring(idx1);
            int idx2 = rest.indexOf(")");
            sb.append(" " + rep2);
            sb.append(rest.substring(idx2 + 1));
            tmpStr = sb.toString();
        }
        return new StringBuilder(tmpStr);
    }

    public static String createUrl(String filePath) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("jdbc:odbc:Driver=");
        sb.append("{Microsoft Access Driver (*.mdb)}");
        sb.append(";");
        sb.append("DBQ=");
        sb.append(filePath);
        return sb.toString();
    }

    public static String extractDBQ(String jdbcUrl) throws Exception {
        int idx1 = jdbcUrl.indexOf(DBQ);
        if (idx1 <= 0) {
            return null;
        }
        String tmp1 = jdbcUrl.substring(idx1 + DBQ.length()).trim();
        String filePath = tmp1.substring(1);
        BcLogUtil.debug("filePath=" + filePath);
        return filePath;
    }

    public static void setProperty(Properties dtsProps) throws Exception {
        dtsProps.setProperty("charSet", "SJIS");
    }
}

