/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.nlp;

import ext.base.core.BcConstants;
import ext.base.io.BcStreamFilter;
import ext.base.io.BcStreamTransmitter;
import ext.base.log.BcLogUtil;
import ext.base.log.BcLogger;
import ext.base.table.BcTableModel;
import ext.base.util.BcCollectionUtil;
import ext.base.util.BcCsvUtil;
import ext.lib.nlp.NlpElement;
import ext.lib.nlp.NlpNoun;
import ext.lib.nlp.NlpResult;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.LinkedHashMap;
import java.util.Map;

public class NlpPersonNameUtil {
    public static String key = "ABRACADABRA";
    public static String personNameDat = "person_name.dat";
    public static String personLastNameDat = "person_last_name.dat";
    public static String personFirstNameManDat = "person_first_name_man.dat";
    public static String personFirstNameWomanDat = "person_first_name_woman.dat";

    public static ByteArrayInputStream decode(InputStream is) throws Exception {
        InneerStreamTransmitter streamTransmitter = new InneerStreamTransmitter();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        streamTransmitter.transmit(is, baos);
        is.close();
        byte[] bytes = baos.toByteArray();
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        return bais;
    }

    public static Map<String, NlpNoun> createNounMap(InputStream is) throws Exception {
        InputStreamReader inputStreamReader = new InputStreamReader(is, BcConstants.charset);
        BcTableModel tableModel = BcCsvUtil.csvToTable(inputStreamReader, -1);
        LinkedHashMap<String, NlpNoun> nounMap = new LinkedHashMap<String, NlpNoun>();
        int i = 0;
        while (i < tableModel.getRowCount()) {
            NlpNoun noun = new NlpNoun();
            noun.key = (String)tableModel.getValueAt(i, 0);
            noun.name = (String)tableModel.getValueAt(i, 1);
            noun.reading = (String)tableModel.getValueAt(i, 2);
            noun.score = 2;
            nounMap.put(noun.key, noun);
            ++i;
        }
        return nounMap;
    }

    public static void dispResult(NlpResult nlpResult) throws Exception {
        BcLogger logger = BcLogUtil.getDefaultLogger();
        if (!BcCollectionUtil.isEmpty(nlpResult.elementList)) {
            int i = 0;
            while (i < nlpResult.elementList.size()) {
                NlpElement nlpElement = nlpResult.elementList.get(i);
                NlpNoun noun = nlpElement.noun;
                logger.debug("noun.key=" + noun.key + ": " + noun.name + " " + noun.reading);
                ++i;
            }
        }
    }

    public static class InneerStreamTransmitter
    extends BcStreamTransmitter {
        BcStreamFilter streamFilter = new BcStreamFilter(key);

        public InneerStreamTransmitter() {
            this.setBufferSize(1024000);
        }

        @Override
        protected byte[] read(byte[] bytes, int length) {
            byte[] bytes2 = new byte[bytes.length];
            int i = 0;
            while (i < bytes.length) {
                if (i < length) {
                    byte filter = this.streamFilter.getNextByte();
                    bytes2[i] = (byte)(bytes[i] ^ filter);
                } else {
                    bytes2[i] = bytes[i];
                }
                ++i;
            }
            return bytes2;
        }
    }
}

