/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.nlp;

import ext.base.core.BcConstants;
import ext.base.log.BcLoggableObject;
import ext.base.table.BcTableModel;
import ext.base.util.BcCsvUtil;
import ext.lib.nlp.NlpNoun;
import ext.lib.nlp.NlpResult;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.LinkedHashMap;
import java.util.Map;
import opennlp.tools.namefind.NameFinderME;
import opennlp.tools.namefind.TokenNameFinderModel;
import opennlp.tools.postag.POSModel;
import opennlp.tools.postag.POSTaggerME;
import opennlp.tools.tokenize.TokenizerME;
import opennlp.tools.tokenize.TokenizerModel;
import opennlp.tools.util.Span;

public class NlpPersonNameFinderEN
extends BcLoggableObject {
    protected TokenizerModel tokenizerModel;
    protected TokenizerME tokenizer;
    protected TokenNameFinderModel tokenNameFinderModel;
    protected Map<String, NlpNoun> nounMap;

    public void init() throws Exception {
        InputStream is = this.getClass().getResourceAsStream("en-token-1.5.bin");
        this.tokenizerModel = new TokenizerModel(is);
        this.tokenizer = new TokenizerME(this.tokenizerModel);
        is = this.getClass().getResourceAsStream("en-ner-person-1.5.bin");
        this.tokenNameFinderModel = new TokenNameFinderModel(is);
    }

    public void init(InputStream is) throws Exception {
        InputStreamReader inputStreamReader = new InputStreamReader(is, BcConstants.charset);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        BcTableModel tableModel = BcCsvUtil.csvToTable(inputStreamReader, -1);
        this.nounMap = new LinkedHashMap<String, NlpNoun>();
        int i = 0;
        while (i < tableModel.getRowCount()) {
            NlpNoun noun = new NlpNoun();
            noun.key = (String)tableModel.getValueAt(i, 0);
            noun.name = (String)tableModel.getValueAt(i, 1);
            noun.reading = (String)tableModel.getValueAt(i, 2);
            noun.score = 2;
            this.nounMap.put(noun.key, noun);
            ++i;
        }
        this.getLogger().debug("NlpPersonNameFinderEN:nounMap.size()=" + this.nounMap.size());
    }

    public NlpResult find(String src) throws Exception {
        Span[] nameSpans;
        Span[] tokens = this.tokenizer.tokenizePos(src);
        double[] probs = this.tokenizer.getTokenProbabilities();
        Span[] spanArray = tokens;
        int n = tokens.length;
        int n2 = 0;
        while (n2 < n) {
            Span token = spanArray[n2];
            System.out.println(token + " " + src.substring(token.getStart(), token.getEnd()) + " type=" + token.getType() + " prob=" + token.getProb());
            ++n2;
        }
        System.out.println("  ");
        int i = 0;
        while (i < probs.length) {
            System.out.println(probs[i]);
            ++i;
        }
        String[] tokens2 = this.tokenizer.tokenize(src);
        NameFinderME nameFinder = new NameFinderME(this.tokenNameFinderModel);
        Span[] spanArray2 = nameSpans = nameFinder.find(tokens2);
        int n3 = nameSpans.length;
        int n4 = 0;
        while (n4 < n3) {
            Span s = spanArray2[n4];
            System.out.println(String.valueOf(s.toString()) + "  " + tokens[s.getStart()]);
            ++n4;
        }
        InputStream modelIn = this.getClass().getResourceAsStream("en-pos-maxent-1.5.bin");
        POSModel model = new POSModel(modelIn);
        POSTaggerME tagger = new POSTaggerME(model);
        modelIn.close();
        String[] sentenceArray = src.split(" ", 0);
        String[] tags = tagger.tag(sentenceArray);
        int i2 = 0;
        while (i2 < sentenceArray.length) {
            System.out.println(String.valueOf(sentenceArray[i2]) + "\t" + tags[i2]);
            ++i2;
        }
        NlpResult nlpResult = new NlpResult();
        return nlpResult;
    }
}

