/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.fx.control;

import ext.base.core.BcStringUtil;
import ext.base.log.BcLogUtil;
import ext.lib.fx.skin.FxCssUtil;
import ext.lib.fx.util.FxUtil;
import ext.lib.swg.SwgUtil;
import java.util.regex.Pattern;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.control.PasswordField;
import javafx.scene.control.TextField;
import javafx.scene.control.TextInputControl;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;

public class FxPasswordField
extends PasswordField {
    protected boolean changed;
    public int maxLength = -1;
    public Pattern pattern;
    protected String firstStyle;
    protected boolean styleChangeFlag;

    public FxPasswordField() {
        this.setAlignment(Pos.CENTER_LEFT);
        this.init();
    }

    protected void init() {
        this.addEventFilter(KeyEvent.KEY_PRESSED, (EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent ev) {
                try {
                    FxPasswordField.this.keyPressed(ev);
                }
                catch (Exception ex) {
                    FxPasswordField.this.handleException(ex);
                }
            }
        });
        this.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                try {
                    if (newValue.booleanValue()) {
                        FxPasswordField.this.focusIn();
                    } else {
                        FxPasswordField.this.focusOut();
                    }
                }
                catch (Exception ex) {
                    FxPasswordField.this.handleException(ex);
                }
            }
        });
        this.styleProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                try {
                    FxPasswordField.this.styleChanged(oldValue, newValue);
                }
                catch (Exception ex) {
                    FxPasswordField.this.handleException(ex);
                }
            }
        });
        this.editableProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                try {
                    FxPasswordField.this.editableChanged(newValue, true);
                }
                catch (Exception ex) {
                    FxPasswordField.this.handleException(ex);
                }
            }
        });
        this.prefColumnCountProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                try {
                    FxPasswordField.this.prefColumnCountChanged(oldValue, newValue);
                }
                catch (Exception ex) {
                    FxPasswordField.this.handleException(ex);
                }
            }
        });
    }

    public void replaceText(int start, int end, String text) {
        this.changed = true;
        if (BcStringUtil.isEmpty(text)) {
            super.replaceText(start, end, text);
        } else if (this.maxLength > 0 && this.getLength() < this.maxLength) {
            if (this.pattern.matcher(text).find()) {
                super.replaceText(start, end, text);
            }
        } else {
            super.replaceText(start, end, text);
        }
    }

    public void replaceSelection(String text) {
        this.changed = true;
        if (BcStringUtil.isEmpty(text)) {
            super.replaceSelection(text);
        } else if (this.maxLength > 0 && this.getLength() < this.maxLength) {
            if (this.pattern.matcher(text).find()) {
                super.replaceSelection(text);
            }
        } else {
            super.replaceSelection(text);
        }
    }

    public void cut() {
        super.cut();
        this.changed = true;
    }

    public void paste() {
        super.paste();
        this.changed = true;
    }

    public void keyPressed(KeyEvent ev) throws Exception {
        if (KeyCode.ENTER.equals((Object)ev.getCode())) {
            this.changed = true;
            this.focusOut();
        }
    }

    public void focusIn() throws Exception {
    }

    public void focusOut() throws Exception {
        if (this.changed) {
            this.changed = false;
            this.selectEnd();
            this.textEdited(this.getText());
        }
    }

    public void styleChanged(String oldValue, String newValue) throws Exception {
        if (BcStringUtil.isEmpty(this.firstStyle)) {
            this.firstStyle = newValue;
        }
        if (this.styleChangeFlag) {
            this.styleChangeFlag = false;
            return;
        }
        if (!this.isEditable()) {
            this.styleChangeFlag = true;
            FxCssUtil.setStyle_form_01((TextInputControl)this);
        }
        FxUtil.setPrefSize_TextField((TextField)this);
    }

    public void editableChanged(boolean editable, boolean b) throws Exception {
        BcLogUtil.debug("editableChanged\uff1a");
    }

    public void prefColumnCountChanged(Number oldValue, Number newValue) throws Exception {
        FxUtil.setPrefSize_TextField((TextField)this);
    }

    public void textEdited(String text) {
    }

    protected void handleException(Throwable throwable) {
        SwgUtil.getExceptionHandler().handleException(throwable, (Object)this);
    }
}

