/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.doc.poi;

import ext.base.core.BcNumberUtil;
import ext.base.core.BcStringUtil;
import ext.base.log.BcLoggableObject;
import ext.lib.doc.script.DcfScriptParser;
import ext.lib.doc.script.DcfScriptUtil;
import ext.lib.doc.util.DcfConstants;
import ext.lib.doc.util.DcfDocumentUtil;
import ext.lib.doc.util.DcfPageWriter;
import ext.lib.poi.PoiWorkbookUtil;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.print.attribute.standard.MediaSize;
import nlc.lib.doc.DcfPage;
import nlc.lib.doc.DcfParagraph;
import nlc.lib.doc.shape.DcfArcShape;
import nlc.lib.doc.shape.DcfLineShape;
import nlc.lib.doc.shape.DcfShapeGroup;
import nlc.lib.doc.shape.DcfTextShape;
import nlc.lib.doc.shape.barcode.DcfDataMatrixShape;
import org.apache.poi.hssf.usermodel.HSSFAnchor;
import org.apache.poi.hssf.usermodel.HSSFClientAnchor;
import org.apache.poi.hssf.usermodel.HSSFPalette;
import org.apache.poi.hssf.usermodel.HSSFPatriarch;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFShape;
import org.apache.poi.hssf.usermodel.HSSFSimpleShape;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Footer;
import org.apache.poi.ss.usermodel.Header;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.PrintSetup;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.model.StylesTable;
import org.apache.poi.xssf.streaming.SXSSFDrawing;
import org.apache.poi.xssf.usermodel.XSSFDrawing;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.apache.poi.xssf.usermodel.XSSFShape;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class DcfExcel2Book
extends BcLoggableObject {
    protected Workbook ssWorkbook;
    protected DcfPageWriter pageWriter;
    protected Sheet ssSheet;
    protected String sheetName;
    protected Map<String, RegionContext> regionMap;
    protected double pxOffset = 12.8;
    protected double pyOffset = 12.8;
    protected double heightCoeficient = 0.948;
    protected double widthCoeficient = 46.6;
    protected double zx = 0.3937007874015748;
    protected DcfScriptParser scriptParser = new DcfScriptParser();

    public static String createRegionMapKey(int rowNum, int columnNum) throws Exception {
        return String.valueOf(rowNum) + "-" + columnNum;
    }

    public double getXOffset() {
        return this.pxOffset;
    }

    public void setXOffset(double pxOffset) {
        this.pxOffset = pxOffset;
    }

    public double getYOffset() {
        return 0.0;
    }

    public void setYOffset(double pyOffset) {
        this.pyOffset = pyOffset;
    }

    public double getHeightCoeficient() {
        return this.heightCoeficient;
    }

    public void setHeightCoeficient(double heightCoeficient) {
        this.heightCoeficient = heightCoeficient;
    }

    public double getWidthCoeficient() {
        return this.widthCoeficient;
    }

    public void setWidthCoeficient(double widthCoeficient) {
        this.widthCoeficient = widthCoeficient;
    }

    protected double rowHeightExchange(double poiRowHeight) throws Exception {
        return DcfDocumentUtil.inch72ToPixel(poiRowHeight / 20.0) * this.heightCoeficient;
    }

    protected double columnWidthExchange(double poiColumnWidth) throws Exception {
        return poiColumnWidth / this.widthCoeficient;
    }

    protected java.awt.Font convFont(Font ssFont) throws Exception {
        int fontStyle = 0;
        if (ssFont.getItalic()) {
            fontStyle += 2;
        }
        if (ssFont.getBold()) {
            ++fontStyle;
        }
        if (ssFont.getStrikeout()) {
            this.getLogger().warning("\u300c\u6253\u6d88\u3057\u7dda\u300d\u3092\u30b5\u30dd\u30fc\u30c8\u3057\u307e\u305b\u3093\u3002");
        }
        java.awt.Font awtFont = new java.awt.Font(ssFont.getFontName(), fontStyle, ssFont.getFontHeightInPoints());
        return awtFont;
    }

    public synchronized void convToDcfBook(Workbook ssWorkbook, DcfPageWriter pageWriter) throws Exception {
        this.ssWorkbook = ssWorkbook;
        this.pageWriter = pageWriter;
        this.regionMap = null;
        int i = 0;
        while (i < ssWorkbook.getNumberOfSheets()) {
            String tmp1;
            this.ssSheet = ssWorkbook.getSheetAt(i);
            this.sheetName = ssWorkbook.getSheetName(i);
            String printArea = ssWorkbook.getPrintArea(i);
            if (!BcStringUtil.isEmpty(printArea) && (tmp1 = printArea.substring(printArea.indexOf("!") + 1)).indexOf(":") >= 0) {
                String cell1 = tmp1.substring(0, tmp1.indexOf(":"));
                List<String> tokenList = BcStringUtil.stringTokenize(cell1, "$", false, true);
                int cell1_col = PoiWorkbookUtil.toColumnIndex(tokenList.get(0));
                int cell1_row = BcNumberUtil.parseInteger(tokenList.get(1)) - 1;
                String cell2 = tmp1.substring(tmp1.indexOf(":") + 1);
                tokenList = BcStringUtil.stringTokenize(cell2, "$", false, true);
                int cell2_col = PoiWorkbookUtil.toColumnIndex(tokenList.get(0));
                int n = BcNumberUtil.parseInteger(tokenList.get(1)) - 1;
            }
            this.convSheet();
            ++i;
        }
    }

    protected void convSheet() throws Exception {
        Header ssHeader = this.ssSheet.getHeader();
        Footer ssFotter = this.ssSheet.getFooter();
        DcfPage dcfPage = new DcfPage();
        this.setPageAttrubute(this.ssSheet, dcfPage);
        DcfShapeGroup shapeGroup = new DcfShapeGroup();
        double leftMargin = this.ssSheet.getMargin((short)0) / this.zx;
        double topMargin = this.ssSheet.getMargin((short)2) / this.zx;
        shapeGroup.setX(DcfDocumentUtil.mmToPixel(leftMargin * 10.0));
        shapeGroup.setY(DcfDocumentUtil.mmToPixel(topMargin * 10.0));
        shapeGroup.setWidth(dcfPage.getPageFormat().getImageableWidth());
        shapeGroup.setHeight(dcfPage.getPageFormat().getImageableHeight());
        dcfPage.addGroup(shapeGroup);
        this.createRegionMap(this.ssSheet);
        double yPoi = 0.0;
        Iterator iterator = this.ssSheet.rowIterator();
        while (iterator.hasNext()) {
            Row ssRow = (Row)iterator.next();
            this.convRow(ssRow, ssRow.getRowNum(), yPoi, shapeGroup);
            yPoi += (double)ssRow.getHeight();
        }
        this.convDrawing(shapeGroup);
        this.pageWriter.addPage(dcfPage);
    }

    protected void convRow(Row ssRow, int rowId, double yPoi, DcfShapeGroup shapeGroup) throws Exception {
        double xPoi = 0.0;
        int i = 0;
        while (i < ssRow.getLastCellNum()) {
            Cell ssCell = ssRow.getCell(i);
            if (ssCell != null) {
                String key = DcfExcel2Book.createRegionMapKey(rowId, i);
                RegionContext regionContext = this.regionMap.get(key);
                this.convCell(ssRow, ssCell, rowId, i, xPoi, yPoi, shapeGroup, regionContext);
            }
            xPoi += (double)this.ssSheet.getColumnWidth(i);
            ++i;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void convCell(Row ssRow, Cell ssCell, int rowId, int columnId, double xPoi, double yPoi, DcfShapeGroup shapeGroup, RegionContext regionContext) throws Exception {
        String cellValueStr;
        DcfLineShape lineShape;
        double cellHeightPixel = 0.0;
        double cellWidthPixel = 0.0;
        CellStyle cellStyle1 = null;
        CellStyle cellStyle2 = null;
        if (regionContext != null) {
            if (rowId != regionContext.cellRangeAddress.getFirstRow() || columnId != regionContext.cellRangeAddress.getFirstColumn()) return;
            cellStyle1 = ssCell.getCellStyle();
            cellHeightPixel = this.rowHeightExchange(regionContext.rectangle2D.height);
            cellWidthPixel = this.columnWidthExchange(regionContext.rectangle2D.width);
            Row ssRow2 = this.ssSheet.getRow(regionContext.cellRangeAddress.getLastRow());
            Cell ssCell2 = ssRow2.getCell(regionContext.cellRangeAddress.getLastColumn());
            cellStyle2 = ssCell2.getCellStyle();
        } else {
            cellStyle1 = ssCell.getCellStyle();
            cellStyle2 = ssCell.getCellStyle();
            cellHeightPixel = this.rowHeightExchange(ssRow.getHeight());
            cellWidthPixel = this.columnWidthExchange(this.ssSheet.getColumnWidth(columnId));
        }
        double yPixel = this.pyOffset + this.rowHeightExchange(yPoi);
        double xPixel = this.pxOffset + this.columnWidthExchange(xPoi);
        if (cellStyle1.getBorderTop() != BorderStyle.NONE) {
            lineShape = new DcfLineShape(null, xPixel, yPixel, xPixel + cellWidthPixel, yPixel);
            this.convLineType(lineShape, cellStyle1.getBorderTop());
            shapeGroup.addShape(lineShape);
        }
        if (cellStyle1.getBorderLeft() != BorderStyle.NONE) {
            lineShape = new DcfLineShape(null, xPixel, yPixel, xPixel, yPixel + cellHeightPixel);
            this.convLineType(lineShape, cellStyle1.getBorderLeft());
            shapeGroup.addShape(lineShape);
        }
        if (cellStyle2.getBorderRight() != BorderStyle.NONE) {
            lineShape = new DcfLineShape(null, xPixel + cellWidthPixel, yPixel, xPixel + cellWidthPixel, yPixel + cellHeightPixel);
            this.convLineType(lineShape, cellStyle2.getBorderRight());
            shapeGroup.addShape(lineShape);
        }
        if (cellStyle2.getBorderBottom() != BorderStyle.NONE) {
            lineShape = new DcfLineShape(null, xPixel, yPixel + cellHeightPixel, xPixel + cellWidthPixel, yPixel + cellHeightPixel);
            this.convLineType(lineShape, cellStyle2.getBorderBottom());
            shapeGroup.addShape(lineShape);
        }
        if (BcStringUtil.isEmpty(cellValueStr = PoiWorkbookUtil.getCellValueAsString(ssCell))) {
            return;
        }
        String[] res = this.arc(shapeGroup, yPixel, xPixel, cellValueStr);
        if (res != null) {
            cellValueStr = res[0];
        }
        if (res == null && (res = this.dataMatrix(shapeGroup, yPixel, xPixel, cellValueStr)) != null) {
            cellValueStr = res[0];
        }
        DcfTextShape textShape = new DcfTextShape();
        textShape.getRectangle().setRect(xPixel, yPixel, cellWidthPixel, cellHeightPixel);
        textShape.setLine(false);
        textShape.wrapText = cellStyle1.getWrapText();
        if (textShape.wrapText) {
            textShape.doClip = true;
        }
        textShape.value = cellValueStr;
        textShape.shrinkToFit = cellStyle1.getShrinkToFit();
        if ((double)cellStyle1.getRotation() != 0.0) {
            textShape.textDegrees = PoiWorkbookUtil.is2007(this.ssWorkbook) ? (cellStyle1.getRotation() > 0 && cellStyle1.getRotation() <= 90 ? (double)cellStyle1.getRotation() : (double)((cellStyle1.getRotation() - 90) * -1)) : (double)cellStyle1.getRotation();
        }
        textShape.padding = 1.0;
        textShape.rowGap = 1.65;
        block0 : switch (cellStyle1.getAlignment()) {
            case GENERAL: {
                switch (ssCell.getCellType()) {
                    case STRING: 
                    case FORMULA: 
                    case BLANK: 
                    case BOOLEAN: 
                    case ERROR: {
                        textShape.horizontalAlign = 2;
                        break block0;
                    }
                    case NUMERIC: {
                        textShape.horizontalAlign = 4;
                        break block0;
                    }
                }
                break;
            }
            case LEFT: {
                textShape.horizontalAlign = 2;
                break;
            }
            case CENTER: 
            case CENTER_SELECTION: {
                textShape.horizontalAlign = 0;
                break;
            }
            case RIGHT: {
                textShape.horizontalAlign = 4;
                break;
            }
            case JUSTIFY: {
                textShape.horizontalAlign = 2;
                textShape.equalDistance = true;
                break;
            }
            case DISTRIBUTED: {
                textShape.horizontalAlign = 0;
                textShape.equalDistance = true;
                break;
            }
            default: {
                this.getLogger().warning("Not Support. cellStyle1.getAlignment()=" + cellStyle1.getAlignment());
            }
        }
        switch (cellStyle1.getVerticalAlignment()) {
            case TOP: {
                textShape.verticalAlign = 1;
                break;
            }
            case CENTER: {
                textShape.verticalAlign = 0;
                break;
            }
            case BOTTOM: {
                textShape.verticalAlign = 3;
                break;
            }
            case JUSTIFY: {
                textShape.verticalAlign = 1;
                textShape.equalDistance = true;
                break;
            }
            default: {
                textShape.verticalAlign = 1;
                this.getLogger().warning("Not Support. cellStyle1.getVerticalAlignment()=" + cellStyle1.getVerticalAlignment());
            }
        }
        Font ssFont = this.ssWorkbook.getFontAt(cellStyle1.getFontIndexAsInt());
        textShape.font = this.convFont(ssFont);
        DcfConstants.UnderLineType underLineType = this.convUnderLineType(ssFont.getUnderline());
        switch (underLineType) {
            case single: 
            case double_: 
            case singleAccounting: 
            case doubleAccounting: {
                textShape.hasUnderLine = true;
                break;
            }
        }
        if (ssCell.getCellType() == CellType.STRING) {
            RichTextString richTextString = ssCell.getRichStringCellValue();
            textShape.paragraphList = this.parseRichText(ssCell, richTextString);
            if (textShape.paragraphList == null && !BcStringUtil.isEmpty(cellValueStr)) {
                textShape.paragraphList = new ArrayList<DcfParagraph>();
                DcfParagraph paragraph = new DcfParagraph();
                paragraph.text = cellValueStr;
                paragraph.font = this.convFont(ssFont);
                paragraph.color = DcfConstants.DEFAULT_TEXT_COLOR;
                paragraph.underLineType = underLineType.id;
                paragraph.underLineWeight = this.calcUnderLineWeight(paragraph.font);
                paragraph.underLineColor = paragraph.color;
                textShape.paragraphList.add(paragraph);
            }
        }
        shapeGroup.addShape(textShape);
    }

    protected List<DcfParagraph> parseRichText(Cell ssCell, RichTextString richTextString) throws Exception {
        String subString;
        if (richTextString.numFormattingRuns() <= 0) {
            return null;
        }
        XSSFRichTextString xssfRichTextString = null;
        HSSFRichTextString hssfRichTextString = null;
        Workbook workbook = ssCell.getSheet().getWorkbook();
        if (PoiWorkbookUtil.is2007(workbook)) {
            xssfRichTextString = (XSSFRichTextString)richTextString;
        } else if (PoiWorkbookUtil.is1997(workbook)) {
            hssfRichTextString = (HSSFRichTextString)richTextString;
        }
        ArrayList<DcfParagraph> paragraphList = new ArrayList<DcfParagraph>();
        DcfParagraph paragraph = null;
        int indexStart = 0;
        int i = 0;
        while (i < richTextString.numFormattingRuns()) {
            int indexEnd = richTextString.getIndexOfFormattingRun(i);
            if (i > 0) {
                String subString2;
                paragraph.text = subString2 = richTextString.getString().substring(indexStart, indexEnd);
            }
            XSSFFont ssFont = null;
            if (xssfRichTextString != null) {
                ssFont = xssfRichTextString.getFontOfFormattingRun(i);
            } else if (hssfRichTextString != null) {
                short fontIndex = hssfRichTextString.getFontOfFormattingRun(i);
                ssFont = workbook.getFontAt((int)fontIndex);
            }
            DcfConstants.UnderLineType underLineType = this.convUnderLineType(ssFont.getUnderline());
            paragraph = new DcfParagraph();
            paragraph.font = this.convFont((Font)ssFont);
            paragraph.color = DcfConstants.DEFAULT_TEXT_COLOR;
            paragraph.underLineType = underLineType.id;
            paragraph.underLineWeight = this.calcUnderLineWeight(paragraph.font);
            paragraph.underLineColor = paragraph.color;
            paragraphList.add(paragraph);
            indexStart = indexEnd;
            ++i;
        }
        paragraph.text = subString = richTextString.getString().substring(indexStart);
        return paragraphList;
    }

    protected void convLineType(DcfLineShape lineShape, BorderStyle borderStyle) throws Exception {
        switch (borderStyle) {
            case NONE: {
                break;
            }
            case MEDIUM: {
                lineShape.lineWidth = 1.6;
                lineShape.lineType = DcfConstants.DEFAULT_lineType;
                break;
            }
            case THICK: {
                lineShape.lineWidth = 2.2;
                lineShape.lineType = DcfConstants.DEFAULT_lineType;
                break;
            }
            case THIN: {
                lineShape.lineWidth = 0.6;
                lineShape.lineType = DcfConstants.DEFAULT_lineType;
                break;
            }
            case DOTTED: 
            case HAIR: {
                lineShape.lineWidth = 0.3;
                lineShape.lineType = DcfConstants.LineType.dotted01.code;
                break;
            }
            case DASHED: 
            case DOUBLE: 
            case MEDIUM_DASHED: 
            case DASH_DOT: 
            case MEDIUM_DASH_DOT: 
            case DASH_DOT_DOT: 
            case MEDIUM_DASH_DOT_DOT: 
            case SLANTED_DASH_DOT: {
                lineShape.lineWidth = 0.3;
                lineShape.lineType = DcfConstants.LineType.dotted01.code;
                break;
            }
            default: {
                this.getLogger().debug("not support:borderStyle=" + borderStyle);
            }
        }
    }

    protected Rectangle2D.Double calcRegion(Sheet ssSheet, int row1, short col1, int row2, short col2) throws Exception {
        Rectangle2D.Double rectangle = new Rectangle2D.Double();
        int i = col1;
        while (i <= col2) {
            rectangle.width += (double)ssSheet.getColumnWidth(i);
            ++i;
        }
        i = row1;
        while (i <= row2) {
            Row ssRow = ssSheet.getRow(i);
            rectangle.height = ssRow == null ? (rectangle.height += (double)ssSheet.getDefaultRowHeight()) : (rectangle.height += (double)ssRow.getHeight());
            ++i;
        }
        return rectangle;
    }

    protected void createRegionMap(Sheet ssSheet) throws Exception {
        this.regionMap = new HashMap<String, RegionContext>();
        int i = 0;
        while (i < ssSheet.getNumMergedRegions()) {
            CellRangeAddress cellRangeAddress = ssSheet.getMergedRegion(i);
            RegionContext regionContext = new RegionContext();
            regionContext.rectangle2D = new Rectangle2D.Double();
            regionContext.cellRangeAddress = cellRangeAddress;
            int j = cellRangeAddress.getFirstRow();
            while (j <= cellRangeAddress.getLastRow()) {
                Row ssRow = ssSheet.getRow(j);
                regionContext.rectangle2D.height += (double)ssRow.getHeight();
                int k = cellRangeAddress.getFirstColumn();
                while (k <= cellRangeAddress.getLastColumn()) {
                    String key = DcfExcel2Book.createRegionMapKey(j, k);
                    this.regionMap.put(key, regionContext);
                    ++k;
                }
                ++j;
            }
            j = cellRangeAddress.getFirstColumn();
            while (j <= cellRangeAddress.getLastColumn()) {
                regionContext.rectangle2D.width += (double)ssSheet.getColumnWidth(j);
                ++j;
            }
            ++i;
        }
    }

    protected void setPageAttrubute(Sheet ssSheet, DcfPage dcfPage) throws Exception {
        PrintSetup ssPrintSetup = ssSheet.getPrintSetup();
        MediaSize mediaSize = null;
        switch (ssPrintSetup.getPaperSize()) {
            case 9: {
                mediaSize = MediaSize.ISO.A4;
                break;
            }
            case 11: {
                mediaSize = MediaSize.ISO.A5;
                break;
            }
            case 12: {
                mediaSize = MediaSize.ISO.B4;
                break;
            }
            default: {
                this.getLogger().debug("not support:paperSize=" + ssPrintSetup.getPaperSize());
            }
        }
        if (mediaSize != null) {
            if (ssPrintSetup.getLandscape()) {
                dcfPage.setPaperSize(mediaSize, 0);
            } else {
                dcfPage.setPaperSize(mediaSize, 1);
            }
        } else {
            dcfPage.setPaperSize(MediaSize.ISO.A4, 0);
        }
        dcfPage.title = this.sheetName;
    }

    public DcfConstants.UnderLineType convUnderLineType(byte ssUnderLineType) throws Exception {
        DcfConstants.UnderLineType underLineType = DcfConstants.UnderLineType.none;
        switch (ssUnderLineType) {
            case 0: {
                break;
            }
            case 1: {
                underLineType = DcfConstants.UnderLineType.single;
                break;
            }
            case 2: {
                underLineType = DcfConstants.UnderLineType.double_;
                break;
            }
            case 33: {
                underLineType = DcfConstants.UnderLineType.singleAccounting;
                break;
            }
            case 34: {
                underLineType = DcfConstants.UnderLineType.doubleAccounting;
            }
        }
        return underLineType;
    }

    protected void convDrawing(DcfShapeGroup shapeGroup) throws Exception {
        Drawing drawing = this.ssSheet.createDrawingPatriarch();
        if (drawing == null) {
            return;
        }
        if (drawing instanceof HSSFPatriarch) {
            HSSFPatriarch hssfPatriarch = (HSSFPatriarch)drawing;
            this.convHSSFPatriarch(shapeGroup, hssfPatriarch);
        } else if (drawing instanceof SXSSFDrawing) {
            SXSSFDrawing sxssfDrawing = (SXSSFDrawing)drawing;
            this.convSXSSFDrawing(shapeGroup, sxssfDrawing);
        } else if (drawing instanceof XSSFDrawing) {
            XSSFDrawing xssfDrawing = (XSSFDrawing)drawing;
            this.convXSSFDrawing(shapeGroup, xssfDrawing);
        } else {
            this.getLogger().warning("convDrawing:Not supported class=" + drawing.getClass().getName());
        }
    }

    protected void convHSSFPatriarch(DcfShapeGroup shapeGroup, HSSFPatriarch hssfPatriarch) throws Exception {
        List hssfShapeList = hssfPatriarch.getChildren();
        int i = 0;
        while (i < hssfShapeList.size()) {
            HSSFShape hssfShape = (HSSFShape)hssfShapeList.get(i);
            if (hssfShape instanceof HSSFSimpleShape) {
                HSSFSimpleShape hssfSimpleShape = (HSSFSimpleShape)hssfShape;
                this.convHSSFSimpleShape(shapeGroup, hssfSimpleShape);
            } else {
                this.getLogger().warning("convHSSFPatriarch:Not supported class=" + hssfShape.getClass().getName());
            }
            ++i;
        }
    }

    protected void convHSSFSimpleShape(DcfShapeGroup shapeGroup, HSSFSimpleShape hssfSimpleShape) throws Exception {
        HSSFAnchor hssfAnchor = hssfSimpleShape.getAnchor();
        double sx = 0.0;
        double sy = 0.0;
        double sw = 0.0;
        double sh = 0.0;
        if (hssfAnchor instanceof HSSFClientAnchor) {
            HSSFClientAnchor hssfClientAnchor = (HSSFClientAnchor)hssfAnchor;
            sw = this.pxOffset + this.columnWidthExchange(PoiWorkbookUtil.calcXPoint(this.ssSheet, hssfClientAnchor.getRow1(), hssfClientAnchor.getCol1()));
            sh = this.pyOffset + this.rowHeightExchange(PoiWorkbookUtil.calcYPoint(this.ssSheet, hssfClientAnchor.getRow1()));
            Rectangle2D.Double rectangle = this.calcRegion(this.ssSheet, hssfClientAnchor.getRow1(), hssfClientAnchor.getCol1(), hssfClientAnchor.getRow2(), hssfClientAnchor.getCol2());
            sx = this.columnWidthExchange(rectangle.getWidth());
            sy = this.rowHeightExchange(rectangle.getHeight());
        }
        switch (hssfSimpleShape.getShapeType()) {
            case 1: {
                break;
            }
            case 3: {
                DcfArcShape arcShape = new DcfArcShape();
                arcShape.setX(sw);
                arcShape.setY(sh);
                arcShape.getArc().width = sx;
                arcShape.getArc().height = sy;
                arcShape.getArc().start = 180.0;
                arcShape.getArc().extent = 360.0;
                arcShape.getArc().setArcType(0);
                arcShape.lineWidth = this.convLineWidth(hssfSimpleShape.getLineWidth());
                arcShape.lineType = this.convLineStyle(hssfSimpleShape.getLineStyle());
                shapeGroup.addShape(arcShape);
                break;
            }
            case 19: {
                break;
            }
            case 75: {
                break;
            }
            case 201: {
                break;
            }
            case 202: {
                break;
            }
        }
    }

    protected void convSXSSFDrawing(DcfShapeGroup shapeGroup, SXSSFDrawing sxssfDrawing) throws Exception {
        for (XSSFShape xssfShape : sxssfDrawing) {
            this.convXSSFShape(shapeGroup, xssfShape);
        }
    }

    protected void convXSSFDrawing(DcfShapeGroup shapeGroup, XSSFDrawing xssfDrawing) throws Exception {
        for (XSSFShape xssfShape : xssfDrawing) {
            this.convXSSFShape(shapeGroup, xssfShape);
        }
    }

    protected void convXSSFShape(DcfShapeGroup shapeGroup, XSSFShape xssfShape) throws Exception {
        this.getLogger().warning("convHSSFPatriarch:Not supported class=" + xssfShape.getClass().getName());
    }

    public double convLineWidth(int ssLineWidth) throws Exception {
        double lineWidth = 1.0;
        switch (ssLineWidth) {
            case 12700: {
                break;
            }
        }
        return lineWidth;
    }

    public String convLineStyle(int ssLineStyle) throws Exception {
        String lineType = DcfConstants.LineType.solid.code;
        switch (ssLineStyle) {
            case -1: {
                break;
            }
            case 0: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                lineType = DcfConstants.LineType.dotted01.code;
            }
        }
        return lineType;
    }

    public float calcUnderLineWeight(java.awt.Font font) throws Exception {
        float lineWeight = (float)font.getSize() / 10.0f;
        return lineWeight;
    }

    protected String[] arc(DcfShapeGroup shapeGroup, double yPixel, double xPixel, String cellValueStr) throws Exception {
        String[] res = null;
        String command = "{ARC(";
        int pos1 = cellValueStr.indexOf(command);
        if (pos1 < 0) {
            return res;
        }
        int argEndPos = cellValueStr.indexOf(")}", pos1);
        if (argEndPos < 0) {
            return res;
        }
        res = new String[1];
        String arg1 = cellValueStr.substring(pos1 + command.length(), argEndPos);
        ArrayList<String> paramList = new ArrayList<String>();
        HashMap<String, String> paramMap = new HashMap<String, String>();
        DcfScriptUtil.parseParameter(arg1, paramList, paramMap);
        DcfArcShape arcShape = this.scriptParser.parseArcParameter(paramList, paramMap);
        if (BcStringUtil.isEmpty(arcShape.getName())) {
            arcShape.setName(Integer.toString(arcShape.hashCode()));
        }
        arcShape.getArc().x += xPixel;
        arcShape.getArc().y += yPixel;
        shapeGroup.addShape(arcShape);
        res[0] = cellValueStr.substring(argEndPos + 2);
        return res;
    }

    protected String[] dataMatrix(DcfShapeGroup shapeGroup, double yPixel, double xPixel, String cellValueStr) throws Exception {
        String[] res = null;
        String command = "{DATA_MATRIX(";
        int pos1 = cellValueStr.indexOf(command);
        if (pos1 < 0) {
            return res;
        }
        int argEndPos = cellValueStr.indexOf(")}", pos1);
        if (argEndPos < 0) {
            return res;
        }
        res = new String[1];
        DcfDataMatrixShape dataMatrixShape = new DcfDataMatrixShape();
        dataMatrixShape.setX(xPixel);
        dataMatrixShape.setY(yPixel);
        dataMatrixShape.value = cellValueStr.substring(pos1 + command.length(), argEndPos);
        shapeGroup.addShape(dataMatrixShape);
        res[0] = cellValueStr.substring(argEndPos + 2);
        return res;
    }

    protected void colorConvert(Workbook workbook, Font ssFont) throws Exception {
        IndexedColors indexedColors = IndexedColors.fromInt((int)ssFont.getColor());
        if (workbook instanceof XSSFWorkbook) {
            XSSFWorkbook xssfWorkbook = (XSSFWorkbook)workbook;
            StylesTable stylesTable = xssfWorkbook.getStylesSource();
        }
        if (workbook instanceof HSSFWorkbook) {
            HSSFWorkbook hssfWorkbook = (HSSFWorkbook)workbook;
            HSSFPalette hssfPalette = hssfWorkbook.getCustomPalette();
            HSSFColor hssfColor = hssfPalette.getColor(ssFont.getColor());
            this.getLogger().debug("ghexString=" + hssfColor.getHexString());
        }
    }

    class RegionContext {
        Rectangle2D.Double rectangle2D;
        CellRangeAddress cellRangeAddress;

        RegionContext() {
        }
    }
}

