/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.doc.editor;

import ext.base.log.BcLogUtil;
import ext.lib.doc.editor.DcfEditorControlPanel;
import ext.lib.doc.renderer.DcfShapeRenderer;
import ext.lib.swg.SwgCheckBox;
import ext.lib.swg.SwgComboBox;
import ext.lib.swg.SwgPanel;
import ext.lib.swg.SwgTextField;
import ext.lib.swg.SwgUtil;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JPanel;
import nlc.lib.doc.shape.DcfLineShape;
import nlc.lib.doc.shape.DcfRectangleShape;
import nlc.lib.doc.shape.DcfShape;
import nlc.lib.doc.shape.DcfShapeGroup;
import nlc.lib.doc.shape.DcfTextShape;

class DcfEditorMainPane
extends SwgPanel
implements KeyListener,
MouseListener,
MouseMotionListener {
    int scrollbarSize = 16;
    Cursor defaultCursor = new Cursor(0);
    Cursor moveCursor = new Cursor(13);
    Cursor handCursor = new Cursor(12);
    Cursor nResizeCursor = new Cursor(8);
    Cursor sResizeCursor = new Cursor(9);
    Cursor wResizeCursor = new Cursor(10);
    Cursor eResizeCursor = new Cursor(11);
    public boolean isFirstPaint = true;
    int textSize = 11;
    int textHeight = 14;
    int secBarHeight = 16;
    Dimension dim;
    Rectangle preRectangle;
    public Rectangle curRectangle;
    Image offImage;
    Graphics offImageG;
    public Color backgroundColor = Color.gray;
    public Color shapeGroupBackgroundColor = Color.white;
    public Color shapeGroupBarColor = Color.lightGray;
    ArrayList pointList = new ArrayList();
    int pointSize = 4;
    int gridUnit = 4;
    int mUnit = 2;
    SwgTextField objNameField = new SwgTextField();
    SwgTextField objJLabelField = new SwgTextField();
    SwgComboBox objLocatUDCombo = new SwgComboBox();
    SwgComboBox objLocatLRCombo = new SwgComboBox();
    SwgComboBox objFontTypeCombo = new SwgComboBox();
    SwgTextField objFontSizeField = new SwgTextField();
    SwgCheckBox objBoldCheckbox = new SwgCheckBox();
    SwgCheckBox objItalicCheckbox = new SwgCheckBox();
    SwgCheckBox objBorderLineCheckbox = new SwgCheckBox();
    JPanel propatyPanel = new JPanel();
    protected DcfShapeRenderer shapeRenderer = new DcfShapeRenderer();
    protected DcfEditorControlPanel editorControlPanel;
    PopupMenu editMenu = new PopupMenu("\u7de8\u96c6");
    MenuItem addSquareMenu = new MenuItem("SQUARE \u8ffd\u52a0");
    MenuItem addLineMenu = new MenuItem("LINE \u8ffd\u52a0");
    MenuItem removeShapeMenu = new MenuItem("\u524a\u9664");
    static final int NON_EVENT = -1;
    static final int SECTION_BAR_MOVE = 11;
    static final int ELEMENT_MOVE = 21;
    static final int ELEMENT_RESIZE = 31;
    int eventId = -1;
    double gapX = -1.0;
    double gapY = -1.0;
    double mPX = -1.0;
    double mPY = -1.0;
    DcfShapeGroup curShapeGroup;
    DcfShape preShape;
    DcfShape curShape;
    double wX = -1.0;
    double wY = -1.0;
    double wWidth = -1.0;
    double wHeight = -1.0;
    int pointIndex = -1;

    public DcfEditorMainPane(DcfEditorControlPanel editorControlPanel) throws Exception {
        this.editorControlPanel = editorControlPanel;
        this.dim = Toolkit.getDefaultToolkit().getScreenSize();
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
        this.addKeyListener(this);
        this.setBackground(Color.blue);
        this.setLayout(null);
        this.initValue();
        this.setPopupMenu();
        this.setPropertyPanel();
        editorControlPanel.getPropertyPanel().add(this.propatyPanel);
        int i = 0;
        while (i < 4) {
            this.pointList.add(new Point());
            ++i;
        }
        this.repaint();
    }

    public void initValue() throws Exception {
        this.shapeRenderer.setEdit(true);
        this.isFirstPaint = true;
        this.preRectangle = null;
        this.curRectangle = null;
        this.eventId = -1;
        this.curShapeGroup = null;
        this.preShape = null;
        this.curShape = null;
    }

    void setPopupMenu() throws Exception {
        this.add(this.editMenu);
        this.addSquareMenu.addActionListener(this.actionListener);
        this.editMenu.add(this.addSquareMenu);
        this.addLineMenu.addActionListener(this.actionListener);
        this.editMenu.add(this.addLineMenu);
        this.editMenu.addSeparator();
        this.removeShapeMenu.setEnabled(false);
        this.removeShapeMenu.addActionListener(this.actionListener);
        this.editMenu.add(this.removeShapeMenu);
    }

    public void add(DcfShape shape) throws Exception {
        this.putProperty(this.curShape);
        DcfShapeGroup shapeGroup = this.getSectionByArea(this.mPX, this.mPY);
        if (shapeGroup == null) {
            return;
        }
        double tX = this.mPX / (double)this.gridUnit * (double)this.gridUnit;
        double tY = (this.mPY - shapeGroup.getRectangle().y - (double)this.secBarHeight) / (double)this.gridUnit * (double)this.gridUnit;
        if (shape instanceof DcfRectangleShape) {
            DcfRectangleShape rectangleShape = new DcfRectangleShape("", tX, tY, this.gridUnit * 20, this.gridUnit * 4);
            shapeGroup.addShape(rectangleShape);
        } else if (shape instanceof DcfLineShape) {
            DcfLineShape lineShape = new DcfLineShape("", tX, tY, tX + (double)(this.gridUnit * 20), tY);
            shapeGroup.addShape(lineShape);
        }
        this.setProperty(shape);
        this.setPointerLocation(shape);
        this.drawAllElement();
        this.getGraphics().drawImage(this.offImage, 0, 0, null);
        this.editorControlPanel.setEdited(true);
        this.curShape = shape;
    }

    @Override
    protected void actionPerformed2(ActionEvent ev) throws Exception {
        if (ev.getSource() == this.addSquareMenu) {
            DcfRectangleShape rectangleShape = new DcfRectangleShape();
            this.add(rectangleShape);
        } else if (ev.getSource() == this.addLineMenu) {
            DcfLineShape lineShape = new DcfLineShape();
            this.add(lineShape);
        } else if (ev.getSource() == this.removeShapeMenu && (this.curShapeGroup != null || this.curShape != null)) {
            this.curShapeGroup.removeShape(this.curShape);
            this.curShape = null;
            this.drawAllElement();
            this.getGraphics().drawImage(this.offImage, 0, 0, null);
            this.editorControlPanel.setEdited(true);
        }
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    @Override
    public void paint(Graphics g) {
        this.curRectangle = this.getBounds();
        if (this.isFirstPaint) {
            this.offImage = this.createImage(this.dim.width, this.dim.height);
            this.offImageG = this.offImage.getGraphics();
            this.isFirstPaint = false;
        }
        if (this.editorControlPanel.getPage() != null) {
            if (!this.curRectangle.equals(this.preRectangle)) {
                try {
                    this.drawAllElement();
                }
                catch (Exception ex) {
                    BcLogUtil.error(ex);
                }
                this.preRectangle = this.curRectangle;
            }
            g.drawImage(this.offImage, 0, 0, null);
        }
    }

    protected void showOffImage() throws Exception {
        this.getGraphics().drawImage(this.offImage, 0, 0, null);
    }

    protected void setPropertyPanel() throws Exception {
        int rowHeight = 20;
        int yGap = 4;
        int labelWidth = 100;
        int fieldWidth = 200;
        int x1 = 10;
        int x2 = x1 + labelWidth + 10;
        int y = 10;
        SwgUtil.setLocation(this.propatyPanel, new JLabel("\u540d\u524d"), (double)x1, (double)y, (double)labelWidth, (double)rowHeight);
        SwgUtil.setLocation(this.propatyPanel, this.objNameField, (double)x2, (double)y, (double)fieldWidth, (double)rowHeight);
        SwgUtil.setLocation(this.propatyPanel, new JLabel("\u5f0f"), (double)x1, (double)(y += rowHeight + yGap), (double)labelWidth, (double)rowHeight);
        SwgUtil.setLocation(this.propatyPanel, this.objJLabelField, (double)x2, (double)y, (double)fieldWidth, (double)rowHeight);
        SwgUtil.setLocation(this.propatyPanel, new JLabel("\u4e0a\u4e0b\u4f4d\u7f6e"), (double)x1, (double)(y += rowHeight + yGap), (double)labelWidth, (double)rowHeight);
        this.objLocatUDCombo.addItem("\u4e0a");
        this.objLocatUDCombo.addItem("\u4e2d");
        this.objLocatUDCombo.addItem("\u4e0b");
        SwgUtil.setLocation(this.propatyPanel, this.objLocatUDCombo, (double)x2, (double)y, (double)fieldWidth, (double)rowHeight);
        SwgUtil.setLocation(this.propatyPanel, new JLabel("\u5de6\u53f3\u4f4d\u7f6e"), (double)x1, (double)(y += rowHeight + yGap), (double)labelWidth, (double)rowHeight);
        this.objLocatLRCombo.addItem("\u5de6");
        this.objLocatLRCombo.addItem("\u4e2d");
        this.objLocatLRCombo.addItem("\u53f3");
        SwgUtil.setLocation(this.propatyPanel, this.objLocatLRCombo, (double)x2, (double)y, (double)fieldWidth, (double)rowHeight);
        SwgUtil.setLocation(this.propatyPanel, new JLabel("\u30d5\u30a9\u30f3\u30c8\u30bf\u30a4\u30d7"), (double)x1, (double)(y += rowHeight + yGap), (double)labelWidth, (double)rowHeight);
        this.objFontTypeCombo.addItem("Dialog");
        SwgUtil.setLocation(this.propatyPanel, this.objFontTypeCombo, (double)x2, (double)y, (double)fieldWidth, (double)rowHeight);
        SwgUtil.setLocation(this.propatyPanel, new JLabel("\u30d5\u30a9\u30f3\u30c8\u30b9\u30bf\u30a4\u30eb"), (double)x1, (double)(y += rowHeight + yGap), (double)labelWidth, (double)rowHeight);
        this.objBoldCheckbox.setText("\u30dc\u30fc\u30eb\u30c9");
        SwgUtil.setLocation(this.propatyPanel, this.objBoldCheckbox, (double)x2, (double)y, (double)fieldWidth, (double)rowHeight);
        this.objItalicCheckbox.setText("\u30a4\u30bf\u30ea\u30c3\u30af");
        SwgUtil.setLocation(this.propatyPanel, this.objItalicCheckbox, (double)x2, (double)(y += rowHeight + yGap), (double)fieldWidth, (double)rowHeight);
        SwgUtil.setLocation(this.propatyPanel, new JLabel("\u30d5\u30a9\u30f3\u30c8\u30b5\u30a4\u30ba"), (double)x1, (double)(y += rowHeight + yGap), (double)labelWidth, (double)rowHeight);
        SwgUtil.setLocation(this.propatyPanel, this.objFontSizeField, (double)x2, (double)y, (double)fieldWidth, (double)rowHeight);
        SwgUtil.setLocation(this.propatyPanel, new JLabel("\u67a0\u7dda"), (double)x1, (double)(y += rowHeight + yGap), (double)labelWidth, (double)rowHeight);
        SwgUtil.setLocation(this.propatyPanel, this.objBorderLineCheckbox, (double)x2, (double)y, (double)fieldWidth, (double)rowHeight);
    }

    public void setProperty(DcfShape shape) throws Exception {
        if (shape == null) {
            return;
        }
        if (shape instanceof DcfTextShape) {
            DcfTextShape rectangleShape = (DcfTextShape)shape;
            this.objNameField.setText(rectangleShape.getName());
            this.objJLabelField.setText(rectangleShape.value);
            this.objLocatUDCombo.setSelectedItem("\u4e0a");
            if (rectangleShape.verticalAlign == 0) {
                this.objLocatUDCombo.setSelectedItem("\u4e2d");
            }
            if (rectangleShape.verticalAlign == 3) {
                this.objLocatUDCombo.setSelectedItem("\u4e0b");
            }
            this.objLocatLRCombo.setSelectedItem("\u4e0a");
            if (rectangleShape.horizontalAlign == 0) {
                this.objLocatLRCombo.setSelectedItem("\u4e2d");
            }
            if (rectangleShape.horizontalAlign == 4) {
                this.objLocatLRCombo.setSelectedItem("\u53f3");
            }
            this.objFontTypeCombo.setSelectedItem(rectangleShape.font.getName());
            this.objFontSizeField.setText(String.valueOf(rectangleShape.font.getSize2D()));
        } else {
            boolean cfr_ignored_0 = shape instanceof DcfLineShape;
        }
    }

    public void putProperty(DcfShape shape) throws Exception {
        if (shape == null) {
            return;
        }
        if (shape instanceof DcfTextShape) {
            DcfTextShape rectangleShape = (DcfTextShape)shape;
            shape.setName(this.objNameField.getText());
            rectangleShape.value = this.objJLabelField.getText();
            rectangleShape.horizontalAlign = 1;
            if (this.objLocatUDCombo.getSelectedItem().equals("\u4e2d")) {
                rectangleShape.verticalAlign = 0;
            }
            if (this.objLocatUDCombo.getSelectedItem().equals("\u4e0b")) {
                rectangleShape.horizontalAlign = 3;
            }
            rectangleShape.horizontalAlign = 2;
            if (this.objLocatLRCombo.getSelectedItem().equals("\u4e2d")) {
                rectangleShape.horizontalAlign = 0;
            }
            if (this.objLocatLRCombo.getSelectedItem().equals("\u53f3")) {
                rectangleShape.horizontalAlign = 4;
            }
        } else {
            boolean cfr_ignored_0 = shape instanceof DcfLineShape;
        }
    }

    protected void drawAllElement() throws Exception {
        if (this.editorControlPanel.getPage() == null) {
            return;
        }
        if (this.offImage == null || this.curRectangle == null) {
            return;
        }
        Graphics2D g = (Graphics2D)this.offImage.getGraphics();
        g.setColor(this.backgroundColor);
        g.fillRect(0, 0, this.dim.width, this.dim.height);
        DcfShapeGroup shapeGroup = null;
        double pX = -1.0;
        double pY = -1.0;
        int i = 0;
        while (i < this.editorControlPanel.getPage().getGroupCount()) {
            shapeGroup = this.editorControlPanel.getPage().getGroup(i);
            pX = shapeGroup.getRectangle().x;
            pY = shapeGroup.getRectangle().y + (double)this.secBarHeight;
            g.setClip((int)pX, (int)pY, this.dim.width + 1, (int)(shapeGroup.getRectangle().height + 1.0));
            g.setColor(this.shapeGroupBackgroundColor);
            g.fillRect((int)pX, (int)pY, (int)this.editorControlPanel.getPage().getPageFormat().getImageableWidth(), (int)shapeGroup.getRectangle().height);
            try {
                this.shapeRenderer.drawGroup(g, 0.0, this.secBarHeight, shapeGroup);
            }
            catch (Exception ex) {
                BcLogUtil.error(ex);
            }
            ++i;
        }
        i = 0;
        while (i < this.editorControlPanel.getPage().getGroupCount()) {
            this.drawSectionBar(this.editorControlPanel.getPage().getGroup(i));
            ++i;
        }
        this.drawResizePointer(this.curShape);
    }

    protected void drawSectionBar(DcfShapeGroup shapeGroup) throws Exception {
        Graphics g = this.offImage.getGraphics();
        g.setColor(this.shapeGroupBarColor);
        double pX = shapeGroup.getRectangle().x;
        double pY = shapeGroup.getRectangle().y;
        g.fill3DRect((int)pX, (int)pY, this.curRectangle.width, this.secBarHeight, true);
        g.setColor(Color.blue);
        g.drawString(shapeGroup.getLabel(), (int)(pX + 4.0), (int)(pY + 14.0));
    }

    protected void setPointerLocation(DcfShape shape) throws Exception {
        block14: {
            Point point;
            block13: {
                if (shape == null || this.curShapeGroup == null) {
                    return;
                }
                this.wX = this.curShapeGroup.getRectangle().x + shape.getX();
                this.wY = this.curShapeGroup.getRectangle().y + (double)this.secBarHeight + shape.getY();
                point = null;
                if (!(shape instanceof DcfRectangleShape)) break block13;
                DcfRectangleShape rectangleShape = (DcfRectangleShape)shape;
                int i = 0;
                while (i < 4) {
                    point = (Point)this.pointList.get(i);
                    switch (i) {
                        case 0: {
                            point.setLocation(this.wX + rectangleShape.getRectangle().width / 2.0 - 2.0, this.wY - 2.0);
                            break;
                        }
                        case 1: {
                            point.setLocation(this.wX + rectangleShape.getRectangle().width / 2.0 - 2.0, this.wY + rectangleShape.getRectangle().height - 2.0);
                            break;
                        }
                        case 2: {
                            point.setLocation(this.wX - 2.0, this.wY + rectangleShape.getRectangle().height / 2.0 - 2.0);
                            break;
                        }
                        case 3: {
                            point.setLocation(this.wX + rectangleShape.getRectangle().width - 2.0, this.wY + rectangleShape.getRectangle().height / 2.0 - 2.0);
                        }
                    }
                    ++i;
                }
                break block14;
            }
            if (!(shape instanceof DcfLineShape)) break block14;
            DcfLineShape lineShape = (DcfLineShape)shape;
            int i = 0;
            while (i < 2) {
                point = (Point)this.pointList.get(i);
                switch (i) {
                    case 0: {
                        point.setLocation(this.wX - 2.0, this.wY - 2.0);
                        break;
                    }
                    case 1: {
                        point.setLocation(this.curShapeGroup.getRectangle().x + lineShape.getLine().x2 - 2.0, this.curShapeGroup.getRectangle().y + (double)this.secBarHeight + lineShape.getLine().y2 - 2.0);
                    }
                }
                ++i;
            }
        }
    }

    protected void drawResizePointer(DcfShape shape) throws Exception {
        if (shape == null || this.curShapeGroup == null) {
            return;
        }
        Graphics g = this.offImage.getGraphics();
        g.setColor(Color.red);
        int pointerCount = 0;
        if (shape instanceof DcfRectangleShape) {
            pointerCount = 4;
        } else if (shape instanceof DcfLineShape) {
            pointerCount = 2;
        }
        Point point = null;
        int i = 0;
        while (i < pointerCount) {
            point = (Point)this.pointList.get(i);
            g.fillRect(point.x, point.y, this.pointSize, this.pointSize);
            ++i;
        }
    }

    protected final void calcSectionLocation() throws Exception {
        DcfShapeGroup shapeGroup = null;
        double y = 0.0;
        int i = 0;
        while (i < this.editorControlPanel.getPage().getGroupCount()) {
            shapeGroup = this.editorControlPanel.getPage().getGroup(i);
            shapeGroup.getRectangle().y = y;
            y = y + shapeGroup.getRectangle().height + (double)this.secBarHeight;
            ++i;
        }
        super.setPreferredSize(new Dimension(1600, (int)(y + 32.0)));
    }

    protected DcfShapeGroup getSectionBar(double pX, double pY) throws Exception {
        DcfShapeGroup shapeGroup = null;
        int i = 0;
        while (i < this.editorControlPanel.getPage().getGroupCount()) {
            shapeGroup = this.editorControlPanel.getPage().getGroup(i);
            if (pY >= shapeGroup.getRectangle().y && pY <= shapeGroup.getRectangle().y + (double)this.secBarHeight) {
                return shapeGroup;
            }
            ++i;
        }
        return null;
    }

    protected DcfShapeGroup getSectionByArea(double pX, double pY) throws Exception {
        DcfShapeGroup shapeGroup = null;
        int i = 0;
        while (i < this.editorControlPanel.getPage().getGroupCount()) {
            shapeGroup = this.editorControlPanel.getPage().getGroup(i);
            if (pY >= shapeGroup.getRectangle().y + (double)this.secBarHeight && pY < shapeGroup.getRectangle().y + (double)this.secBarHeight + shapeGroup.getRectangle().height) {
                return shapeGroup;
            }
            ++i;
        }
        return null;
    }

    protected DcfShape getElement(double pX, double pY) throws Exception {
        DcfShapeGroup shapeGroup = null;
        DcfShape shape = null;
        int i = 0;
        while (i < this.editorControlPanel.getPage().getGroupCount()) {
            shapeGroup = this.editorControlPanel.getPage().getGroup(i);
            int j = 0;
            while (j < shapeGroup.getShapeCount()) {
                shape = shapeGroup.getShape(j);
                if (shape instanceof DcfRectangleShape) {
                    DcfRectangleShape rectangleShape = (DcfRectangleShape)shape;
                    if (pX >= shapeGroup.getRectangle().x + rectangleShape.getX() && pX <= shapeGroup.getRectangle().x + rectangleShape.getRectangle().x + rectangleShape.getRectangle().width && pY >= shapeGroup.getRectangle().y + (double)this.secBarHeight + rectangleShape.getRectangle().y && pY <= shapeGroup.getRectangle().y + (double)this.secBarHeight + rectangleShape.getY() + rectangleShape.getRectangle().height) {
                        this.curShapeGroup = shapeGroup;
                        return shape;
                    }
                } else if (shape instanceof DcfLineShape) {
                    DcfLineShape line = (DcfLineShape)shape;
                    double gapX = Math.abs(shapeGroup.getRectangle().x + line.getX() - pX);
                    double gapY = Math.abs(shapeGroup.getRectangle().y + (double)this.secBarHeight + line.getY() - pY);
                    if (gapX <= (double)this.gridUnit && gapY <= (double)this.gridUnit) {
                        this.curShapeGroup = shapeGroup;
                        return shape;
                    }
                    gapX = Math.abs(shapeGroup.getRectangle().x + line.getLine().x2 - pX);
                    gapY = Math.abs(shapeGroup.getRectangle().y + (double)this.secBarHeight + line.getLine().y2 - pY);
                    if (gapX <= (double)this.gridUnit && gapY <= (double)this.gridUnit) {
                        this.curShapeGroup = shapeGroup;
                        return shape;
                    }
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    protected int getGridPoint(int pX, int pY) throws Exception {
        return 0;
    }

    protected void vScroll(int viewRowSeqBase2) throws Exception {
    }

    protected void hScroll(int viewColumnSeqBase2) throws Exception {
    }

    @Override
    public void keyTyped(KeyEvent ev) {
    }

    @Override
    public void keyPressed(KeyEvent ev) {
    }

    @Override
    public void keyReleased(KeyEvent ev) {
    }

    @Override
    public void mouseClicked(MouseEvent ev) {
        this.mPX = ev.getX();
        this.mPY = ev.getY();
        try {
            if (this.editorControlPanel.getPage() == null) {
                return;
            }
            if (ev.getY() < 0 && this.getElement(ev.getX(), ev.getY()) != null) {
                this.showOffImage();
                return;
            }
        }
        catch (Exception ex) {
            BcLogUtil.error(ex);
        }
    }

    @Override
    public void mousePressed(MouseEvent ev) {
        this.mPX = ev.getX();
        this.mPY = ev.getY();
        try {
            if (this.editorControlPanel.getPage() == null) {
                return;
            }
            if (this.curShape != null) {
                this.putProperty(this.curShape);
            }
            this.eventId = -1;
            this.pointIndex = -1;
            if (this.pointList != null) {
                int i = 0;
                while (i < this.pointList.size()) {
                    Point point = (Point)this.pointList.get(i);
                    if (this.mPX >= (double)point.x && this.mPX <= (double)(point.x + this.pointSize) && this.mPY >= (double)point.y && this.mPY <= (double)(point.y + this.pointSize)) {
                        this.pointIndex = i;
                        break;
                    }
                    ++i;
                }
                if (this.pointIndex >= 0) {
                    this.eventId = 31;
                    return;
                }
            }
            this.curShapeGroup = this.getSectionBar(this.mPX, this.mPY);
            if (this.curShapeGroup != null) {
                this.eventId = 11;
                this.mPX = this.mPX / (double)this.mUnit * (double)this.mUnit;
                this.mPY = (this.mPY - this.curShapeGroup.getRectangle().y) / (double)this.mUnit * (double)this.mUnit + this.curShapeGroup.getRectangle().y;
                this.gapX = this.mPX - this.curShapeGroup.getRectangle().x;
                this.gapY = this.mPY - this.curShapeGroup.getRectangle().y;
                return;
            }
            this.curShape = this.getElement(this.mPX, this.mPY);
            if (this.curShape != null) {
                this.eventId = 21;
                this.mPX = this.mPX / (double)this.mUnit * (double)this.mUnit;
                this.mPY = (this.mPY - this.curShapeGroup.getRectangle().y) / (double)this.mUnit * (double)this.mUnit + this.curShapeGroup.getRectangle().y;
                this.gapX = this.mPX - (this.curShapeGroup.getRectangle().x + this.curShape.getX());
                this.gapY = this.mPY - (this.curShapeGroup.getRectangle().y + (double)this.secBarHeight + this.curShape.getY());
                this.setProperty(this.curShape);
                this.setPointerLocation(this.curShape);
                this.removeShapeMenu.setEnabled(true);
            } else {
                this.removeShapeMenu.setEnabled(false);
            }
            this.drawAllElement();
            this.showOffImage();
            if (ev.getModifiers() == 4) {
                this.editMenu.show(this, ev.getX(), ev.getY());
            }
        }
        catch (Exception ex) {
            BcLogUtil.error(ex);
        }
    }

    @Override
    public void mouseReleased(MouseEvent ev) {
        this.mPX = ev.getX();
        this.mPY = ev.getY();
        try {
            if (this.editorControlPanel.getPage() == null) {
                return;
            }
            switch (this.eventId) {
                case 21: {
                    break;
                }
                default: {
                    this.setCursor(this.defaultCursor);
                    break;
                }
            }
        }
        catch (Exception ex) {
            BcLogUtil.error(ex);
        }
    }

    @Override
    public void mouseEntered(MouseEvent ev) {
        this.mPX = ev.getX();
        this.mPY = ev.getY();
        try {
            if (this.editorControlPanel.getPage() == null) {
                return;
            }
            if (this.curShape != null) {
                this.putProperty(this.curShape);
                this.drawAllElement();
                this.showOffImage();
            }
        }
        catch (Exception ex) {
            BcLogUtil.error(ex);
        }
    }

    @Override
    public void mouseExited(MouseEvent ev) {
        this.mPX = ev.getX();
        this.mPY = ev.getY();
    }

    public void mouseWheelMoved(MouseWheelEvent ev) {
        this.mPX = ev.getX();
        this.mPY = ev.getY();
    }

    @Override
    public void mouseDragged(MouseEvent ev) {
        this.mPX = ev.getX();
        this.mPY = ev.getY();
        try {
            if (this.editorControlPanel.getPage() == null) {
                return;
            }
            switch (this.eventId) {
                case 11: {
                    if (this.curShapeGroup.getMovable()) {
                        this.mPX = this.mPX / (double)this.mUnit * (double)this.mUnit;
                        this.mPY = (this.mPY - this.curShapeGroup.getRectangle().y) / (double)this.mUnit * (double)this.mUnit + this.curShapeGroup.getRectangle().y;
                        int index = this.editorControlPanel.getPage().indexOf(this.curShapeGroup);
                        if (index > 0) {
                            DcfShapeGroup preDocSect = this.editorControlPanel.getPage().getGroup(index - 1);
                            preDocSect.getRectangle().height = this.mPY - this.gapY - preDocSect.getRectangle().y - (double)this.secBarHeight;
                            if (preDocSect.getRectangle().height <= 0.0) {
                                preDocSect.getRectangle().height = 0.0;
                            }
                        }
                        this.calcSectionLocation();
                    }
                    this.editorControlPanel.setEdited(true);
                    break;
                }
                case 21: {
                    this.mPX = this.mPX / (double)this.mUnit * (double)this.mUnit;
                    this.mPY = (this.mPY - this.curShapeGroup.getY()) / (double)this.mUnit * (double)this.mUnit + this.curShapeGroup.getY();
                    if (this.curShape.getName().indexOf("N") >= 0 && this.curShape.getName().indexOf("S") >= 0) {
                        this.curShape.setY(this.mPY - this.curShapeGroup.getY() - (double)this.secBarHeight - this.gapY);
                        if (this.curShape.getY() < 0.0) {
                            this.curShape.setY(0.0);
                        }
                        if (this.curShape instanceof DcfRectangleShape) {
                            DcfRectangleShape rectangleShape = (DcfRectangleShape)this.curShape;
                            if (rectangleShape.getY() + rectangleShape.getRectangle().height > this.curShapeGroup.getHeight()) {
                                rectangleShape.setY(this.curShapeGroup.getHeight() - rectangleShape.getRectangle().height);
                            }
                        } else if (this.curShape instanceof DcfLineShape) {
                            DcfLineShape line = (DcfLineShape)this.curShape;
                            if (line.getY() > this.curShapeGroup.getHeight()) {
                                line.setY(this.curShapeGroup.getHeight());
                            }
                            if (line.getLine().y2 > this.curShapeGroup.getHeight()) {
                                line.getLine().y2 = this.curShapeGroup.getHeight();
                            }
                        }
                    }
                    if (this.curShape.getName().indexOf("W") >= 0 && this.curShape.getName().indexOf("E") >= 0) {
                        this.curShape.setX(this.mPX - this.curShapeGroup.getX() - this.gapX);
                        if (this.curShape.getX() < 0.0) {
                            this.curShape.setX(0.0);
                        }
                    }
                    this.setPointerLocation(this.curShape);
                    this.editorControlPanel.setEdited(true);
                    break;
                }
                case 31: {
                    this.mPX = this.mPX / (double)this.mUnit * (double)this.mUnit;
                    this.mPY = (this.mPY - this.curShapeGroup.getY()) / (double)this.mUnit * (double)this.mUnit + this.curShapeGroup.getY();
                    if (this.curShape instanceof DcfRectangleShape) {
                        DcfRectangleShape rectangleShape = (DcfRectangleShape)this.curShape;
                        switch (this.pointIndex) {
                            case 0: {
                                this.wY = this.mPY - this.curShapeGroup.getY() - (double)this.secBarHeight;
                                if (this.wY < 0.0) {
                                    this.wY = 0.0;
                                }
                                this.wHeight = rectangleShape.getRectangle().height + rectangleShape.getY() - this.wY;
                                if (this.wHeight >= 4.0) {
                                    rectangleShape.getRectangle().height = this.wHeight;
                                    rectangleShape.setY(this.wY);
                                    break;
                                }
                                rectangleShape.setY(this.curShape.getY() + rectangleShape.getRectangle().height - 4.0);
                                rectangleShape.getRectangle().height = 4.0;
                                break;
                            }
                            case 1: {
                                this.wY = this.mPY - this.curShapeGroup.getY() - (double)this.secBarHeight;
                                if (this.wY > this.curShapeGroup.getHeight()) {
                                    this.wY = this.curShapeGroup.getHeight();
                                }
                                this.wHeight = this.wY - rectangleShape.getY();
                                if (this.wHeight >= 4.0) {
                                    rectangleShape.getRectangle().height = this.wHeight;
                                    break;
                                }
                                rectangleShape.getRectangle().height = 4.0;
                                break;
                            }
                            case 2: {
                                this.wX = this.mPX;
                                if (this.wX < 0.0) {
                                    this.wX = 0.0;
                                }
                                this.wWidth = rectangleShape.getRectangle().width + rectangleShape.getX() - this.wX;
                                if (this.wWidth >= 4.0) {
                                    rectangleShape.getRectangle().width = this.wWidth;
                                    rectangleShape.setX(this.wX);
                                    break;
                                }
                                rectangleShape.setX(this.curShape.getX() + rectangleShape.getRectangle().width - 4.0);
                                rectangleShape.getRectangle().width = 4.0;
                                break;
                            }
                            case 3: {
                                this.wWidth = this.mPX - rectangleShape.getX();
                                if (this.wWidth >= 4.0) {
                                    rectangleShape.getRectangle().width = this.wWidth;
                                    break;
                                }
                                rectangleShape.getRectangle().width = 4.0;
                            }
                        }
                    } else if (this.curShape instanceof DcfLineShape) {
                        DcfLineShape line = (DcfLineShape)this.curShape;
                        switch (this.pointIndex) {
                            case 0: {
                                line.setX(this.mPX + 2.0);
                                line.setY(this.mPY - this.curShapeGroup.getY() - (double)this.secBarHeight + 2.0);
                                break;
                            }
                            case 1: {
                                line.getLine().x2 = this.mPX + 2.0;
                                line.getLine().y2 = this.mPY - this.curShapeGroup.getY() - (double)this.secBarHeight + 2.0;
                            }
                        }
                    }
                    this.editorControlPanel.setEdited(true);
                    this.setPointerLocation(this.curShape);
                }
            }
            this.drawAllElement();
            this.showOffImage();
        }
        catch (Exception ex) {
            BcLogUtil.error(ex);
        }
    }

    @Override
    public void mouseMoved(MouseEvent ev) {
        this.mPX = ev.getX();
        this.mPY = ev.getY();
        try {
            this.curShapeGroup = this.getSectionByArea(this.mPX, this.mPY);
            if (this.curShapeGroup != null) {
                this.editorControlPanel.pointField.setText("X=" + this.mPX + "  Y=" + (this.mPY - this.curShapeGroup.getRectangle().y));
            } else {
                this.editorControlPanel.pointField.setText("");
            }
            this.curShapeGroup = this.getSectionBar(this.mPX, this.mPY);
            if (this.curShapeGroup != null && this.curShapeGroup.getMovable()) {
                this.setCursor(this.nResizeCursor);
                return;
            }
            if (this.getElement(this.mPX, this.mPY) != null) {
                this.setCursor(this.handCursor);
                return;
            }
            this.setCursor(this.defaultCursor);
        }
        catch (Exception ex) {
            BcLogUtil.error(ex);
        }
    }

    public void setStatus(Object obj) {
        this.editorControlPanel.statusJLabel.setText(obj.toString());
    }
}

