/*
 * Decompiled with CFR 0.152.
 */
package ext.base.util;

import ext.base.core.BcInteger;
import ext.base.util.BcCloneUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class BcIndexer
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -5202755299209975018L;
    private List<BcInteger> indexList;

    public BcIndexer(int size) {
        if (size > 0) {
            this.indexList = new ArrayList<BcInteger>(size);
            this.addIndex(size);
        } else {
            this.indexList = new ArrayList<BcInteger>();
        }
    }

    public BcIndexer() {
        this.indexList = new ArrayList<BcInteger>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        List<BcInteger> list = this.indexList;
        synchronized (list) {
            this.indexList.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIndex(int indexCount) {
        List<BcInteger> list = this.indexList;
        synchronized (list) {
            int modelIndex = this.indexList.size();
            int i = 0;
            while (i < indexCount) {
                BcInteger bcInteger = new BcInteger(modelIndex + i);
                this.indexList.add(bcInteger);
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertIndex(int index, int modelId) {
        List<BcInteger> list = this.indexList;
        synchronized (list) {
            this.indexList.add(index, new BcInteger(modelId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIndex(int index, int modelId) {
        List<BcInteger> list = this.indexList;
        synchronized (list) {
            BcInteger lbInteger = this.indexList.get(index);
            lbInteger.value = modelId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int removeIndex(int index1, int index2) {
        List<BcInteger> list = this.indexList;
        synchronized (list) {
            int size = index2 - index1 + 1;
            int arraySize = this.indexList.size();
            int arrayIndex = -1;
            int i = 0;
            while (i < arraySize) {
                arrayIndex = arraySize - i - 1;
                if (this.toModelId(arrayIndex) >= index1 && this.toModelId(arrayIndex) <= index2) {
                    this.indexList.remove(arrayIndex);
                } else if (this.toModelId(arrayIndex) > index2) {
                    this.indexList.get((int)arrayIndex).value = this.toModelId(arrayIndex) - size;
                }
                ++i;
            }
            return size;
        }
    }

    public int removeIndex(int index) {
        return this.removeIndex(index, index);
    }

    public int toModelId(int index) {
        return this.indexList.get((int)index).value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] toModelIds(int[] indexes) {
        int[] modelids = new int[indexes.length];
        List<BcInteger> list = this.indexList;
        synchronized (list) {
            int i = 0;
            while (i < indexes.length) {
                modelids[i] = this.toModelId(indexes[i]);
                ++i;
            }
            return modelids;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int toIndex(int modelId) {
        List<BcInteger> list = this.indexList;
        synchronized (list) {
            int viewIndex = -1;
            int i = 0;
            while (i < this.indexList.size()) {
                if (this.indexList.get((int)i).value == modelId) {
                    viewIndex = i;
                    break;
                }
                ++i;
            }
            return viewIndex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] toViewIndexs(int[] modelIndexs) {
        int[] viewIndex = new int[modelIndexs.length];
        List<BcInteger> list = this.indexList;
        synchronized (list) {
            int i = 0;
            while (i < modelIndexs.length) {
                viewIndex[i] = this.toIndex(modelIndexs[i]);
                ++i;
            }
            return viewIndex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSize() {
        List<BcInteger> list = this.indexList;
        synchronized (list) {
            return this.indexList.size();
        }
    }

    public List<BcInteger> getIndexList() {
        return this.indexList;
    }

    public void setIndexList(List<BcInteger> indexList) {
        this.indexList = indexList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object clone() throws CloneNotSupportedException {
        List<BcInteger> list = this.indexList;
        synchronized (list) {
            BcIndexer obj = BcCloneUtil.createClone(this);
            return obj;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < this.indexList.size()) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(String.valueOf(i) + "=" + this.indexList.get((int)i).value);
            ++i;
        }
        return sb.toString();
    }
}

