/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider.certpath;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.PublicKey;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.CertificateException;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.PKIXReason;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.security.auth.x500.X500Principal;
import sun.misc.ThreadTracker;
import sun.security.provider.certpath.AdaptableX509CertSelector;
import sun.security.provider.certpath.Builder;
import sun.security.provider.certpath.ForwardState;
import sun.security.provider.certpath.KeyChecker;
import sun.security.provider.certpath.PKIX;
import sun.security.provider.certpath.State;
import sun.security.provider.certpath.URICertStore;
import sun.security.util.Debug;
import sun.security.x509.AccessDescription;
import sun.security.x509.AuthorityInfoAccessExtension;
import sun.security.x509.AuthorityKeyIdentifierExtension;
import sun.security.x509.PKIXExtensions;
import sun.security.x509.X500Name;
import sun.security.x509.X509CertImpl;

class ForwardBuilder
extends Builder {
    private static final Debug debug = Debug.getInstance("certpath");
    private final Set<X509Certificate> trustedCerts;
    private final Set<X500Principal> trustedSubjectDNs;
    private final Set<TrustAnchor> trustAnchors;
    private X509CertSelector eeSelector;
    private AdaptableX509CertSelector caSelector;
    private X509CertSelector caTargetSelector;
    TrustAnchor trustAnchor;
    private boolean searchAllCertStores = true;

    ForwardBuilder(PKIX.BuilderParams builderParams, boolean bl) {
        super(builderParams);
        this.trustAnchors = builderParams.trustAnchors();
        this.trustedCerts = new HashSet<X509Certificate>(this.trustAnchors.size());
        this.trustedSubjectDNs = new HashSet<X500Principal>(this.trustAnchors.size());
        for (TrustAnchor trustAnchor : this.trustAnchors) {
            X509Certificate x509Certificate = trustAnchor.getTrustedCert();
            if (x509Certificate != null) {
                this.trustedCerts.add(x509Certificate);
                this.trustedSubjectDNs.add(x509Certificate.getSubjectX500Principal());
                continue;
            }
            this.trustedSubjectDNs.add(trustAnchor.getCA());
        }
        this.searchAllCertStores = bl;
    }

    @Override
    Collection<X509Certificate> getMatchingCerts(State state, List<CertStore> list) throws CertStoreException, CertificateException, IOException {
        if (debug != null) {
            debug.println("ForwardBuilder.getMatchingCerts()...");
        }
        ForwardState forwardState = (ForwardState)state;
        PKIXCertComparator pKIXCertComparator = new PKIXCertComparator(this.trustedSubjectDNs, forwardState.cert);
        TreeSet<X509Certificate> treeSet = new TreeSet<X509Certificate>(pKIXCertComparator);
        if (forwardState.isInitial()) {
            this.getMatchingEECerts(forwardState, list, treeSet);
        }
        this.getMatchingCACerts(forwardState, list, treeSet);
        return treeSet;
    }

    private void getMatchingEECerts(ForwardState forwardState, List<CertStore> list, Collection<X509Certificate> collection) throws IOException {
        if (debug != null) {
            debug.println("ForwardBuilder.getMatchingEECerts()...");
        }
        if (this.eeSelector == null) {
            this.eeSelector = (X509CertSelector)this.targetCertConstraints.clone();
            this.eeSelector.setCertificateValid(this.buildParams.date());
            if (this.buildParams.explicitPolicyRequired()) {
                this.eeSelector.setPolicy(this.getMatchingPolicies());
            }
            this.eeSelector.setBasicConstraints(-2);
        }
        this.addMatchingCerts(this.eeSelector, list, collection, this.searchAllCertStores);
    }

    private void getMatchingCACerts(ForwardState forwardState, List<CertStore> list, Collection<X509Certificate> collection) throws IOException {
        if (debug != null) {
            debug.println("ForwardBuilder.getMatchingCACerts()...");
        }
        int n = collection.size();
        X509CertSelector x509CertSelector = null;
        if (forwardState.isInitial()) {
            if (this.targetCertConstraints.getBasicConstraints() == -2) {
                return;
            }
            if (debug != null) {
                debug.println("ForwardBuilder.getMatchingCACerts(): the target is a CA");
            }
            if (this.caTargetSelector == null) {
                this.caTargetSelector = (X509CertSelector)this.targetCertConstraints.clone();
                if (this.buildParams.explicitPolicyRequired()) {
                    this.caTargetSelector.setPolicy(this.getMatchingPolicies());
                }
            }
            x509CertSelector = this.caTargetSelector;
        } else {
            if (this.caSelector == null) {
                this.caSelector = new AdaptableX509CertSelector();
                if (this.buildParams.explicitPolicyRequired()) {
                    this.caSelector.setPolicy(this.getMatchingPolicies());
                }
            }
            this.caSelector.setSubject(forwardState.issuerDN);
            this.caSelector.setValidityPeriod(forwardState.cert.getNotBefore(), forwardState.cert.getNotAfter());
            x509CertSelector = this.caSelector;
        }
        x509CertSelector.setBasicConstraints(-1);
        Object object = this.trustedCerts.iterator();
        while (object.hasNext()) {
            X509Certificate x509Certificate = object.next();
            if (!x509CertSelector.match(x509Certificate)) continue;
            if (debug != null) {
                debug.println("ForwardBuilder.getMatchingCACerts: found matching trust anchor.\n  SN: " + Debug.toHexString(x509Certificate.getSerialNumber()) + "\n  Subject: " + x509Certificate.getSubjectX500Principal() + "\n  Issuer: " + x509Certificate.getIssuerX500Principal());
            }
            collection.add(x509Certificate);
        }
        x509CertSelector.setCertificateValid(this.buildParams.date());
        x509CertSelector.setBasicConstraints(forwardState.traversedCACerts);
        if ((forwardState.isInitial() || this.buildParams.maxPathLength() == -1 || this.buildParams.maxPathLength() > forwardState.traversedCACerts) && this.addMatchingCerts(x509CertSelector, list, collection, this.searchAllCertStores) && !this.searchAllCertStores) {
            return;
        }
        if (!forwardState.isInitial() && Builder.USE_AIA && (object = forwardState.cert.getAuthorityInfoAccessExtension()) != null) {
            this.getCerts((AuthorityInfoAccessExtension)object, collection);
        }
        if (debug != null) {
            int n2 = collection.size() - n;
            debug.println("ForwardBuilder.getMatchingCACerts: found " + n2 + " CA certs");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getCerts(AuthorityInfoAccessExtension authorityInfoAccessExtension, Collection<X509Certificate> collection) {
        if (!Builder.USE_AIA) {
            return false;
        }
        List<AccessDescription> list = authorityInfoAccessExtension.getAccessDescriptions();
        if (list == null || list.isEmpty()) {
            return false;
        }
        Object object = ThreadTrackerHolder.AIA_TRACKER.tryBegin();
        if (object == null) {
            if (debug != null) {
                debug.println("Recursive fetching of certs via the AIA extension detected");
            }
            return false;
        }
        try {
            boolean bl = false;
            for (AccessDescription accessDescription : list) {
                CertStore certStore = URICertStore.getInstance(accessDescription);
                if (certStore == null) continue;
                try {
                    if (!collection.addAll(certStore.getCertificates(this.caSelector))) continue;
                    bl = true;
                    if (this.searchAllCertStores) continue;
                    boolean bl2 = true;
                    return bl2;
                }
                catch (CertStoreException certStoreException) {
                    if (debug == null) continue;
                    debug.println("exception getting certs from CertStore:");
                    certStoreException.printStackTrace();
                }
            }
            boolean bl3 = bl;
            return bl3;
        }
        finally {
            ThreadTrackerHolder.AIA_TRACKER.end(object);
        }
    }

    @Override
    void verifyCert(X509Certificate x509Certificate, State state, List<X509Certificate> list) throws GeneralSecurityException {
        if (debug != null) {
            debug.println("ForwardBuilder.verifyCert(SN: " + Debug.toHexString(x509Certificate.getSerialNumber()) + "\n  Issuer: " + x509Certificate.getIssuerX500Principal() + ")\n  Subject: " + x509Certificate.getSubjectX500Principal() + ")");
        }
        ForwardState forwardState = (ForwardState)state;
        forwardState.untrustedChecker.check(x509Certificate, Collections.emptySet());
        boolean bl = this.trustedCerts.contains(x509Certificate);
        if (!bl) {
            Set<String> set = x509Certificate.getCriticalExtensionOIDs();
            if (set == null) {
                set = Collections.emptySet();
            }
            for (PKIXCertPathChecker pKIXCertPathChecker : forwardState.forwardCheckers) {
                pKIXCertPathChecker.check(x509Certificate, set);
            }
            for (PKIXCertPathChecker pKIXCertPathChecker : this.buildParams.certPathCheckers()) {
                Set<String> set2;
                if (pKIXCertPathChecker.isForwardCheckingSupported() || (set2 = pKIXCertPathChecker.getSupportedExtensions()) == null) continue;
                set.removeAll(set2);
            }
            if (!set.isEmpty()) {
                set.remove(PKIXExtensions.BasicConstraints_Id.toString());
                set.remove(PKIXExtensions.NameConstraints_Id.toString());
                set.remove(PKIXExtensions.CertificatePolicies_Id.toString());
                set.remove(PKIXExtensions.PolicyMappings_Id.toString());
                set.remove(PKIXExtensions.PolicyConstraints_Id.toString());
                set.remove(PKIXExtensions.InhibitAnyPolicy_Id.toString());
                set.remove(PKIXExtensions.SubjectAlternativeName_Id.toString());
                set.remove(PKIXExtensions.KeyUsage_Id.toString());
                set.remove(PKIXExtensions.ExtendedKeyUsage_Id.toString());
                if (!set.isEmpty()) {
                    throw new CertPathValidatorException("Unrecognized critical extension(s)", null, null, -1, PKIXReason.UNRECOGNIZED_CRIT_EXT);
                }
            }
        }
        if (forwardState.isInitial()) {
            return;
        }
        if (!bl) {
            if (x509Certificate.getBasicConstraints() == -1) {
                throw new CertificateException("cert is NOT a CA cert");
            }
            KeyChecker.verifyCAKeyUsage(x509Certificate);
        }
    }

    @Override
    boolean isPathCompleted(X509Certificate x509Certificate) {
        PublicKey publicKey;
        X500Principal x500Principal;
        ArrayList<TrustAnchor> arrayList = new ArrayList<TrustAnchor>();
        for (TrustAnchor trustAnchor : this.trustAnchors) {
            if (trustAnchor.getTrustedCert() != null) {
                if (!x509Certificate.equals(trustAnchor.getTrustedCert())) continue;
                this.trustAnchor = trustAnchor;
                return true;
            }
            x500Principal = trustAnchor.getCA();
            publicKey = trustAnchor.getCAPublicKey();
            if (x500Principal != null && publicKey != null && x500Principal.equals(x509Certificate.getSubjectX500Principal()) && publicKey.equals(x509Certificate.getPublicKey())) {
                this.trustAnchor = trustAnchor;
                return true;
            }
            arrayList.add(trustAnchor);
        }
        for (TrustAnchor trustAnchor : arrayList) {
            x500Principal = trustAnchor.getCA();
            publicKey = trustAnchor.getCAPublicKey();
            if (x500Principal == null || !x500Principal.equals(x509Certificate.getIssuerX500Principal()) || PKIX.isDSAPublicKeyWithoutParams(publicKey)) continue;
            try {
                x509Certificate.verify(publicKey, this.buildParams.sigProvider());
            }
            catch (InvalidKeyException invalidKeyException) {
                if (debug == null) continue;
                debug.println("ForwardBuilder.isPathCompleted() invalid DSA key found");
                continue;
            }
            catch (GeneralSecurityException generalSecurityException) {
                if (debug == null) continue;
                debug.println("ForwardBuilder.isPathCompleted() unexpected exception");
                generalSecurityException.printStackTrace();
                continue;
            }
            this.trustAnchor = trustAnchor;
            return true;
        }
        return false;
    }

    @Override
    void addCertToPath(X509Certificate x509Certificate, LinkedList<X509Certificate> linkedList) {
        linkedList.addFirst(x509Certificate);
    }

    @Override
    void removeFinalCertFromPath(LinkedList<X509Certificate> linkedList) {
        linkedList.removeFirst();
    }

    static class PKIXCertComparator
    implements Comparator<X509Certificate> {
        static final String METHOD_NME = "PKIXCertComparator.compare()";
        private final Set<X500Principal> trustedSubjectDNs;
        private final X509CertSelector certSkidSelector;

        PKIXCertComparator(Set<X500Principal> set, X509CertImpl x509CertImpl) throws IOException {
            this.trustedSubjectDNs = set;
            this.certSkidSelector = this.getSelector(x509CertImpl);
        }

        private X509CertSelector getSelector(X509CertImpl x509CertImpl) throws IOException {
            byte[] byArray;
            AuthorityKeyIdentifierExtension authorityKeyIdentifierExtension;
            if (x509CertImpl != null && (authorityKeyIdentifierExtension = x509CertImpl.getAuthorityKeyIdentifierExtension()) != null && (byArray = authorityKeyIdentifierExtension.getEncodedKeyIdentifier()) != null) {
                X509CertSelector x509CertSelector = new X509CertSelector();
                x509CertSelector.setSubjectKeyIdentifier(byArray);
                return x509CertSelector;
            }
            return null;
        }

        @Override
        public int compare(X509Certificate x509Certificate, X509Certificate x509Certificate2) {
            int n;
            int n2;
            int n3;
            X500Name x500Name;
            X500Principal x500Principal4;
            if (x509Certificate.equals(x509Certificate2)) {
                return 0;
            }
            if (this.certSkidSelector != null) {
                if (this.certSkidSelector.match(x509Certificate)) {
                    return -1;
                }
                if (this.certSkidSelector.match(x509Certificate2)) {
                    return 1;
                }
            }
            X500Principal x500Principal2 = x509Certificate.getIssuerX500Principal();
            X500Principal x500Principal3 = x509Certificate2.getIssuerX500Principal();
            X500Name x500Name2 = X500Name.asX500Name(x500Principal2);
            X500Name x500Name3 = X500Name.asX500Name(x500Principal3);
            if (debug != null) {
                debug.println("PKIXCertComparator.compare() o1 Issuer:  " + x500Principal2);
                debug.println("PKIXCertComparator.compare() o2 Issuer:  " + x500Principal3);
            }
            if (debug != null) {
                debug.println("PKIXCertComparator.compare() MATCH TRUSTED SUBJECT TEST...");
            }
            boolean bl = this.trustedSubjectDNs.contains(x500Principal2);
            boolean bl2 = this.trustedSubjectDNs.contains(x500Principal3);
            if (debug != null) {
                debug.println("PKIXCertComparator.compare() m1: " + bl);
                debug.println("PKIXCertComparator.compare() m2: " + bl2);
            }
            if (bl && bl2) {
                return -1;
            }
            if (bl) {
                return -1;
            }
            if (bl2) {
                return 1;
            }
            if (debug != null) {
                debug.println("PKIXCertComparator.compare() NAMING DESCENDANT TEST...");
            }
            for (X500Principal x500Principal4 : this.trustedSubjectDNs) {
                x500Name = X500Name.asX500Name(x500Principal4);
                n3 = Builder.distance(x500Name, x500Name2, -1);
                n2 = Builder.distance(x500Name, x500Name3, -1);
                if (debug != null) {
                    debug.println("PKIXCertComparator.compare() distanceTto1: " + n3);
                    debug.println("PKIXCertComparator.compare() distanceTto2: " + n2);
                }
                if (n3 <= 0 && n2 <= 0) continue;
                if (n3 == n2) {
                    return -1;
                }
                if (n3 > 0 && n2 <= 0) {
                    return -1;
                }
                if (n3 <= 0 && n2 > 0) {
                    return 1;
                }
                if (n3 < n2) {
                    return -1;
                }
                return 1;
            }
            if (debug != null) {
                debug.println("PKIXCertComparator.compare() NAMING ANCESTOR TEST...");
            }
            for (X500Principal x500Principal4 : this.trustedSubjectDNs) {
                x500Name = X500Name.asX500Name(x500Principal4);
                n3 = Builder.distance(x500Name, x500Name2, Integer.MAX_VALUE);
                n2 = Builder.distance(x500Name, x500Name3, Integer.MAX_VALUE);
                if (debug != null) {
                    debug.println("PKIXCertComparator.compare() distanceTto1: " + n3);
                    debug.println("PKIXCertComparator.compare() distanceTto2: " + n2);
                }
                if (n3 >= 0 && n2 >= 0) continue;
                if (n3 == n2) {
                    return -1;
                }
                if (n3 < 0 && n2 >= 0) {
                    return -1;
                }
                if (n3 >= 0 && n2 < 0) {
                    return 1;
                }
                if (n3 > n2) {
                    return -1;
                }
                return 1;
            }
            if (debug != null) {
                debug.println("PKIXCertComparator.compare() SAME NAMESPACE AS TRUSTED TEST...");
            }
            for (X500Principal x500Principal4 : this.trustedSubjectDNs) {
                x500Name = X500Name.asX500Name(x500Principal4);
                X500Name x500Name4 = x500Name.commonAncestor(x500Name2);
                X500Name x500Name5 = x500Name.commonAncestor(x500Name3);
                if (debug != null) {
                    debug.println("PKIXCertComparator.compare() tAo1: " + String.valueOf(x500Name4));
                    debug.println("PKIXCertComparator.compare() tAo2: " + String.valueOf(x500Name5));
                }
                if (x500Name4 == null && x500Name5 == null) continue;
                if (x500Name4 != null && x500Name5 != null) {
                    n = Builder.hops(x500Name, x500Name2, Integer.MAX_VALUE);
                    int n4 = Builder.hops(x500Name, x500Name3, Integer.MAX_VALUE);
                    if (debug != null) {
                        debug.println("PKIXCertComparator.compare() hopsTto1: " + n);
                        debug.println("PKIXCertComparator.compare() hopsTto2: " + n4);
                    }
                    if (n == n4) continue;
                    if (n > n4) {
                        return 1;
                    }
                    return -1;
                }
                if (x500Name4 == null) {
                    return 1;
                }
                return -1;
            }
            if (debug != null) {
                debug.println("PKIXCertComparator.compare() CERT ISSUER/SUBJECT COMPARISON TEST...");
            }
            X500Principal x500Principal5 = x509Certificate.getSubjectX500Principal();
            x500Principal4 = x509Certificate2.getSubjectX500Principal();
            x500Name = X500Name.asX500Name(x500Principal5);
            X500Name x500Name6 = X500Name.asX500Name(x500Principal4);
            if (debug != null) {
                debug.println("PKIXCertComparator.compare() o1 Subject: " + x500Principal5);
                debug.println("PKIXCertComparator.compare() o2 Subject: " + x500Principal4);
            }
            int n5 = Builder.distance(x500Name, x500Name2, Integer.MAX_VALUE);
            n = Builder.distance(x500Name6, x500Name3, Integer.MAX_VALUE);
            if (debug != null) {
                debug.println("PKIXCertComparator.compare() distanceStoI1: " + n5);
                debug.println("PKIXCertComparator.compare() distanceStoI2: " + n);
            }
            if (n > n5) {
                return -1;
            }
            if (n < n5) {
                return 1;
            }
            if (debug != null) {
                debug.println("PKIXCertComparator.compare() no tests matched; RETURN 0");
            }
            return -1;
        }
    }

    private static class ThreadTrackerHolder {
        static final ThreadTracker AIA_TRACKER = new ThreadTracker();

        private ThreadTrackerHolder() {
        }
    }
}

