/*
 * Decompiled with CFR 0.152.
 */
package ext.scf4.swg;

import ext.base.core.BcStringUtil;
import ext.base.core.BcTimeUtil;
import ext.base.log.BcLogUtil;
import ext.base.thread.BcThread;
import ext.base.util.BcMessageCreator;
import ext.base.util.BcResult;
import ext.base.util.BcWarningException;
import ext.base.util.BcWords;
import ext.lib.awt.AwtImageHelper;
import ext.lib.rmi.common.RmiLoggerConstants;
import ext.lib.swg.SwgArrangementHint;
import ext.lib.swg.SwgBorderPanel;
import ext.lib.swg.SwgDecoratePanel;
import ext.lib.swg.SwgDialog;
import ext.lib.swg.SwgFormLayout;
import ext.lib.swg.SwgFrame;
import ext.lib.swg.SwgOptionPane;
import ext.lib.swg.SwgTextField;
import ext.lib.swg.SwgUtil;
import ext.lib.swg.lookAndFeel.SwgLafManager;
import ext.scf4.client.ScfAbstractProcessingMonitor;
import ext.scf4.swg.HswgComponentFactory;
import ext.scf4.swg.HswgConsolePanel;
import ext.scf4.swg.HswgLabelComponentControl;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.SwingUtilities;

public class HswgProcessingPane
extends ScfAbstractProcessingMonitor {
    SwgDecoratePanel decoratePanel = new SwgDecoratePanel();
    SwgTextField elapsedTimeField = new SwgTextField();
    HswgLabelComponentControl elapsedTimeControl;
    HswgConsolePanel consolePanel = new HswgConsolePanel();
    SwgBorderPanel borderPanel = new SwgBorderPanel();
    String title;
    protected Window window;
    protected Component parentComponent;
    DrawThread drawThread;
    public boolean successfullyMessageEnable = true;

    public HswgProcessingPane() throws Exception {
        this.initComponent();
    }

    public void initComponent() throws Exception {
        SwgArrangementHint arrangementHint1 = HswgComponentFactory.createArrangementHint();
        this.borderPanel.setBorderSize(4, 4, 4, 4);
        this.borderPanel.northPanel.setBackground(SwgLafManager.getInstance().consoleBgColor);
        this.borderPanel.southPanel.setBackground(SwgLafManager.getInstance().consoleBgColor);
        this.borderPanel.westPanel.setBackground(SwgLafManager.getInstance().consoleBgColor);
        this.borderPanel.eastPanel.setBackground(SwgLafManager.getInstance().consoleBgColor);
        this.borderPanel.centerPanel.setLayout(new BorderLayout());
        this.borderPanel.centerPanel.add((Component)this.consolePanel, "Center");
        this.decoratePanel = new SwgDecoratePanel();
        this.decoratePanel.setBorderSize(4, 28, 4, 4);
        this.decoratePanel.setLine();
        this.decoratePanel.southPanel.setLayout(new SwgFormLayout());
        this.elapsedTimeField.setEditable(false);
        this.elapsedTimeField.setHorizontalAlignment(4);
        this.elapsedTimeField.setPreferredSize(SwgUtil.getTextFieldSize(this.elapsedTimeField.getFont(), 9));
        this.elapsedTimeControl = new HswgLabelComponentControl(BcWords.getInstance().elapsedTime);
        this.elapsedTimeControl.addComponent(this.elapsedTimeField);
        this.elapsedTimeControl.setArrangementHint(arrangementHint1);
        this.decoratePanel.southPanel.add((Component)this.elapsedTimeControl, "Center");
        this.decoratePanel.centerPanel.setLayout(new BorderLayout());
        this.decoratePanel.centerPanel.add((Component)this.borderPanel, "Center");
        this.decoratePanel.validate();
    }

    @Override
    protected void doConnect() {
        super.doConnect();
        this.drawThread = new DrawThread();
        this.drawThread.startThread();
    }

    @Override
    protected void successed() {
        super.successed();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    HswgProcessingPane.this.successed_L2();
                }
                catch (Exception ex) {
                    BcLogUtil.error(ex);
                }
            }
        });
    }

    protected void successed_L2() throws Exception {
        this.close();
        if (!this.successfullyMessageEnable) {
            return;
        }
        Object resultObj = this.rmiRes.getObject("result");
        if (resultObj == null) {
            String msg = String.valueOf(this.title) + "\u3092\u5b8c\u4e86\u3057\u307e\u3057\u305f\u3002";
            SwgOptionPane.showMessageDialog(this.parentComponent, msg, BcWords.getInstance().information, 1);
        } else if (resultObj instanceof BcResult) {
            BcResult result = (BcResult)resultObj;
            if (result.hasError()) {
                String msg = BcMessageCreator.getInstance().createMessage(result.getErrorList());
                SwgOptionPane.showMessageDialog(this.parentComponent, msg, BcWords.getInstance().error, 0);
            } else {
                ArrayList<Object> msgList = new ArrayList<Object>();
                if (result.hasInfo()) {
                    msgList.addAll(result.getInfoList());
                }
                if (result.hasWarn()) {
                    msgList.addAll(result.getWarnList());
                }
                String msg = BcMessageCreator.getInstance().createMessage(msgList).toString();
                SwgOptionPane.showMessageDialog(this.parentComponent, msg, BcWords.getInstance().information, 1);
            }
        } else {
            String msg = BcStringUtil.toStringNotNull(resultObj);
            SwgOptionPane.showMessageDialog(this.parentComponent, msg, BcWords.getInstance().information, 1);
        }
    }

    @Override
    protected void exceptionOccurred(Throwable throwable) {
        super.exceptionOccurred(throwable);
        if (BcWarningException.class.isAssignableFrom(throwable.getClass())) {
            String title = BcWords.getInstance().warning;
            SwgOptionPane.showMessageDialog(this.parentComponent, throwable.getMessage(), title, 2);
        } else {
            String title = "\u30b5\u30fc\u30d0\u5074\u3067\u4f8b\u5916\u304c\u767a\u751f";
            String error = BcLogUtil.convertMessage(throwable);
            SwgOptionPane.showMessageDialog(this.parentComponent, error, title, 0);
        }
        this.close();
    }

    @Override
    protected void destruct() throws Exception {
        super.destruct();
        if (this.drawThread != null) {
            this.drawThread.stopThread();
            this.drawThread = null;
        }
    }

    public void close() {
        this.window.dispose();
        this.window = null;
    }

    public void showAsFrame(String title) throws Exception {
        this.title = title;
        SwgFrame frame = new SwgFrame();
        this.parentComponent = frame;
        frame.setDefaultCloseOperation(0);
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent ev) {
                HswgProcessingPane.this.doConnect();
            }
        });
        frame.getContentPane().add((Component)this.decoratePanel, "Center");
        frame.setResizable(false);
        frame.setTitle(title);
        frame.setIconImage(AwtImageHelper.getWindowIconImage());
        frame.pack();
        this.window = frame;
        SwgUtil.setCenter(this.window, 620.0, 400.0);
        this.window.setVisible(true);
    }

    public void showAsDiaolg(Component parentComponent, String title) throws Exception {
        this.parentComponent = parentComponent;
        this.title = title;
        SwgDialog dialog = SwgUtil.createDialog(parentComponent);
        dialog.setDefaultCloseOperation(0);
        dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent ev) {
                HswgProcessingPane.this.doConnect();
            }
        });
        dialog.getContentPane().add((Component)this.decoratePanel, "Center");
        dialog.setResizable(false);
        dialog.setModal(true);
        dialog.setTitle(title);
        dialog.setIconImage(AwtImageHelper.getWindowIconImage());
        dialog.pack();
        this.window = dialog;
        SwgUtil.setCenter(this.window, 620.0, 400.0);
        this.window.setVisible(true);
    }

    class DrawThread
    extends BcThread {
        public DrawThread() {
            this.setPriority(1);
        }

        @Override
        protected void run2() throws Exception {
            long elapsedTime = System.currentTimeMillis() - HswgProcessingPane.this.startTime;
            final String elapsedTimeStr = BcTimeUtil.toDurationString(elapsedTime);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        Object data;
                        ((DrawThread)DrawThread.this).HswgProcessingPane.this.elapsedTimeField.setText(elapsedTimeStr);
                        ((DrawThread)DrawThread.this).HswgProcessingPane.this.elapsedTimeField.paintImmediately(((DrawThread)DrawThread.this).HswgProcessingPane.this.elapsedTimeField.getVisibleRect());
                        while ((data = HswgProcessingPane.this.dataQueue.poll()) != null) {
                            byte[] dataBytes = (byte[])data;
                            String str = new String(dataBytes, RmiLoggerConstants.CHARSET);
                            ((DrawThread)DrawThread.this).HswgProcessingPane.this.consolePanel.addData(str);
                        }
                    }
                    catch (Exception ex) {
                        BcLogUtil.error(ex);
                    }
                }
            });
            try {
                Thread.sleep(200L);
            }
            catch (Exception ex) {
                BcLogUtil.error(ex);
            }
        }
    }
}

