/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.poi;

import ext.base.util.BcAbstractWords;
import ext.base.util.BcISO;
import ext.base.util.BcLocaleUtil;
import ext.base.util.BcWordPack;
import ext.base.util.BcWords;
import java.io.Serializable;

public class PoiWords
extends BcAbstractWords
implements Serializable {
    private static final long serialVersionUID = -8782476558666149884L;
    private static final PoiWords en = new PoiWords();
    private static PoiWords ja;
    public BcWordPack header_output;
    public BcWordPack constant_conversion;
    public BcWordPack invisible_column_output;
    public String Outputting_destination_$;
    public String Output_completed_destination_$;

    private PoiWords() {
        this.header_output = new BcWordPack(false, BcWords.getInstance().header, BcWords.getInstance().output);
        this.constant_conversion = new BcWordPack(false, BcWords.getInstance().constant, BcWords.getInstance().conversion);
        this.invisible_column_output = new BcWordPack(false, BcWords.getInstance().invisible, BcWords.getInstance().column, BcWords.getInstance().output);
        this.Outputting_destination_$ = "Outputting\uff0e\uff0e\uff0e\ndestination=%s";
        this.Output_completed_destination_$ = "Output completed.\ndestination=%s";
        this.setIso639(BcISO.ISO_639.English);
    }

    public static PoiWords getInstance(String langageCode) {
        PoiWords words = en;
        if (BcISO.ISO_639.Japanese.code.equalsIgnoreCase(langageCode)) {
            if (ja == null) {
                ja = new PoiWords();
                ja.setJapanese();
            }
            words = ja;
        }
        return words;
    }

    public static PoiWords getInstance(BcAbstractWords words) {
        return PoiWords.getInstance(words.getIso639().code);
    }

    public static PoiWords getInstance() {
        return PoiWords.getInstance(BcLocaleUtil.getIso639().code);
    }

    public void setJapanese() {
        this.setIso639(BcISO.ISO_639.Japanese);
        String langageCode = this.getIso639().code;
        this.header_output = new BcWordPack(false, BcWords.getInstance((String)langageCode).header, BcWords.getInstance((String)langageCode).output);
        this.constant_conversion = new BcWordPack(false, BcWords.getInstance((String)langageCode).constant, BcWords.getInstance((String)langageCode).conversion);
    }
}

