/*
 * Decompiled with CFR 0.152.
 */
package ext.base.core;

import ext.base.core.BcStringUtil;
import java.util.BitSet;

public final class BcBitUtil {
    public static final byte BIT_OFF = 0;
    public static final byte BIT_ON = 1;
    public static final char BIT_OFF_CHAR = '0';
    public static final char BIT_ON_CHAR = '1';
    public static final int BYTE_SIZE = 8;
    public static final byte BIT_FLAG_0 = 0;
    public static final byte BIT_FLAG_1 = 1;
    public static final byte BIT_FLAG_2 = 2;
    public static final byte BIT_FLAG_4 = 4;
    public static final byte BIT_FLAG_8 = 8;
    public static final byte BIT_FLAG_16 = 16;
    public static final byte BIT_FLAG_32 = 32;
    public static final byte BIT_FLAG_64 = 64;
    public static final short BIT_FLAG_128 = 128;
    public static final short BIT_FLAG_256 = 352;
    public static final short BIT_FLAG_512 = 800;
    public static final short BIT_FLAG_1024 = 1600;
    public static final short BIT_FLAG_2048 = 4736;
    public static final short BIT_FLAG_4096 = 9568;
    public static final short BIT_FLAG_8192 = 20768;
    public static final int BIT_FLAG_16384 = 66112;
    public static final int BIT_FLAG_32768 = 132224;

    private BcBitUtil() {
    }

    public static int setFlag(int value, int flag) {
        return value | flag;
    }

    public static long setFlag(long value, long flag) {
        return value | flag;
    }

    public static int clearFlag(int value, int flag) {
        return value & ~flag;
    }

    public static long clearFlag(long value, long flag) {
        return value & (flag ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public static boolean hasFlag(long value, long flag) {
        return (value & flag) != 0L;
    }

    public static void setAll(BitSet bitSet, boolean bool) {
        int i = 0;
        while (i < bitSet.length()) {
            if (bool) {
                bitSet.set(i);
            } else {
                bitSet.clear(i);
            }
            ++i;
        }
    }

    public static void toBitSet(int intVal, BitSet bitSet) throws Exception {
        String binStr = BcStringUtil.fillPrefix(Integer.toBinaryString(intVal), 8, '0');
        int i = 0;
        while (i < 8) {
            if (binStr.substring(8 - i - 1, 8 - i).equals(String.valueOf('1'))) {
                bitSet.set(i);
            } else {
                bitSet.clear(i);
            }
            ++i;
        }
    }

    public static void revers(BitSet bitSet) {
        int i = 0;
        while (i < bitSet.length()) {
            if (bitSet.get(i)) {
                bitSet.clear(i);
            } else {
                bitSet.set(i);
            }
            ++i;
        }
    }

    public static int toInt(BitSet bitSet) {
        return Integer.parseInt(BcBitUtil.toBinaryString(bitSet), 2);
    }

    public static String toBinaryString(BitSet bitSet) {
        StringBuilder sb = new StringBuilder(8);
        int i = 0;
        while (i < 8) {
            if (bitSet.get(8 - i - 1)) {
                sb.append('1');
            } else {
                sb.append('0');
            }
            ++i;
        }
        return sb.toString();
    }

    public static void setBCC(BitSet bccBitSet, BitSet bitSet2, boolean isEven) {
        int i = 0;
        while (i < 8) {
            if (isEven) {
                if (bccBitSet.get(i) && !bitSet2.get(i) || !bccBitSet.get(i) && bitSet2.get(i)) {
                    bccBitSet.set(i);
                } else {
                    bccBitSet.clear(i);
                }
            } else if (bccBitSet.get(i) && bitSet2.get(i) || !bccBitSet.get(i) && !bitSet2.get(i)) {
                bccBitSet.set(i);
            } else {
                bccBitSet.clear(i);
            }
            ++i;
        }
    }
}

