/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Level;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import oracle.jdbc.babelfish.BabelfishConnection;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CXAResource;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.proxy._Proxy_;
import oracle.jdbc.xa.OracleXAResource;
import oracle.jdbc.xa.client.OracleXAConnection;

public class T4CXAConnection
extends OracleXAConnection {
    private final String CLASS_NAME = T4CXAConnection.class.getName();
    public static final long serialVersionUID = 1L;

    public T4CXAConnection(Connection _physicalConnection) throws XAException {
        super(_physicalConnection);
        this.xaResource = null;
    }

    @Override
    public XAResource getXAResource() throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            try {
                if (this.xaResource == null) {
                    OracleConnection physicalConnection = this.physicalConn instanceof BabelfishConnection ? (T4CConnection)((_Proxy_)((Object)this.physicalConn))._getDelegate_() : this.physicalConn;
                    this.xaResource = new T4CXAResource(physicalConnection, this, this.isXAResourceTransLoose);
                    if (this.logicalHandle != null) {
                        ((OracleXAResource)this.xaResource).setLogicalConnection(this.logicalHandle);
                    }
                }
            }
            catch (XAException xae) {
                this.debug(Level.FINEST, SecurityLabel.UNKNOWN, this.CLASS_NAME, "getXAResource", null, null, xae);
                this.xaResource = null;
                if (xae.getCause() instanceof SQLException) {
                    throw (SQLException)xae.getCause();
                }
                throw DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), xae);
            }
            XAResource xAResource = this.xaResource;
            return xAResource;
        }
    }
}

