/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.swg;

import ext.lib.swg.SwgPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.image.BufferedImage;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class SwgTabbedPaneNew
extends JTabbedPane {
    private static final long serialVersionUID = 2853643249591819890L;
    protected ImageIcon closeIcon;
    protected boolean delayedEvaluationEnabled;
    protected Component originalComponent;

    public SwgTabbedPaneNew() {
    }

    public SwgTabbedPaneNew(int tabPlacement) {
        super(tabPlacement);
    }

    public SwgTabbedPaneNew(int tabPlacement, int tabLayoutPolicy) {
        super(tabPlacement, tabLayoutPolicy);
    }

    @Override
    public void addTab(String title, final Component component) {
        JPanel tab = new JPanel(new BorderLayout());
        tab.setOpaque(false);
        JLabel label = new JLabel(title);
        label.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 4));
        tab.add((Component)label, "West");
        tab.setBorder(BorderFactory.createEmptyBorder(2, 1, 1, 1));
        if (this.closeIcon != null) {
            Dimension buttonSize = new Dimension(this.closeIcon.getIconWidth(), this.closeIcon.getIconHeight());
            JButton closeButton = new JButton(this.closeIcon);
            closeButton.setPreferredSize(buttonSize);
            closeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    SwgTabbedPaneNew.this.removeTabAt(SwgTabbedPaneNew.this.indexOfComponent(component));
                }
            });
            tab.add((Component)closeButton, "East");
        }
        if (this.delayedEvaluationEnabled) {
            if (this.getTabCount() == 0) {
                this.originalComponent = component;
                super.addTab(null, new DummyPanel());
            } else {
                super.addTab(null, component);
            }
        } else {
            super.addTab(null, component);
        }
        this.setTabComponentAt(this.getTabCount() - 1, tab);
    }

    @Override
    public void setSelectedIndex(int index) {
        Component component = this.getComponentAt(index);
        if (component instanceof SwgTabbedPaneNew) {
            SwgTabbedPaneNew tabbedPane = (SwgTabbedPaneNew)component;
            tabbedPane.fireFirst();
        }
        super.setSelectedIndex(index);
    }

    public void closeIconEnabled(boolean closeIconEnabled) throws Exception {
        if (closeIconEnabled) {
            ImageIcon imageIcon;
            BufferedImage image = ImageIO.read(this.getClass().getResourceAsStream("images/close_16.gif"));
            this.closeIcon = imageIcon = new ImageIcon(image);
        } else {
            this.closeIcon = null;
        }
    }

    public boolean delayedEvaluationEnabled() {
        return this.delayedEvaluationEnabled;
    }

    public void setDelayedEvaluationEnabled(boolean delayedEvaluationEnabled) {
        this.delayedEvaluationEnabled = delayedEvaluationEnabled;
    }

    public void fireFirst() {
        if (this.getTabCount() == 0) {
            return;
        }
        Component component = this.getComponentAt(0);
        if (component instanceof DummyPanel) {
            this.setComponentAt(0, this.originalComponent);
            if (this.originalComponent instanceof SwgPanel) {
                SwgPanel panel = (SwgPanel)this.originalComponent;
                ComponentEvent componentEvent = new ComponentEvent(this, 102);
                panel.componentShown(componentEvent);
            }
        }
    }

    class DummyPanel
    extends JPanel {
        DummyPanel() {
        }
    }
}

