/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.doc.script;

import ext.base.core.BcNumberUtil;
import ext.base.core.BcStringUtil;
import ext.base.log.BcLogUtil;
import ext.lib.doc.script.BcAbstractScriptParser;
import ext.lib.doc.script.DcfScriptConstants;
import ext.lib.doc.script.DcfScriptUtil;
import ext.lib.doc.script.DcfTextShapeScriptParser;
import ext.lib.doc.util.DcfDocumentUtil;
import java.io.BufferedReader;
import java.io.CharArrayReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import nlc.lib.doc.DcfPage;
import nlc.lib.doc.shape.DcfArcShape;
import nlc.lib.doc.shape.DcfEllipseShape;
import nlc.lib.doc.shape.DcfLineShape;
import nlc.lib.doc.shape.DcfShape;
import nlc.lib.doc.shape.DcfShapeGroup;
import nlc.lib.doc.shape.DcfTextShape;
import nlc.lib.doc.shape.barcode.DcfAbstractBarcodeShape;
import nlc.lib.doc.shape.barcode.DcfBarcodeShape;
import nlc.lib.doc.shape.barcode.DcfDataMatrixShape;
import nlc.lib.doc.shape.barcode.DcfItfShape;
import nlc.lib.doc.shape.barcode.DcfNw7Shape;

public class DcfScriptParser
extends BcAbstractScriptParser {
    public static final int MODE_init = 1;
    public static final int MODE_paramName = 11;
    public static final int MODE_operand = 12;
    public static final int MODE_paramValue = 13;
    public static final int INDEX_OFFSET = 3;
    protected DcfTextShapeScriptParser textShapeScriptParser = new DcfTextShapeScriptParser();
    protected TempMediaSizeName tempMediaSizeName = new TempMediaSizeName();
    protected DcfPage dcfPage;
    protected DcfShapeGroup shapeGroup1;
    protected DcfShapeGroup shapeGroup2;
    protected String version;
    protected MediaSize mediaSize;
    protected String shapeType;
    protected String gvValName;
    protected String mtValName;

    protected void initValue() {
        this.dcfPage = null;
        this.shapeGroup1 = null;
        this.shapeGroup2 = null;
        this.version = null;
        this.mediaSize = null;
        this.shapeType = null;
        this.gvValName = null;
        this.mtValName = null;
    }

    public DcfPage toPage(InputStream is) throws Exception {
        this.initValue();
        Charset charset = Charset.forName(DcfScriptConstants.CHAR_SET);
        BufferedReader reader = new BufferedReader(new InputStreamReader(is, charset));
        this.dcfPage = DcfDocumentUtil.createReportPage();
        this.startParse(reader);
        return this.dcfPage;
    }

    public DcfPage toPage(String script) throws Exception {
        this.initValue();
        Charset charset = Charset.forName(DcfScriptConstants.CHAR_SET);
        BufferedReader reader = new BufferedReader(new CharArrayReader(script.toCharArray()));
        this.dcfPage = DcfDocumentUtil.createReportPage();
        this.startParse(reader);
        return this.dcfPage;
    }

    @Override
    protected void scriptParserEvent(int eventId, StringBuilder sb) throws Exception {
        switch (eventId) {
            case 11: {
                break;
            }
            case 12: {
                break;
            }
            case 21: {
                this.gvValName = sb.toString();
                break;
            }
            case 22: {
                if (this.gvValName.equals("v")) {
                    this.version = sb.toString();
                    break;
                }
                if (this.gvValName.equals("s")) {
                    this.mediaSize = this.getMediaSize(sb.toString());
                    break;
                }
                if (this.gvValName.equals("o")) {
                    int orientation = 0;
                    orientation = BcStringUtil.equals(sb.toString(), "l") ? 0 : (BcStringUtil.equals(sb.toString(), "r") ? 2 : 1);
                    this.dcfPage.setPaperSize(this.mediaSize, orientation);
                    break;
                }
                if (!this.gvValName.equals("b")) break;
                this.dcfPage.isBorder = sb.toString().equals("y");
                break;
            }
            case 31: {
                BcLogUtil.debug("EV_METHOD_NAME:sb=" + sb);
                this.shapeGroup2 = this.dcfPage.getGroup(sb.toString());
                if (this.shapeGroup2 != null) break;
                this.shapeGroup2 = new DcfShapeGroup();
                this.shapeGroup2.setName(sb.toString());
                this.dcfPage.addGroup(this.shapeGroup2);
                break;
            }
            case 32: {
                break;
            }
            case 41: {
                this.shapeType = sb.toString();
                break;
            }
            case 42: {
                this.parseShapeParameter(sb);
                break;
            }
            case 51: {
                this.mtValName = sb.toString();
                break;
            }
            case 52: {
                if (this.shapeGroup2 == null) break;
                if (this.mtValName.equals("x")) {
                    this.shapeGroup2.setX(BcNumberUtil.parseDouble(sb.toString()));
                    break;
                }
                if (this.mtValName.equals("y")) {
                    this.shapeGroup2.setY(BcNumberUtil.parseDouble(sb.toString()));
                    break;
                }
                if (this.mtValName.equals("w")) {
                    this.shapeGroup2.setWidth(BcNumberUtil.parseDouble(sb.toString()));
                    break;
                }
                if (!this.mtValName.equals("h")) break;
                this.shapeGroup2.setHeight(BcNumberUtil.parseDouble(sb.toString()));
            }
        }
    }

    protected void parseShapeParameter(CharSequence parameter) throws Exception {
        ArrayList<String> paramList = new ArrayList<String>();
        HashMap<String, String> paramMap = new HashMap<String, String>();
        DcfScriptUtil.parseParameter(parameter, paramList, paramMap);
        if (BcStringUtil.equals(this.shapeType, "r")) {
            DcfTextShape textShape = this.parseTextShape(paramList, paramMap);
            this.shapeGroup2.addShape(textShape);
        } else if (BcStringUtil.equals(this.shapeType, "l")) {
            DcfLineShape lineShape = this.parseLineShape(paramList, paramMap);
            this.shapeGroup2.addShape(lineShape);
        } else if (BcStringUtil.equals(this.shapeType, "e")) {
            DcfEllipseShape ellipseShape = this.parseEllipseShape(paramList, paramMap);
            this.shapeGroup2.addShape(ellipseShape);
        } else if (BcStringUtil.equals(this.shapeType, "a")) {
            DcfArcShape arcShape = this.parseArcParameter(paramList, paramMap);
            this.shapeGroup2.addShape(arcShape);
        } else if (BcStringUtil.equals(this.shapeType, "b")) {
            DcfAbstractBarcodeShape barcodeShape = this.parseBarcodeShape(paramList, paramMap);
            this.shapeGroup2.addShape(barcodeShape);
        }
    }

    protected static void parseShapeParameterCommon(DcfShape shape, List<String> paramList) throws Exception {
        shape.setName(paramList.get(0));
        shape.setX(BcNumberUtil.parseDouble(paramList.get(1), 0.0));
        shape.setY(BcNumberUtil.parseDouble(paramList.get(2), 0.0));
    }

    protected DcfTextShape parseTextShape(List<String> paramList, Map<String, String> paramMap) throws Exception {
        DcfTextShape textShape = new DcfTextShape();
        DcfScriptParser.parseShapeParameterCommon(textShape, paramList);
        this.textShapeScriptParser.parse(textShape, paramList, paramMap);
        return textShape;
    }

    protected DcfLineShape parseLineShape(List<String> paramList, Map<String, String> paramMap) throws Exception {
        DcfLineShape lineShape = new DcfLineShape();
        DcfScriptParser.parseShapeParameterCommon(lineShape, paramList);
        lineShape.getLine().x2 = BcNumberUtil.parseDouble(paramList.get(3), 0.0);
        lineShape.getLine().y2 = BcNumberUtil.parseDouble(paramList.get(4), 0.0);
        return lineShape;
    }

    protected DcfEllipseShape parseEllipseShape(List<String> paramList, Map<String, String> paramMap) throws Exception {
        DcfEllipseShape ellipseShape = new DcfEllipseShape();
        DcfScriptParser.parseShapeParameterCommon(ellipseShape, paramList);
        DcfTextShape textShapeTmp = new DcfTextShape();
        this.textShapeScriptParser.parse(textShapeTmp, paramList, paramMap);
        ellipseShape.setX(textShapeTmp.getX());
        ellipseShape.setY(textShapeTmp.getY());
        ellipseShape.setRadius(textShapeTmp.getRectangle().width);
        return ellipseShape;
    }

    public DcfArcShape parseArcParameter(List<String> paramList, Map<String, String> paramMap) throws Exception {
        DcfArcShape arcShape = new DcfArcShape();
        DcfScriptParser.parseShapeParameterCommon(arcShape, paramList);
        arcShape.getArc().width = BcNumberUtil.parseDouble(paramList.get(3));
        arcShape.getArc().height = BcNumberUtil.parseDouble(paramList.get(4));
        arcShape.getArc().start = BcNumberUtil.parseDouble(paramList.get(5));
        arcShape.getArc().extent = BcNumberUtil.parseDouble(paramList.get(6));
        arcShape.getArc().setArcType(BcNumberUtil.parseInteger(paramList.get(7)));
        arcShape.lineWidth = BcNumberUtil.parseDouble(paramList.get(8));
        arcShape.lineType = paramList.get(9);
        return arcShape;
    }

    protected DcfAbstractBarcodeShape parseBarcodeShape(List<String> paramList, Map<String, String> paramMap) throws Exception {
        String barcodeType = paramMap.get("bt");
        DcfAbstractBarcodeShape barcodeShape = null;
        if (!BcStringUtil.equals(barcodeType, "code128")) {
            if (BcStringUtil.equals(barcodeType, "code39")) {
                barcodeShape = new DcfBarcodeShape();
            } else if (BcStringUtil.equals(barcodeType, "ITF")) {
                barcodeShape = new DcfItfShape();
            } else if (BcStringUtil.equals(barcodeType, "NW-7")) {
                barcodeShape = new DcfNw7Shape();
            } else if (BcStringUtil.equals(barcodeType, "DataMatrix")) {
                barcodeShape = new DcfDataMatrixShape();
            } else {
                throw new Exception("not supported barcode type. '" + barcodeType + "'");
            }
        }
        DcfScriptParser.parseShapeParameterCommon(barcodeShape, paramList);
        barcodeShape.setWidth(BcNumberUtil.parseDouble(paramList.get(3), 0.0));
        barcodeShape.setHeight(BcNumberUtil.parseDouble(paramList.get(4), 0.0));
        return barcodeShape;
    }

    public MediaSize getMediaSize(String mediaSizeNameStr) throws Exception {
        MediaSizeName[] mediaSizeNames = this.tempMediaSizeName.getEnumValueTable2();
        int i = 0;
        while (i < mediaSizeNames.length) {
            MediaSizeName mediaSizeName = mediaSizeNames[i];
            if (mediaSizeNameStr.equalsIgnoreCase(mediaSizeName.toString())) {
                return MediaSize.getMediaSizeForName(mediaSizeName);
            }
            ++i;
        }
        return null;
    }

    class TempMediaSizeName
    extends MediaSizeName {
        public TempMediaSizeName() {
            super(-1);
        }

        public MediaSizeName[] getEnumValueTable2() {
            return (MediaSizeName[])this.getEnumValueTable();
        }
    }
}

