/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xfil.rmo;

import ext.base.core.BcTimeUtil;
import ext.base.log.BcLogUtil;
import ext.base.mmd.MmdModel;
import ext.base.util.BcResult;
import ext.base.util.BcWords;
import ext.lib.datasource.DtsSession;
import ext.lib.datasource.DtsSessionFactory;
import ext.lib.datasource.DtsSessionFactoryManegaer;
import ext.lib.rmi.common.RmiRemoteMethod;
import ext.lib.rmi.model.RmiRmoArgument;
import ext.lib.rmi.rmo.RmiAbstractRMO;
import ext.lib.sql.SqlDefinitionCondition;
import ext.lib.sql.SqlUtil;
import ext.lib.sql.context.SqlContext;
import ext.lib.task.TskAbstractCallable;
import ext.lib.task.TskCallableUnit;
import ext.lib.task.TskTaskManager;
import ext.module.xfil.common.XfilCaptureParam;
import ext.module.xfil.common.XfilCaptureUtil;
import ext.module.xfil.common.XfilConstants;
import ext.module.xfil.common.XfilUtil;
import ext.module.xfil.common.XfilWords;
import ext.module.xfil.dao.XfilCrawlDAO;
import ext.module.xfil.dao.XfilUriEntityDAO;
import ext.module.xfil.model.XfilAnalysisCondition;
import ext.module.xfil.model.XfilAnalysisResult;
import ext.module.xfil.model.XfilConditionWowk;
import ext.module.xfil.model.XfilCrawl;
import ext.module.xfil.model.XfilUriEntity;
import ext.module.xfil.model.XfilVCaptureCondition;
import ext.module.xfil.rmo.TempTask;
import ext.module.xfil.rmo.XfilAnalysisTask;
import ext.module.xfil.server.XfilFileCrawlTask;
import ext.module.xfil.server.XfilServerUtil;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class XfilCrawlRMO
extends RmiAbstractRMO {
    public void putCrawl(RmiRmoArgument rmoArg) throws Exception {
        XfilCrawl crawl1 = (XfilCrawl)rmoArg.getRequest().getData();
        Throwable throwable = null;
        Object var4_6 = null;
        try (DtsSession dtsSessionWk = XfilServerUtil.getInstance().createDtsSession(this);){
            XfilCrawl craw2 = null;
            if (crawl1.id <= 0L) {
                craw2 = crawl1;
            } else {
                craw2 = (XfilCrawl)XfilCrawlDAO.getInstance().getById(dtsSessionWk, crawl1.id);
                craw2.name = crawl1.name;
                craw2.note = crawl1.note;
            }
            XfilCrawlDAO.getInstance().putEntity(dtsSessionWk, craw2);
            dtsSessionWk.commit();
            rmoArg.getRespons().addData(craw2);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void deleteCrawl(RmiRmoArgument rmoArg) throws Exception {
        long crawlId = rmoArg.getRequest().getDataAsLong();
        this.getLogger().info("deleteCrawl:.crawlId=" + crawlId);
        Throwable throwable = null;
        Object var5_6 = null;
        try (DtsSession dtsSessionWk = XfilServerUtil.getInstance().createDtsSession(this);){
            BcResult result = new BcResult();
            XfilCrawl crawl = (XfilCrawl)XfilCrawlDAO.getInstance().getById(dtsSessionWk, crawlId);
            result.setUserObject(result);
            if (crawl != null) {
                BcResult result2 = XfilServerUtil.getInstance().deleteCrawl(dtsSessionWk, crawl);
                result.addResult(result2);
            } else {
                result.addError(BcWords.getInstance().Target_object_does_not_exist);
            }
            rmoArg.getRespons().addData(result);
            dtsSessionWk.commit();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void getCrawl(RmiRmoArgument rmoArg) throws Exception {
        long crawlId = rmoArg.getRequest().getDataAsLong();
        Throwable throwable = null;
        Object var5_6 = null;
        try (DtsSession dtsSessionWk = XfilServerUtil.getInstance().createDtsSession(this);){
            XfilCrawl crawl = (XfilCrawl)XfilCrawlDAO.getInstance().getById(dtsSessionWk, crawlId);
            rmoArg.getRespons().addData(crawl);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void deleteMissing(RmiRmoArgument rmoArg) throws Exception {
        long crawlId = rmoArg.getRequest().getDataAsLong();
        this.getLogger().info("deleteCrawl:.crawlId=" + crawlId);
        Throwable throwable = null;
        Object var5_6 = null;
        try (DtsSession dtsSessionWk = XfilServerUtil.getInstance().createDtsSession(this);){
            BcResult result = new BcResult();
            XfilCrawl crawl = (XfilCrawl)XfilCrawlDAO.getInstance().getById(dtsSessionWk, crawlId);
            if (crawl != null) {
                XfilUriEntityDAO uriEntityDAO = XfilServerUtil.getInstance().getUriEntityDAO();
                List uriEntityList1 = uriEntityDAO.getList(dtsSessionWk, XfilUriEntityDAO.Mode.missing, -1L, crawl.id, null, null, null, -1, false);
                this.getLogger().info("\u6240\u5728\u4e0d\u660e\u6570=" + uriEntityList1.size());
                int i = 0;
                while (i < uriEntityList1.size()) {
                    XfilUriEntity uriEntity = (XfilUriEntity)uriEntityList1.get(i);
                    XfilUtil.deleteTthumbnails(uriEntity);
                    int deleteCnt = uriEntityDAO.deleteByCrawlId(dtsSessionWk, crawl.id, uriEntity.id, true);
                    dtsSessionWk.commit();
                    this.getLogger().debug("deleteCnt=" + deleteCnt);
                    ++i;
                }
                XfilServerUtil.getInstance().createSummary(dtsSessionWk, crawl);
                dtsSessionWk.commit();
            } else {
                result.addError(BcWords.getInstance().Target_object_does_not_exist);
            }
            rmoArg.getRespons().addData(result);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void getCrawlList(RmiRmoArgument rmoArg) throws Exception {
        Throwable throwable = null;
        Object var3_5 = null;
        try (DtsSession dtsSessionWk = XfilServerUtil.getInstance().createDtsSession(this);){
            List List2 = XfilCrawlDAO.getInstance().getList(dtsSessionWk, XfilCrawlDAO.Mode.id, 0L, null, null, 0, this.objectPoolEnabled);
            rmoArg.getRespons().addData(List2);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void fileCrawl(RmiRmoArgument rmoArg) throws Exception {
        XfilAnalysisCondition analysisConditionA = (XfilAnalysisCondition)rmoArg.getRequest().getData();
        XfilAnalysisCondition analysisConditionB = (XfilAnalysisCondition)rmoArg.getRequest().getData();
        XfilVCaptureCondition captureCondition = (XfilVCaptureCondition)rmoArg.getRequest().getData();
        DtsSessionFactory dtsSessionFactoryMain = DtsSessionFactoryManegaer.getInstance().getSessionFactory("main");
        Throwable throwable = null;
        Object var7_9 = null;
        try {
            DtsSession dtsSessionMain = dtsSessionFactoryMain.createSession(this);
            try {
                try (DtsSession dtsSessionWk = XfilServerUtil.getInstance().createDtsSession(this);){
                    this.fileCrawl_L2(rmoArg, dtsSessionMain, dtsSessionWk, analysisConditionA, analysisConditionB, captureCondition);
                }
                if (dtsSessionMain != null) {
                    dtsSessionMain.close();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (dtsSessionMain != null) {
                    dtsSessionMain.close();
                }
                throw throwable;
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    public void fileCrawl_L2(RmiRmoArgument rmoArg, DtsSession dtsSessionMain, DtsSession dtsSessionWk, XfilAnalysisCondition analysisConditionA, XfilAnalysisCondition analysisConditionB, XfilVCaptureCondition captureCondition) throws Exception {
        BcResult result1 = new BcResult();
        XfilConditionWowk conditionWowk = null;
        if (analysisConditionA.execute) {
            BcResult result2 = XfilServerUtil.getInstance().validateCapturingCondition(dtsSessionMain);
            result1.addResult(result2);
            result2 = XfilServerUtil.getInstance().validateCrawlCondition(dtsSessionMain, analysisConditionA);
            conditionWowk = (XfilConditionWowk)result2.getUserObject();
            result1.addResult(result2);
        }
        if (analysisConditionB.execute) {
            XfilCaptureParam videoCaptureParam = XfilCaptureUtil.convert(captureCondition);
            BcResult result2 = XfilServerUtil.getInstance().validateCapturingCondition(dtsSessionMain);
            result1.addResult(result2);
            result2 = XfilServerUtil.getInstance().validateCapturingCondition(videoCaptureParam);
            result1.addResult(result2);
            result2 = XfilServerUtil.getInstance().validateCapturingCondition(analysisConditionA, analysisConditionB);
            result1.addResult(result2);
        }
        rmoArg.getRespons().addData(result1);
        if (result1.hasError()) {
            return;
        }
        XfilCrawl crawl = null;
        Future<XfilCrawl> fileCrawlTaskFuture = null;
        if (analysisConditionA.execute) {
            if (analysisConditionA.crawlId <= 0L) {
                crawl = new XfilCrawl();
                crawl.seq = 1;
            } else {
                crawl = (XfilCrawl)XfilCrawlDAO.getInstance().getById(dtsSessionWk, analysisConditionA.crawlId);
                ++crawl.seq;
            }
            crawl.startDateTime = BcTimeUtil.createCalendar();
            crawl.name = analysisConditionA.crawlName;
            crawl.directory = analysisConditionA.directory;
            crawl.fileExtention = analysisConditionA.fileExtention;
            this.getLogger().info("crawl.name=" + crawl.name);
        }
        if (analysisConditionB.execute) {
            if (crawl == null) {
                crawl = (XfilCrawl)XfilCrawlDAO.getInstance().getById(dtsSessionWk, analysisConditionB.crawlId);
            }
            crawl.scFileExtention = analysisConditionB.fileExtention;
            crawl.scIntervalSec = captureCondition.intervalSec;
            crawl.scTopMarginSec = captureCondition.topMarginSec;
            crawl.scBotomMarginSec = captureCondition.botomMarginSec;
            crawl.scCapturingCountMax = captureCondition.capturingCountMax;
            crawl.scCapturingWidth = captureCondition.capturingWidth;
            crawl.scCapturingHeight = captureCondition.capturingHeight;
        }
        XfilCrawlDAO.getInstance().putEntity(dtsSessionWk, crawl);
        dtsSessionWk.commit();
        if (analysisConditionA.execute) {
            fileCrawlTaskFuture = this.fileCrawl_L3(crawl, analysisConditionA, conditionWowk);
        }
        if (analysisConditionB.execute) {
            TempTask tempTask = new TempTask();
            tempTask.setCondition(analysisConditionB, captureCondition, fileCrawlTaskFuture);
            ExecutorService executorService = Executors.newCachedThreadPool();
            Future future = executorService.submit(tempTask);
            executorService.shutdown();
        }
    }

    public Future<XfilCrawl> fileCrawl_L3(XfilCrawl crawl, XfilAnalysisCondition analysisCondition, XfilConditionWowk conditionWowk1) throws Exception {
        DtsSession dtsSessionWk = XfilServerUtil.getInstance().createDtsSession(this);
        XfilFileCrawlTask fileCrawlTask = new XfilFileCrawlTask();
        fileCrawlTask.analysisCondition = analysisCondition;
        fileCrawlTask.crawlCondition = conditionWowk1;
        fileCrawlTask.dtsSessionWk = dtsSessionWk;
        fileCrawlTask.crawl = crawl;
        fileCrawlTask.uriEntitydao = XfilServerUtil.getInstance().getUriEntityDAO();
        fileCrawlTask.setName(String.valueOf(XfilWords.getInstance().FileCrawl.toPlain()) + ":ID=" + crawl.id + " " + crawl.name);
        ExecutorService executorService = Executors.newCachedThreadPool();
        Future<XfilCrawl> future = executorService.submit(fileCrawlTask);
        executorService.shutdown();
        TskCallableUnit callableUnit = new TskCallableUnit((TskAbstractCallable)fileCrawlTask, future);
        TskTaskManager.getInstance().addCallableUnit(callableUnit);
        return future;
    }

    public String createFileTable______XXXXX(DtsSession dtsSessionMain, DtsSession dtsSessionWk, XfilCrawl crawl) throws Exception {
        SqlContext sqlContextWk = dtsSessionWk.getSqlContext();
        String tableName = XfilConstants.TableName.xfil_entity.name();
        if (sqlContextWk.existTable(dtsSessionWk.getConnection(), tableName)) {
            this.getLogger().debug("exist.tableName=" + tableName);
            return tableName;
        }
        SqlContext sqlContextMain = dtsSessionMain.getSqlContext();
        MmdModel mmdModel = sqlContextMain.createModelMetaData(dtsSessionMain.getConnection(), tableName);
        String sql = sqlContextWk.createCreateTableQuery(mmdModel, true, SqlDefinitionCondition.createDefault());
        this.getLogger().debug("sql=" + sql);
        int cnt = SqlUtil.executeUpdate(dtsSessionWk.getConnection(), sql);
        dtsSessionWk.commit();
        return tableName;
    }

    public void analysis2(RmiRmoArgument rmoArg) throws Exception {
        XfilAnalysisCondition analysisCondition = (XfilAnalysisCondition)rmoArg.getRequest().getData();
        List uriEntityList = (List)rmoArg.getRequest().getData();
        XfilAnalysisTask analysisTask = new XfilAnalysisTask();
        analysisTask.setCondition(analysisCondition, uriEntityList);
        analysisTask.call();
        XfilAnalysisResult analysisResult = analysisTask.analysisResult;
        BcLogUtil.debug("#2:analysisResult=" + analysisResult);
        rmoArg.getRespons().addData(analysisResult);
    }

    public static enum Method implements RmiRemoteMethod
    {
        putCrawl,
        getCrawl,
        deleteCrawl,
        deleteMissing,
        getCrawlList,
        fileCrawl;


        @Override
        public String getMethodName() {
            return this.name();
        }
    }
}

