/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.helper;

import java.util.Hashtable;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Executor;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.helper.SingleCheckExecutor;

public class IgnoreDependenciesExecutor
implements Executor {
    private static final SingleCheckExecutor SUB_EXECUTOR = new SingleCheckExecutor();

    @Override
    public void executeTargets(Project project, String[] targetNames) throws BuildException {
        Hashtable<String, Target> targets = project.getTargets();
        BuildException thrownException = null;
        int i = 0;
        while (i < targetNames.length) {
            try {
                Target t = targets.get(targetNames[i]);
                if (t == null) {
                    throw new BuildException("Unknown target " + targetNames[i]);
                }
                t.performTasks();
            }
            catch (BuildException ex) {
                if (project.isKeepGoingMode()) {
                    thrownException = ex;
                }
                throw ex;
            }
            ++i;
        }
        if (thrownException != null) {
            throw thrownException;
        }
    }

    @Override
    public Executor getSubProjectExecutor() {
        return SUB_EXECUTOR;
    }
}

