/*
 * Decompiled with CFR 0.152.
 */
package ext.scf8.swg;

import ext.base.log.BcLogUtil;
import ext.base.util.BcWords;
import ext.lib.rmi.model.RmiRequest;
import ext.lib.swg.SwgArrangementHint;
import ext.lib.swg.SwgButton;
import ext.lib.swg.SwgPanel;
import ext.lib.swg.SwgTextField;
import ext.lib.swg.SwgUtil;
import ext.scf4.swg.HswgComponentFactory;
import ext.scf6.swg.JswgComponentUtil;
import ext.scf8.swg.KswgAbstractTableSelectPanel;
import ext.scf8.swg.KswgMasterControl;
import ext.scf8.swg.KswgMasterControlEventHandler;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;

public abstract class KswgAbstractMasterControl
extends SwgPanel
implements KswgMasterControl {
    protected SwgArrangementHint arrangementHint;
    protected SwgTextField codeField;
    protected SwgTextField nameField;
    protected SwgButton browsButton;
    protected KswgAbstractTableSelectPanel selectPanel;
    protected List<KswgMasterControlEventHandler> eventHandlerList = new ArrayList<KswgMasterControlEventHandler>();
    protected Object dataId;
    protected String title;
    protected int enterpriseId;

    public KswgAbstractMasterControl() throws Exception {
        this.arrangementHint = HswgComponentFactory.createArrangementHint();
        this.codeField = new InnerTextField();
        this.nameField = new SwgTextField();
        this.browsButton = new SwgButton(JswgComponentUtil.browsButtonText);
        this.browsButton.addActionListener(this.actionListener);
        this.browsButton.setFont(SwgUtil.getBrowsButtonFont(this.getFont()));
        this.setSize(340, 24);
    }

    @Override
    public RmiRequest getRequest() throws Exception {
        return null;
    }

    @Override
    public abstract String getColumneName_id();

    @Override
    public abstract String getColumneName_code();

    @Override
    public abstract String getColumneName_name();

    @Override
    public Font getFont() {
        return super.getFont();
    }

    @Override
    public Object getDataId() {
        return this.dataId;
    }

    @Override
    public void setDataId(Object dataId) throws Exception {
        this.dataId = dataId;
        int i = 0;
        while (i < this.eventHandlerList.size()) {
            KswgMasterControlEventHandler eventHandler = this.eventHandlerList.get(i);
            eventHandler.updated(this);
            ++i;
        }
    }

    @Override
    public String getDataCode() throws Exception {
        return this.codeField.getText();
    }

    @Override
    public void setDataCode(Object code) throws Exception {
        if (code != null) {
            this.codeField.setText(code.toString());
        } else {
            this.codeField.setText("");
        }
    }

    @Override
    public String getDataName() throws Exception {
        return this.nameField.getTextNull();
    }

    @Override
    public void setDataName(Object name) throws Exception {
        if (name != null) {
            this.nameField.setText(name.toString());
        } else {
            this.nameField.setText("");
        }
    }

    public void clear() {
        this.dataId = null;
        this.codeField.setText("");
        this.nameField.setText("");
    }

    @Override
    public void setEnabled(boolean bool) {
        super.setEnabled(bool);
        this.codeField.setEnabled(bool);
        this.nameField.setEnabled(bool);
        this.browsButton.setEnabled(bool);
    }

    public void setEditable(boolean bool) {
        this.browsButton.setEnabled(bool);
    }

    public void addEventHandler(KswgMasterControlEventHandler eventHandler) {
        this.eventHandlerList.add(eventHandler);
    }

    public void removeEventHandler(KswgMasterControlEventHandler eventHandler) {
        this.eventHandlerList.remove(eventHandler);
    }

    public Object[] getSelectedObjects() {
        Object[] objArray = new Object[]{this.dataId};
        return objArray;
    }

    @Override
    public void actionPerformed2(ActionEvent ev) throws Exception {
        super.actionPerformed2(ev);
        if (ev.getSource() == this.browsButton) {
            this.browsButtonAction();
        }
    }

    public void browsButtonAction() throws Exception {
        if (this.selectPanel == null) {
            this.selectPanel = new KswgAbstractTableSelectPanel(this);
        }
        try {
            this.selectPanel.loadData(this.getRequest());
            this.selectPanel.showAsDialog(this);
        }
        catch (Exception ex) {
            BcLogUtil.error(ex);
            JOptionPane.showMessageDialog(this, ex.getMessage(), BcWords.getInstance().exception, 0);
        }
    }

    @Override
    public void setSize(int width, int height) {
        super.setSize(width, height);
        Dimension buttonSize = SwgUtil.getBrowsButtonSize(this.browsButton.getFont());
        this.browsButton.setPreferredSize(buttonSize);
        this.browsButton.setSize(buttonSize);
        int fieldHeight = this.arrangementHint.rowHeight;
        boolean fieldY = false;
        int buttonY = (height - this.browsButton.getHeight()) / 2;
        if (this.codeField.isEnabled()) {
            Dimension dim = SwgUtil.getTextFieldSize(this.getFont(), 8);
            int buttonX = width - this.browsButton.getWidth();
            int nameFieldWidth = width - dim.width - this.browsButton.getWidth() - 2;
            SwgUtil.setLocation(this, this.codeField, 0.0, (double)fieldY, (double)dim.width, (double)fieldHeight);
            SwgUtil.setLocation(this, this.nameField, (double)(dim.width + 1), (double)fieldY, (double)nameFieldWidth, (double)fieldHeight);
            SwgUtil.setLocation(this, this.browsButton, (double)buttonX, (double)buttonY);
        } else {
            int codeFieldWidth = 0;
            int buttonX = width - this.browsButton.getWidth();
            int nameFieldWidth = width - codeFieldWidth - this.browsButton.getWidth() - 2;
            this.remove(this.codeField);
            SwgUtil.setLocation(this, this.nameField, 0.0, (double)fieldY, (double)nameFieldWidth, (double)fieldHeight);
            SwgUtil.setLocation(this, this.browsButton, (double)buttonX, (double)buttonY);
        }
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setEnterpriseId(int enterpriseId) {
        if (this.enterpriseId == enterpriseId) {
            return;
        }
        this.enterpriseId = enterpriseId;
        this.clear();
    }

    public void setCodeX(String code) throws Exception {
    }

    class InnerTextField
    extends SwgTextField {
        @Override
        public void transferFocus() {
            try {
                KswgAbstractMasterControl.this.setCodeX(this.getText());
            }
            catch (Exception ex) {
                BcLogUtil.error(ex);
            }
            super.transferFocus();
        }
    }
}

