/*
 * Decompiled with CFR 0.152.
 */
package ext.scf4.swg;

import ext.base.core.BcStringUtil;
import ext.base.log.BcLogUtil;
import ext.lib.doc.util.DcfDocumentUtil;
import ext.lib.swg.SwgPanel;
import ext.lib.swg.lookAndFeel.SwgLafManager;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentLinkedQueue;

public class HswgConsolePanel
extends SwgPanel
implements MouseListener,
MouseMotionListener {
    private static final long serialVersionUID = 1814206287650917011L;
    double offImageWidth;
    double offImageHeight;
    Image offImage1;
    public Font font = new Font("Serif", 0, 10);
    double rowGap = 2.0;
    float ratio;
    float ratioCoef;
    FontRenderContext fontRenderContext;
    TextLayout textLayoutSample;
    ConcurrentLinkedQueue<StringBuilder> strQueue = new ConcurrentLinkedQueue();
    int queueMax = 100;
    double leftMargin = 2.0;
    double rightMargin = 2.0;
    double validWidth;
    double gy = 0.0;

    public HswgConsolePanel() throws Exception {
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.setRatio(100.0f);
        this.fontRenderContext = new FontRenderContext(new AffineTransform(), true, true);
        this.textLayoutSample = DcfDocumentUtil.createDefaultTextLayout(this.font, this.fontRenderContext);
    }

    protected void setRatio(float ratio) throws Exception {
        this.ratio = ratio;
        this.ratioCoef = 100.0f / ratio;
        this.offImage1 = null;
    }

    @Override
    public void componentResized(ComponentEvent ev) {
        try {
            this.createOffImage();
        }
        catch (Exception ex) {
            BcLogUtil.error(ex);
        }
        this.paintImmediately(this.getVisibleRect());
    }

    @Override
    public void paint(Graphics gp) {
        if (this.offImage1 == null) {
            try {
                this.createOffImage();
            }
            catch (Exception ex) {
                BcLogUtil.error(ex);
            }
        }
        gp.drawImage(this.offImage1, 0, 0, null);
    }

    protected void createOffImage() throws Exception {
        this.offImageWidth = this.getWidth();
        this.offImageHeight = this.getHeight();
        this.validWidth = this.offImageWidth - this.leftMargin - this.rightMargin;
        Image preOffImage = null;
        if (this.offImage1 != null) {
            preOffImage = this.offImage1;
        }
        this.offImage1 = this.createImage((int)this.offImageWidth, (int)this.offImageHeight);
        Graphics2D gp2d = (Graphics2D)this.offImage1.getGraphics();
        gp2d.setColor(SwgLafManager.getInstance().consoleBgColor);
        gp2d.fillRect(0, 0, (int)this.offImageWidth, (int)this.offImageHeight);
        if (preOffImage != null) {
            gp2d.drawImage(preOffImage, 0, 0, null);
        }
    }

    public void addData(CharSequence data) throws Exception {
        if (BcStringUtil.isEmpty(data)) {
            BcLogUtil.debug("addCharSequence:charSequence=" + data);
            return;
        }
        StringBuilder sb = new StringBuilder(data);
        if (this.strQueue.size() >= this.queueMax) {
            this.strQueue.poll();
        }
        this.strQueue.offer(sb);
        this.addCharSequence_L2(sb.toString());
    }

    protected void addCharSequence_L2(String srcStr) throws Exception {
        AttributedString attributedString = new AttributedString(srcStr);
        attributedString.addAttribute(TextAttribute.FONT, this.font, 0, srcStr.length());
        LineBreakMeasurer lineBreakMeasurer = new LineBreakMeasurer(attributedString.getIterator(), this.fontRenderContext);
        ArrayList<TextLayout> textLayoutList = new ArrayList<TextLayout>();
        ArrayList<CharSequence> textList = new ArrayList<CharSequence>();
        float rowHeight = 0.0f;
        int startPos = 0;
        while (lineBreakMeasurer.getPosition() < srcStr.length()) {
            TextLayout textLayout = lineBreakMeasurer.nextLayout((float)this.validWidth);
            if (rowHeight <= 0.0f) {
                rowHeight = textLayout.getAscent() + textLayout.getDescent();
            }
            textLayoutList.add(textLayout);
            textList.add(srcStr.subSequence(startPos, lineBreakMeasurer.getPosition()));
            startPos = lineBreakMeasurer.getPosition();
        }
        double tmpHeight = (double)textLayoutList.size() * ((double)rowHeight + this.rowGap);
        Image tmpOffImage = this.createImage((int)this.offImageWidth, (int)tmpHeight);
        if (tmpOffImage == null) {
            return;
        }
        Graphics2D gp1 = (Graphics2D)tmpOffImage.getGraphics();
        gp1.setColor(SwgLafManager.getInstance().consoleBgColor);
        gp1.fillRect(0, 0, (int)this.offImageWidth, (int)tmpHeight);
        gp1.setFont(this.font);
        gp1.setColor(SwgLafManager.getInstance().consoleFgColor);
        int i = 0;
        while (i < textLayoutList.size()) {
            TextLayout textLayout = (TextLayout)textLayoutList.get(i);
            double y = (float)i * rowHeight + rowHeight;
            gp1.drawString(((CharSequence)textList.get(i)).toString(), (int)this.leftMargin, (int)y);
            ++i;
        }
        Graphics2D gp2 = (Graphics2D)this.offImage1.getGraphics();
        if (this.gy + tmpHeight > this.offImageHeight) {
            gp2.drawImage(this.offImage1, 0, 0, (int)this.offImageWidth, (int)(this.offImageHeight - tmpHeight), 0, (int)tmpHeight, (int)this.offImageWidth, (int)this.offImageHeight, null);
            this.gy = this.offImageHeight - tmpHeight;
        }
        gp2.drawImage(tmpOffImage, 0, (int)this.gy, (int)this.offImageWidth, (int)tmpHeight, null);
        this.gy += tmpHeight;
        this.paintImmediately(this.getVisibleRect());
    }

    @Override
    public void mouseClicked(MouseEvent ev) {
    }

    @Override
    public void mousePressed(MouseEvent ev) {
    }

    @Override
    public void mouseReleased(MouseEvent ev) {
    }

    @Override
    public void mouseEntered(MouseEvent ev) {
    }

    @Override
    public void mouseExited(MouseEvent ev) {
    }

    @Override
    public void mouseDragged(MouseEvent ev) {
    }

    @Override
    public void mouseMoved(MouseEvent ev) {
    }
}

