/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.nlp;

import com.atilika.kuromoji.ipadic.Token;
import ext.base.core.BcStringUtil;
import ext.base.core.BcUnicode;
import ext.base.log.BcLoggableObject;
import ext.base.util.BcCollectionUtil;
import ext.lib.nlp.ExtNameFinderImpl1;
import ext.lib.nlp.ExtNameFinderImpl2;
import ext.lib.nlp.ExtNameFinderPrefecture;
import ext.lib.nlp.KrmjTokenWrap;
import ext.lib.nlp.KuromojiUtil;
import ext.lib.nlp.NlpElement;
import ext.lib.nlp.NlpNoun;
import ext.lib.nlp.NlpResult;
import ext.lib.nlp.NlpSentenceReformer;
import ext.lib.nlp.NlpTokenizer;
import ext.lib.nlp.OpenNlpUtil;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import opennlp.tools.namefind.NameFinderME;
import opennlp.tools.namefind.TokenNameFinder;
import opennlp.tools.namefind.TokenNameFinderModel;
import opennlp.tools.util.Span;

public class NlpNameFinder
extends BcLoggableObject {
    NlpSentenceReformer sentenceReformer = new NlpSentenceReformer();
    NlpTokenizer nlpTokenizer = new NlpTokenizer();
    List<TokenNameFinder> tokenNameFinderList;
    ExtNameFinderImpl1 nameFinder1 = new ExtNameFinderImpl1();
    ExtNameFinderImpl2 nameFinder2 = new ExtNameFinderImpl2();
    ExtNameFinderPrefecture nameFinderPrefecture = new ExtNameFinderPrefecture();

    public NlpNameFinder() throws Exception {
        this.setup();
    }

    public void setup() throws Exception {
        this.tokenNameFinderList = new ArrayList<TokenNameFinder>();
        InputStream is = this.getClass().getResourceAsStream("rondhuit-ja-ner-1.0.0.bin");
        TokenNameFinderModel tokenNameFinderModel = new TokenNameFinderModel(is);
        this.tokenNameFinderList.add((TokenNameFinder)new NameFinderME(tokenNameFinderModel));
    }

    public NlpResult findName(String src) throws Exception {
        if (BcStringUtil.isEmpty(src)) {
            this.getLogger().warning("src is empty.");
        }
        src = this.sentenceReformer.reform(src);
        List<Token> tokenList1 = this.nlpTokenizer.toTokenList(src);
        List<KrmjTokenWrap> tokenWrapList = KuromojiUtil.tokenWrapList(tokenList1);
        KuromojiUtil.check(tokenWrapList);
        this.nameFinderPrefecture.findName(tokenWrapList);
        ArrayList<NlpElement> elementList1 = new ArrayList<NlpElement>();
        List<NlpElement> elementList2 = this.nameFinder1.findName(tokenWrapList);
        this.temp(elementList2, tokenWrapList);
        elementList1.addAll(elementList2);
        elementList2 = this.nameFinder2.findName(tokenWrapList);
        this.temp(elementList2, tokenWrapList);
        elementList1.addAll(elementList2);
        NlpResult nlpResult = new NlpResult();
        nlpResult.elementList = this.organize(elementList1);
        return nlpResult;
    }

    public List<NlpElement> findName(String[] sentenceArray) throws Exception {
        ArrayList<NlpElement> elementList = new ArrayList<NlpElement>();
        int i = 0;
        while (i < this.tokenNameFinderList.size()) {
            TokenNameFinder tokenNameFinder = this.tokenNameFinderList.get(i);
            Span[] spans = tokenNameFinder.find(sentenceArray);
            if (!BcCollectionUtil.isEmpty(spans)) {
                int j = 0;
                while (j < spans.length) {
                    Span span = spans[j];
                    NlpNoun noun = new NlpNoun();
                    noun.name = OpenNlpUtil.toString(span, sentenceArray);
                    noun.key = noun.name.replace(BcUnicode.Unicode.SPACE.string, "");
                    NlpElement nlpElement = new NlpElement();
                    nlpElement.noun = noun;
                    elementList.add(nlpElement);
                    ++j;
                }
            }
            tokenNameFinder.clearAdaptiveData();
            ++i;
        }
        return elementList;
    }

    public List<NlpElement> organize(List<NlpElement> elementList1) throws Exception {
        LinkedHashMap<String, NlpElement> nounMap = new LinkedHashMap<String, NlpElement>();
        int i = 0;
        while (i < elementList1.size()) {
            NlpElement nlpElement1 = elementList1.get(i);
            NlpElement nlpElement2 = (NlpElement)nounMap.get(nlpElement1.noun.key);
            if (nlpElement2 == null) {
                nounMap.put(nlpElement1.noun.key, nlpElement1);
            } else {
                NlpElement nlpElement3 = this.compare(nlpElement1, nlpElement2);
                nounMap.put(nlpElement3.noun.key, nlpElement3);
            }
            ++i;
        }
        ArrayList<NlpElement> elementList2 = new ArrayList<NlpElement>();
        for (Map.Entry mapEntry : nounMap.entrySet()) {
            elementList2.add((NlpElement)mapEntry.getValue());
        }
        return elementList2;
    }

    public NlpElement compare(NlpElement nlpElement1, NlpElement nlpElement2) throws Exception {
        if (this.score(nlpElement1.noun) >= this.score(nlpElement2.noun)) {
            return nlpElement1;
        }
        return nlpElement2;
    }

    public int score(NlpNoun noun) throws Exception {
        int score = 0;
        if (!BcStringUtil.isEmpty(noun.name)) {
            ++score;
        }
        if (!BcStringUtil.isEmpty(noun.reading)) {
            ++score;
        }
        return score += noun.score;
    }

    public void temp(List<NlpElement> elementList, List<KrmjTokenWrap> tokenWrapList) throws Exception {
        int i = 0;
        while (i < elementList.size()) {
            String suffix;
            NlpElement nlpElement = elementList.get(i);
            NlpNoun noun = nlpElement.noun;
            KrmjTokenWrap tokenWrapLast = BcCollectionUtil.getLast(nlpElement.tokenWrapList);
            KrmjTokenWrap tokenWrap1 = BcCollectionUtil.getElement(tokenWrapList, tokenWrapLast.index + 1);
            KrmjTokenWrap tokenWrap2 = BcCollectionUtil.getElement(tokenWrapList, tokenWrapLast.index + 2);
            if (tokenWrap1 != null && (suffix = "\u88ab\u544a").equals(tokenWrap1.token.getSurface())) {
                nlpElement.suffix = suffix;
            }
            if (BcStringUtil.isEmpty(nlpElement.suffix) && tokenWrap2 != null && ("\u5bb9\u7591\u8005".equals(suffix = String.valueOf(tokenWrap1.token.getSurface()) + tokenWrap2.token.getSurface()) || "\u6b7b\u5211\u56da".equals(suffix))) {
                nlpElement.suffix = suffix;
            }
            if (!BcStringUtil.isEmpty(nlpElement.suffix)) {
                this.getLogger().debug("suffix=" + nlpElement.suffix);
            }
            ++i;
        }
    }
}

