/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.fx.util;

import ext.lib.awt.AwtImageHelper;
import ext.lib.awt.AwtImageUtil;
import ext.lib.fx.util.FxUtil;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import javafx.embed.swing.SwingFXUtils;
import javafx.scene.image.ImageView;
import javafx.stage.Stage;

public class FxImageHelper {
    private static javafx.scene.image.Image stageIconImage;
    private static Map<String, javafx.scene.image.Image> imageMap;

    static {
        imageMap = new HashMap<String, javafx.scene.image.Image>();
    }

    private FxImageHelper() throws Exception {
    }

    public static javafx.scene.image.Image getImage(String name) throws Exception {
        javafx.scene.image.Image image = imageMap.get(name);
        if (image == null) {
            Image awtImage = AwtImageHelper.getImage(name);
            BufferedImage bufferedImage = null;
            bufferedImage = awtImage instanceof BufferedImage ? (BufferedImage)awtImage : AwtImageUtil.toBufferedImage(awtImage);
            image = SwingFXUtils.toFXImage((BufferedImage)bufferedImage, null);
        }
        return image;
    }

    public static ImageView createImageView_icon(String name) throws Exception {
        javafx.scene.image.Image image = FxImageHelper.getImage(name);
        ImageView imageView = new ImageView(image);
        imageView.setPreserveRatio(true);
        imageView.setSmooth(true);
        imageView.setFitWidth(16.0);
        return imageView;
    }

    public static javafx.scene.image.Image getStageIcon() {
        return stageIconImage;
    }

    public static void setStageIcon(Stage stage) throws Exception {
        if (stageIconImage == null) {
            Image awtImage = AwtImageHelper.getWindowIconImage();
            stageIconImage = FxUtil.convImage(awtImage);
        }
        if (stageIconImage != null) {
            stage.getIcons().add((Object)stageIconImage);
        }
    }
}

