/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bsf.util;

import java.io.File;
import java.io.FileInputStream;
import java.util.Hashtable;

class BSFClassLoader
extends ClassLoader {
    Hashtable cache = new Hashtable();
    String tempDir = ".";

    BSFClassLoader() {
    }

    public synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> c = (Class<?>)this.cache.get(name);
        if (c == null) {
            try {
                c = this.findSystemClass(name);
                this.cache.put(name, c);
                return c;
            }
            catch (ClassNotFoundException classNotFoundException) {
                try {
                    byte[] data = this.loadClassData(name);
                    c = this.defineClass(name, data, 0, data.length);
                    this.cache.put(name, c);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new ClassNotFoundException("unable to resolve class '" + name + "'");
                }
            }
        }
        if (resolve) {
            this.resolveClass(c);
        }
        return c;
    }

    private byte[] loadClassData(String name) throws Exception {
        String fileName = String.valueOf(this.tempDir) + File.separatorChar + name + ".class";
        FileInputStream fi = new FileInputStream(fileName);
        byte[] data = new byte[fi.available()];
        fi.read(data);
        fi.close();
        return data;
    }

    public void setTempDir(String tempDir) {
        this.tempDir = tempDir;
    }
}

