/*
 * Decompiled with CFR 0.152.
 */
package ext.base.log;

import ext.base.log.BcLogConstants;
import ext.base.log.BcLogUtil;
import ext.base.log.BcLogger;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;

public class BcLoggerImpl2
implements BcLogger {
    private BcLogger bindLogger;
    private Logger jLogger;

    public BcLoggerImpl2() throws Exception {
        this.setup();
    }

    protected void setup() throws Exception {
        this.jLogger = Logger.getLogger("");
        Handler[] handlers = this.jLogger.getHandlers();
        Level level = Level.FINE;
        ConsoleHandler consoleHandler = null;
        Handler[] handlerArray = handlers;
        int n = handlers.length;
        int n2 = 0;
        while (n2 < n) {
            Handler handler = handlerArray[n2];
            if (handler instanceof ConsoleHandler) {
                consoleHandler = (ConsoleHandler)handler;
                break;
            }
            ++n2;
        }
        if (consoleHandler == null) {
            consoleHandler = new ConsoleHandler();
            this.jLogger.addHandler(consoleHandler);
        }
        BcLogFormatter formatter = new BcLogFormatter();
        consoleHandler.setFormatter(formatter);
        consoleHandler.setLevel(level);
        this.jLogger.setLevel(level);
    }

    @Override
    public void setLogLevel(BcLogConstants.LogLevel logLevel) {
        Level jLogLevel = BcLoggerImpl2.toJLogLevel(logLevel);
        this.jLogger.setLevel(jLogLevel);
    }

    @Override
    public BcLogConstants.LogLevel getLogLevel() {
        return BcLoggerImpl2.toLogLevel(this.jLogger.getLevel());
    }

    @Override
    public void fatal(Object log) {
        String str = BcLogUtil.convertMessage(log);
        this.jLogger.severe(str);
        if (this.bindLogger != null) {
            this.bindLogger.fatal(str);
        }
    }

    @Override
    public void error(Object log) {
        String str = BcLogUtil.convertMessage(log);
        this.jLogger.severe(str);
        if (this.bindLogger != null) {
            this.bindLogger.error(str);
        }
    }

    @Override
    public void warning(Object log) {
        String str = BcLogUtil.convertMessage(log);
        this.jLogger.warning(str);
        if (this.bindLogger != null) {
            this.bindLogger.warning(str);
        }
    }

    @Override
    public void info(Object log) {
        String str = BcLogUtil.convertMessage(log);
        this.jLogger.info(str);
        if (this.bindLogger != null) {
            this.bindLogger.info(str);
        }
    }

    @Override
    public void debug(Object log) {
        String str = BcLogUtil.convertMessage(log);
        this.jLogger.config(str);
        if (this.bindLogger != null) {
            this.bindLogger.debug(str);
        }
    }

    @Override
    public void trace(Object log) {
        String str = BcLogUtil.convertMessage(log);
        this.jLogger.fine(str);
        if (this.bindLogger != null) {
            this.bindLogger.trace(str);
        }
    }

    @Override
    public void bind(BcLogger bindLogger) {
        this.bindLogger = bindLogger;
    }

    public Logger getLogger() {
        return this.jLogger;
    }

    public void setLogger(Logger jLogger) {
        this.jLogger = jLogger;
    }

    public static Level toJLogLevel(BcLogConstants.LogLevel logLevel) {
        Level jLogJLevel = null;
        switch (logLevel) {
            case FATAL: {
                jLogJLevel = Level.SEVERE;
                break;
            }
            case ERROR: {
                jLogJLevel = Level.SEVERE;
                break;
            }
            case WARN: {
                jLogJLevel = Level.WARNING;
                break;
            }
            case INFO: {
                jLogJLevel = Level.INFO;
                break;
            }
            case DEBUG: {
                jLogJLevel = Level.CONFIG;
                break;
            }
            case TRACE: {
                jLogJLevel = Level.FINEST;
                break;
            }
            case ALL: {
                jLogJLevel = Level.ALL;
            }
        }
        return jLogJLevel;
    }

    public static BcLogConstants.LogLevel toLogLevel(Level jLogJLevel) {
        BcLogConstants.LogLevel logLevel = null;
        if (jLogJLevel == Level.SEVERE) {
            logLevel = BcLogConstants.LogLevel.FATAL;
        } else if (jLogJLevel == Level.SEVERE) {
            logLevel = BcLogConstants.LogLevel.ERROR;
        } else if (jLogJLevel == Level.WARNING) {
            logLevel = BcLogConstants.LogLevel.WARN;
        } else if (jLogJLevel == Level.INFO) {
            logLevel = BcLogConstants.LogLevel.INFO;
        } else if (jLogJLevel == Level.CONFIG) {
            logLevel = BcLogConstants.LogLevel.DEBUG;
        } else if (jLogJLevel == Level.FINEST) {
            logLevel = BcLogConstants.LogLevel.TRACE;
        } else if (jLogJLevel == Level.ALL) {
            logLevel = BcLogConstants.LogLevel.ALL;
        }
        return logLevel;
    }

    class BcLogFormatter
    extends SimpleFormatter {
        private String format;
        private int levelNameLength;
        private Map<Integer, String> levelNameMap = new HashMap<Integer, String>();

        public BcLogFormatter() {
            this.levelNameMap.put(Level.OFF.intValue(), "OFF");
            this.levelNameMap.put(Level.SEVERE.intValue(), "SEVERE");
            this.levelNameMap.put(Level.WARNING.intValue(), "WARNING");
            this.levelNameMap.put(Level.INFO.intValue(), "INFO");
            this.levelNameMap.put(Level.CONFIG.intValue(), "CONFIG");
            this.levelNameMap.put(Level.FINE.intValue(), "FINE");
            this.levelNameMap.put(Level.FINER.intValue(), "FINER");
            this.levelNameMap.put(Level.FINEST.intValue(), "FINEST");
            this.levelNameMap.put(Level.ALL.intValue(), "ALL");
            for (Map.Entry<Integer, String> mapEntry : this.levelNameMap.entrySet()) {
                this.levelNameLength = Math.max(this.levelNameLength, mapEntry.getValue().length());
            }
            this.format = "[%1$tF %1$tT.%1$tL] [%2$-" + this.levelNameLength + "s] %3$s %n";
        }

        @Override
        public synchronized String format(LogRecord lr) {
            String levelName = this.levelNameMap.get(lr.getLevel().intValue());
            return String.format(this.format, new Date(lr.getMillis()), levelName, lr.getMessage());
        }
    }
}

