/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.swg;

import ext.base.core.BcNumberUtil;
import ext.base.core.BcStringUtil;
import ext.lib.swg.SwgMenuItem;
import ext.lib.swg.SwgTextField;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.io.Serializable;
import java.math.BigDecimal;

public class SwgNumberField
extends SwgTextField
implements Serializable {
    private static final long serialVersionUID = 326109668356367276L;
    protected int integerPartDigit;
    protected int decimalDigit;
    protected int roundingMode = 4;
    protected boolean nullable;
    protected BigDecimal bigDec;
    protected String[] allowedStrings;
    final SwgMenuItem setZeroMenu = new SwgMenuItem();

    public SwgNumberField(int integerPartDigit, int decimalDigit, boolean nullable, String defaultValue) throws Exception {
        this.integerPartDigit = integerPartDigit;
        this.nullable = nullable;
        super.setHorizontalAlignment(4);
        this.setDecimalPosition(decimalDigit);
        if (defaultValue != null) {
            this.setText(defaultValue);
        }
        this.popupMenu.addSeparator();
        this.setZeroMenu.addActionListener(this.actionListener);
        this.popupMenu.add(this.setZeroMenu);
    }

    public SwgNumberField() throws Exception {
        this.integerPartDigit = -1;
        this.nullable = true;
        super.setHorizontalAlignment(4);
        this.setDecimalPosition(0);
        this.popupMenu.addSeparator();
        this.setZeroMenu.addActionListener(this.actionListener);
        this.popupMenu.add(this.setZeroMenu);
    }

    @Override
    public void actionPerformed2(ActionEvent ev) throws Exception {
        super.actionPerformed2(ev);
        if (ev.getSource() == this.setZeroMenu) {
            this.setText("0");
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void setText(String str) {
        block17: {
            block18: {
                if (BcStringUtil.isEmpty(str)) {
                    if (this.nullable) {
                        super.setText("");
                    } else {
                        str = "0";
                    }
                }
                str = BcStringUtil.trim(str);
                try {
                    this.bigDec = BcNumberUtil.parseBigDecimal(str);
                    if (this.decimalDigit > 0) {
                        this.bigDec = this.bigDec.setScale(this.decimalDigit, this.roundingMode);
                    }
                    if (this.integerPartDigit > 0) {
                        pointPos = this.bigDec.toString().indexOf(BcNumberUtil.pointStr);
                        upper = null;
                        lower = null;
                        if (pointPos >= 0) {
                            upper = this.bigDec.toString().substring(0, pointPos);
                            lower = this.bigDec.toString().substring(pointPos);
                        } else {
                            upper = this.bigDec.toString();
                            lower = "";
                        }
                        if (upper.length() > this.integerPartDigit) {
                            upper = upper.substring(upper.length() - this.integerPartDigit);
                        }
                        this.bigDec = new BigDecimal(String.valueOf(upper) + lower);
                    }
                    super.setText(BcNumberUtil.toString(this.bigDec.doubleValue(), this.decimalDigit));
                    break block17;
                }
                catch (Exception ex) {
                    isHit = false;
                    if (this.allowedStrings == null) break block18;
                    i = 0;
                    ** while (i < this.allowedStrings.length)
                }
lbl-1000:
                // 1 sources

                {
                    if (str.equals(this.allowedStrings[i])) {
                        isHit = true;
                        break;
                    }
                    ++i;
                    continue;
                }
            }
            if (isHit) {
                super.setText(str);
            } else if (this.nullable) {
                super.setText("");
                this.bigDec = null;
            } else {
                this.bigDec = new BigDecimal("0");
                if (this.decimalDigit >= 0) {
                    this.bigDec = this.bigDec.setScale(this.decimalDigit, this.roundingMode);
                }
                super.setText(this.bigDec.toString());
            }
        }
    }

    @Override
    public void focusEvent(FocusEvent ev) {
        super.focusEvent(ev);
        switch (ev.getID()) {
            case 1004: {
                break;
            }
            case 1005: {
                this.setText(this.getText());
            }
        }
    }

    @Override
    public void setPopupMenuAttribute() {
        this.setZeroMenu.setEnabled(super.isEnabled() && super.isEditable());
        super.setPopupMenuAttribute();
    }

    public int getIntegerScale() {
        return this.integerPartDigit;
    }

    public void setIntegerScale(int integerPartDigit) {
        this.integerPartDigit = integerPartDigit;
    }

    public int getDecimalPosition() {
        return this.decimalDigit;
    }

    public void setDecimalPosition(int decimalDigit) throws Exception {
        this.decimalDigit = decimalDigit;
        this.setZeroMenu.setText("\u30bc\u30ed (" + BcNumberUtil.toString(0.0, decimalDigit) + ") \u306b\u8a2d\u5b9a");
    }

    public BigDecimal getBigDecimal() {
        if (this.bigDec != null) {
            return this.bigDec;
        }
        if (this.nullable) {
            return null;
        }
        return new BigDecimal("0");
    }

    public void setValue(Number number) {
        if (number == null) {
            this.setText(null);
        } else {
            this.setText(number.toString());
        }
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public void setNullable(boolean nullable) {
        this.nullable = nullable;
        if (this.bigDec == null) {
            this.setText("0");
        }
    }

    public void setStrings(String[] allowedStrings) {
        this.allowedStrings = allowedStrings;
    }
}

