/*
 * Decompiled with CFR 0.152.
 */
package com.sun.imageio.plugins.wbmp;

import com.sun.imageio.plugins.common.I18N;
import com.sun.imageio.plugins.common.ImageUtil;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import org.w3c.dom.Node;

public class WBMPMetadata
extends IIOMetadata {
    static final String nativeMetadataFormatName = "javax_imageio_wbmp_1.0";
    public int wbmpType;
    public int width;
    public int height;

    public WBMPMetadata() {
        super(true, nativeMetadataFormatName, "com.sun.imageio.plugins.wbmp.WBMPMetadataFormat", null, null);
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public Node getAsTree(String string) {
        if (string.equals(nativeMetadataFormatName)) {
            return this.getNativeTree();
        }
        if (string.equals("javax_imageio_1.0")) {
            return this.getStandardTree();
        }
        throw new IllegalArgumentException(I18N.getString("WBMPMetadata0"));
    }

    private Node getNativeTree() {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode(nativeMetadataFormatName);
        this.addChildNode(iIOMetadataNode, "WBMPType", new Integer(this.wbmpType));
        this.addChildNode(iIOMetadataNode, "Width", new Integer(this.width));
        this.addChildNode(iIOMetadataNode, "Height", new Integer(this.height));
        return iIOMetadataNode;
    }

    @Override
    public void setFromTree(String string, Node node) {
        throw new IllegalStateException(I18N.getString("WBMPMetadata1"));
    }

    @Override
    public void mergeTree(String string, Node node) {
        throw new IllegalStateException(I18N.getString("WBMPMetadata1"));
    }

    @Override
    public void reset() {
        throw new IllegalStateException(I18N.getString("WBMPMetadata1"));
    }

    private IIOMetadataNode addChildNode(IIOMetadataNode iIOMetadataNode, String string, Object object) {
        IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode(string);
        if (object != null) {
            iIOMetadataNode2.setUserObject(object);
            iIOMetadataNode2.setNodeValue(ImageUtil.convertObjectToString(object));
        }
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        return iIOMetadataNode2;
    }

    @Override
    protected IIOMetadataNode getStandardChromaNode() {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Chroma");
        IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("BlackIsZero");
        iIOMetadataNode2.setAttribute("value", "TRUE");
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        return iIOMetadataNode;
    }

    @Override
    protected IIOMetadataNode getStandardDimensionNode() {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Dimension");
        IIOMetadataNode iIOMetadataNode2 = null;
        iIOMetadataNode2 = new IIOMetadataNode("ImageOrientation");
        iIOMetadataNode2.setAttribute("value", "Normal");
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        return iIOMetadataNode;
    }
}

