/*
 * Decompiled with CFR 0.152.
 */
package org.tukaani.xz.check;

import org.tukaani.xz.check.Check;

public class CRC64
extends Check {
    private static final long poly = -3932672073523589310L;
    private static final long[] crcTable = new long[256];
    private long crc = -1L;

    static {
        int b = 0;
        while (b < crcTable.length) {
            long r = b;
            int i = 0;
            while (i < 8) {
                r = (r & 1L) == 1L ? r >>> 1 ^ 0xC96C5795D7870F42L : (r >>>= 1);
                ++i;
            }
            CRC64.crcTable[b] = r;
            ++b;
        }
    }

    public CRC64() {
        this.size = 8;
        this.name = "CRC64";
    }

    @Override
    public void update(byte[] buf, int off, int len) {
        int end = off + len;
        while (off < end) {
            this.crc = crcTable[(buf[off++] ^ (int)this.crc) & 0xFF] ^ this.crc >>> 8;
        }
    }

    @Override
    public byte[] finish() {
        long value = this.crc ^ 0xFFFFFFFFFFFFFFFFL;
        this.crc = -1L;
        byte[] buf = new byte[8];
        int i = 0;
        while (i < buf.length) {
            buf[i] = (byte)(value >> i * 8);
            ++i;
        }
        return buf;
    }
}

