/*
 * Decompiled with CFR 0.152.
 */
package ext.rydeen.script;

import ext.appfw.common.AfbApplication;
import ext.base.core.BcConstants;
import ext.base.core.BcLangUtil;
import ext.base.core.BcStringUtil;
import ext.base.event.BcEventHandler;
import ext.base.io.BcFileUtil;
import ext.base.log.BcLoggableObject;
import ext.base.log.BcLogger;
import ext.base.mmd.MmdIndex;
import ext.base.mmd.MmdModel;
import ext.base.util.BcReaderThread_0;
import ext.base.util.BcResult;
import ext.lib.datasource.DtsSession;
import ext.lib.datasource.DtsSessionFactory;
import ext.lib.datasource.DtsSessionFactoryManegaer;
import ext.lib.fx.FxPlatform;
import ext.lib.script.SrpUtil;
import ext.lib.sql.SqlConnection;
import ext.lib.sql.SqlDefinitionCondition;
import ext.lib.sql.SqlResultSet;
import ext.lib.sql.SqlStatement;
import ext.lib.sql.SqlUtil;
import ext.lib.sql.context.SqlContext;
import ext.lib.task.TskAbstractCallable;
import ext.lib.task.TskCallableUnit;
import ext.lib.task.TskTaskEvent;
import ext.lib.task.TskTaskManager;
import ext.module.xdts.common.XdtsConstants;
import ext.module.xdts.dao.XdtsProfileDAO;
import ext.module.xdts.model.XdtsProcessCondition;
import ext.module.xdts.model.XdtsProfile;
import ext.module.xdts.server.XdtsServerUtil;
import ext.module.xdts.server.XdtsSessionFactoryManager;
import ext.rydeen.script.ScriptTask;
import ext.rydeen.script.XdtsTempCondition;
import ext.scf4.fx.TmpMonitorPane;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;

public class ScriptHelper
extends BcLoggableObject {
    private List<SqlConnection> sqlConnectionList = new ArrayList<SqlConnection>();

    private ScriptHelper() {
    }

    public static ScriptHelper getInstance() {
        return SingletonHolder.instance;
    }

    public SqlConnection getConnection(String dataSourceName) throws Exception {
        this.getLogger().info("getConnection:dataSourceName=" + dataSourceName);
        DtsSessionFactory dtsSessionFactoryMain = DtsSessionFactoryManegaer.getInstance().getSessionFactory("main");
        Throwable throwable = null;
        Object var4_6 = null;
        try (DtsSession dtsSessionMain = dtsSessionFactoryMain.createSession(this);){
            XdtsProfile profile = (XdtsProfile)XdtsProfileDAO.getInstance().getByName(dtsSessionMain, dataSourceName);
            this.getLogger().info("profile=" + profile);
            DtsSessionFactory dtsSessionFactoryWk1 = XdtsSessionFactoryManager.getInstance().createSessionFactory(profile);
            DtsSession dtsSessionWk = dtsSessionFactoryWk1.createSession(this);
            SqlConnection sqlConn = dtsSessionWk.getConnection();
            this.getLogger().info("sqlConn=" + sqlConn);
            this.sqlConnectionList.add(sqlConn);
            return sqlConn;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void closeConnections() throws Exception {
        int i = 0;
        while (i < this.sqlConnectionList.size()) {
            SqlConnection sqlConn = this.sqlConnectionList.get(1);
            if (!sqlConn.isClosed()) {
                sqlConn.close();
                this.getLogger().info("Connection closed.hashCode=" + sqlConn.hashCode());
            }
            ++i;
        }
    }

    public SqlResultSet executeSelect(SqlConnection conn, String query) throws Exception {
        SqlStatement stmt = conn.createStatement();
        return stmt.executeQuery(query);
    }

    public int executeUpdate(SqlConnection conn, String query) throws Exception {
        int cnt = 0;
        try {
            cnt = SqlUtil.executeUpdate(conn, query);
            this.getLogger().info("cnt=" + cnt);
        }
        catch (Exception ex) {
            this.getLogger().error(ex);
        }
        return cnt;
    }

    public boolean existTable(SqlConnection conn, String tableName) throws Exception {
        SqlContext sqlContext = conn.getSqlContext();
        return sqlContext.existTable(conn, tableName);
    }

    public int dropTable(SqlConnection conn, String tableName) throws Exception {
        SqlContext sqlContext = conn.getSqlContext();
        return sqlContext.dropTable(conn, tableName);
    }

    public int truncateTable(SqlConnection conn, String tableName) throws Exception {
        SqlContext sqlContext = conn.getSqlContext();
        return sqlContext.truncateTable(conn, tableName);
    }

    public MmdModel createModel(SqlConnection conn, String tableName) throws Exception {
        SqlContext sqlContext = conn.getSqlContext();
        MmdModel mmdModel = sqlContext.createModelMetaData(conn, tableName);
        return mmdModel;
    }

    public MmdModel createModel(SqlResultSet rs, String tableName) throws Exception {
        return XdtsServerUtil.getInstance().createMmdModelForSelect(rs.getMetaData(), tableName);
    }

    public MmdModel convertModel(SqlContext srcSqlContext, MmdModel srcTableModel, SqlContext dstSqlContext) throws Exception {
        SqlDefinitionCondition definitionCondition = SqlDefinitionCondition.createDefault();
        return XdtsServerUtil.getInstance().createTablePre(srcSqlContext, srcTableModel, dstSqlContext, definitionCondition);
    }

    public String createCreateTableQuery(SqlContext sqlContext, MmdModel mmdModel, boolean includePrimaryKey) throws Exception {
        SqlDefinitionCondition definitionCondition = SqlDefinitionCondition.createDefault();
        return sqlContext.createCreateTableQuery(mmdModel, includePrimaryKey, definitionCondition);
    }

    public String createCreateIndexQuery(SqlContext sqlContext, MmdModel mmdModel, MmdIndex mmdIndex) throws Exception {
        return sqlContext.createCreateIndexQuery(mmdModel, mmdIndex);
    }

    public int copyResultSet(SqlResultSet rs, SqlConnection dstConn, MmdModel mmdModel) throws Exception {
        XdtsProcessCondition processCondition = new XdtsProcessCondition();
        OutputStreamWriter errorWriter = this.createErrorWriter(processCondition);
        boolean ignoreException = false;
        return XdtsServerUtil.getInstance().copyRecords_L5(rs, dstConn, mmdModel, ignoreException, errorWriter, this.getLogger());
    }

    public int copyResultSet(SqlResultSet rs, String tableName, SqlConnection dstConn, XdtsTempCondition condition) throws Exception {
        SqlConnection srcConn = rs.getStatement().getConnection();
        SqlContext srcSqlContext = srcConn.getSqlContext();
        SqlContext dstSqlContext = dstConn.getSqlContext();
        MmdModel srcModel = this.createModel(srcConn, tableName);
        MmdModel dstModel = this.convertModel(srcSqlContext, srcModel, dstSqlContext);
        boolean existTable = XdtsServerUtil.getInstance().dropTable(dstConn, tableName, true, true, true);
        if (!existTable) {
            String createTableQuery = this.createCreateTableQuery(dstSqlContext, dstModel, false);
            this.getLogger().info("createTableQuery=" + createTableQuery);
            this.executeUpdate(dstConn, createTableQuery);
        }
        int count = this.copyResultSet(rs, dstConn, dstModel);
        return count;
    }

    public void copyTable_xxx(SqlResultSet rs, String tableName, SqlConnection dstConn, XdtsTempCondition condition) throws Exception {
        BcResult result = new BcResult();
        this.getLogger().info("tableName=" + tableName);
        SqlContext sqlContext2 = dstConn.getSqlContext();
        XdtsProcessCondition processCondition = new XdtsProcessCondition();
        processCondition.commitMode = XdtsConstants.CommitMode.FINAL;
        processCondition.recreateTable = true;
        processCondition.truncateTable = true;
        processCondition.copyRecords = true;
        processCondition.newTableName = tableName;
        if (!BcStringUtil.isEmpty(condition.commitMode)) {
            processCondition.commitMode = BcLangUtil.getEnumByNameIgnoreCase(XdtsConstants.CommitMode.class, condition.commitMode);
            if (processCondition.commitMode == null) {
                result.addError("\u30b3\u30df\u30c3\u30c8\u30e2\u30fc\u30c9\u304c\u6b63\u3057\u304f\u3042\u308a\u307e\u305b\u3093\u3002");
            }
        }
        if (sqlContext2.existTable(dstConn, tableName)) {
            sqlContext2.dropTable(dstConn, tableName);
        }
        OutputStreamWriter errorWriter = this.createErrorWriter(processCondition);
        SqlContext sqlContext1 = rs.getStatement().getSqlContext();
        MmdModel mmdModel1 = sqlContext1.createModelMetaData(rs.getStatement().getConnection(), tableName);
        XdtsServerUtil.getInstance().copyRecords_L4(rs, processCondition, dstConn, mmdModel1, errorWriter, this.getLogger());
    }

    public void selectCopy_xxx(SqlResultSet rs, SqlConnection dstConn, String dstTableName, XdtsTempCondition condition) throws Exception {
        SqlContext sqlContext1 = rs.getStatement().getSqlContext();
        SqlContext sqlContext2 = dstConn.getSqlContext();
        XdtsProcessCondition processCondition = new XdtsProcessCondition();
        processCondition.commitMode = XdtsConstants.CommitMode.FINAL;
        processCondition.recreateTable = true;
        processCondition.truncateTable = true;
        processCondition.copyRecords = true;
        OutputStreamWriter errorWriter = this.createErrorWriter(processCondition);
        MmdModel mmdModel1 = XdtsServerUtil.getInstance().createMmdModelForSelect(rs.getMetaData(), dstTableName);
        MmdModel mmdModel2 = XdtsServerUtil.getInstance().createTablePre(sqlContext1, mmdModel1, sqlContext2, processCondition.definitionCondition);
        boolean existTable = XdtsServerUtil.getInstance().dropTable(dstConn, dstTableName, true, true, true);
        if (!existTable) {
            String createTableQuery = this.createCreateTableQuery(sqlContext2, mmdModel2, false);
            this.getLogger().info("createTableQuery=" + createTableQuery);
            this.executeUpdate(dstConn, createTableQuery);
        }
        XdtsServerUtil.getInstance().createTable(processCondition, mmdModel2, dstConn, errorWriter);
        boolean ignoreException = false;
        XdtsServerUtil.getInstance().copyRecords_L5(rs, dstConn, mmdModel2, ignoreException, errorWriter, this.getLogger());
    }

    public OutputStreamWriter createErrorWriter(XdtsProcessCondition processCondition) throws Exception {
        File errorFile = null;
        errorFile = BcStringUtil.isEmpty(processCondition.errorFilePath) ? new File(AfbApplication.getInstance().getLogDir(), "error.log") : new File(processCondition.errorFilePath);
        this.getLogger().info("errorFile=" + errorFile.getPath());
        BcFileUtil.makeParent(errorFile);
        OutputStreamWriter errorWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(errorFile, false), BcConstants.charset.name());
        return errorWriter;
    }

    public List<String> getTableNameList(SqlConnection conn, String namePattern) throws Exception {
        SqlContext sqlContext = conn.getSqlContext();
        List<String> tableNameList = sqlContext.getTableNameList(conn, namePattern);
        return tableNameList;
    }

    public List<String> getViewNameList(SqlConnection conn, String namePattern) throws Exception {
        SqlContext sqlContext = conn.getSqlContext();
        List<String> tableNameList = sqlContext.getViewNameList(conn, namePattern);
        return tableNameList;
    }

    public void executeScript(ScriptEngine scriptEngine, String script, Writer writer, Writer errorWriter, BcLogger logger) throws Exception {
        Invocable invocable = (Invocable)((Object)scriptEngine);
        try {
            try {
                if (writer != null) {
                    scriptEngine.getContext().setWriter(writer);
                }
                if (errorWriter != null) {
                    scriptEngine.getContext().setErrorWriter(errorWriter);
                }
                scriptEngine.eval(script);
            }
            catch (Exception ex) {
                logger.error(ex);
                try {
                    this.closeConnections();
                }
                catch (Exception ex2) {
                    logger.error(ex2);
                }
            }
        }
        finally {
            try {
                this.closeConnections();
            }
            catch (Exception ex) {
                logger.error(ex);
            }
        }
    }

    public void executeScript(ScriptTask scriptTask) throws Exception {
        scriptTask.setLogger(this.getLogger());
        scriptTask.rydeen = this;
        TskCallableUnit callableUnit = new TskCallableUnit((TskAbstractCallable)scriptTask, Executors.newCachedThreadPool());
        TskTaskManager.getInstance().addCallableUnit(callableUnit);
    }

    public void executeScript(String script, BcEventHandler<TskTaskEvent> eventHandler, Writer writer, Writer errorWriter, BcLogger logger) throws Exception {
        ScriptEngineManager scriptEngineManager = new ScriptEngineManager();
        ScriptTask scriptTask = new ScriptTask();
        scriptTask.scriptEngine = scriptEngineManager.getEngineByName("javascript");
        scriptTask.script = script;
        scriptTask.addEventHandler(eventHandler);
        scriptTask.writer = writer;
        scriptTask.errorWriter = errorWriter;
        this.executeScript(scriptTask);
    }

    public void executeScript(File scriptFile, final BcLogger logger) throws Exception {
        final ScriptTask scriptTask = new ScriptTask();
        scriptTask.setName(scriptFile.getPath());
        logger.info("scriptFile=" + scriptFile.getPath());
        String fileExtention = BcFileUtil.getExtention(scriptFile);
        logger.info("fileExtention=" + fileExtention);
        ScriptEngineFactory scriptEngineFactory = SrpUtil.getEngineFactoryByFileExtension(fileExtention);
        logger.info("scriptEngineFactory=" + scriptEngineFactory.getEngineName());
        if (scriptEngineFactory == null) {
            String msg = String.format("Not suported file extention '%s'", fileExtention);
            throw new Exception(msg);
        }
        ScriptEngineManager scriptEngineManager = new ScriptEngineManager();
        logger.info("scriptEngineFactory.getNames()=" + scriptEngineFactory.getNames());
        String engineName = scriptEngineFactory.getNames().get(0);
        logger.info("engineName=" + engineName);
        scriptTask.scriptEngine = scriptEngineManager.getEngineByName(engineName);
        if (scriptTask.scriptEngine == null) {
            String msg = String.format("ScriptEngine is null.", new Object[0]);
            throw new Exception(msg);
        }
        scriptTask.script = BcFileUtil.readAsString(scriptFile, BcConstants.charset);
        logger.info("script=" + scriptTask.script);
        FxPlatform.runLater(new Runnable(){

            @Override
            public void run() {
                try {
                    TmpMonitorPane monitorPane = new TmpMonitorPane();
                    monitorPane.setTitle(scriptTask.getName());
                    scriptTask.addEventHandler(monitorPane);
                    ScriptHelper.this.executeScript(scriptTask);
                }
                catch (Exception ex) {
                    logger.error(ex);
                }
            }
        });
    }

    /* synthetic */ ScriptHelper(ScriptHelper scriptHelper) {
        this();
    }

    class InnerReaderThread
    extends BcReaderThread_0 {
        public InnerReaderThread(BufferedReader br) {
            super(br);
        }

        @Override
        protected void output(String line) {
            ScriptHelper.this.getLogger().info(line);
        }
    }

    private static final class SingletonHolder {
        private static final ScriptHelper instance = new ScriptHelper(null);

        private SingletonHolder() {
        }
    }
}

