/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xdts.fx;

import ext.lib.fx.layout.FxNodeUnit;
import ext.lib.fx.util.FxUtil;
import ext.module.xdts.fx.XdtsAbstractConditionPane;
import ext.module.xdts.fx.XdtsQueryEditPane2;
import ext.module.xdts.fx.XdtsTransferPane;
import ext.module.xdts.model.XdtsProcessCondition;
import javafx.scene.Node;
import javafx.stage.Stage;

class XdtsUpdateQueryConditionPane
extends XdtsAbstractConditionPane {
    XdtsQueryEditPane2 sqlEditPane;
    XdtsTransferPane.Mode mode;

    public XdtsUpdateQueryConditionPane(Stage stage, XdtsTransferPane.Mode mode) throws Exception {
        super(stage);
        this.mode = mode;
        this.initComponent();
    }

    protected void initComponent() throws Exception {
        switch (this.mode) {
            case dropTable: 
            case truncateTable: 
            case dropView: {
                break;
            }
            default: {
                this.sqlEditPane = new XdtsQueryEditPane2(this.stage);
                this.sqlEditPane.setPrefSize(560.0, 240.0);
                FxNodeUnit nodeUnit = new FxNodeUnit((Node)this.sqlEditPane, new Node[0]);
                nodeUnit.leftNodeHandling = 1;
                this.centerPane.addNodeUnit(nodeUnit);
                this.setExecuteSql();
            }
        }
        this.setCommitMode();
        this.setDestFile();
        this.setErrorFile();
        FxUtil.defaultInitialize((Node)this);
    }

    @Override
    public void storeCondition(XdtsProcessCondition processCondition) throws Exception {
        super.storeCondition(processCondition);
        switch (this.mode) {
            case dropTable: {
                processCondition.query = "DROP TABLE ${tableName}";
                break;
            }
            case truncateTable: {
                processCondition.query = "TRUNCATE ${tableName}";
                break;
            }
            case dropView: {
                processCondition.query = "DROP VIEW ${viewName}";
                break;
            }
            default: {
                processCondition.query = this.sqlEditPane.textArea.getText();
            }
        }
    }
}

