/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.swg;

import ext.lib.awt.AwtImageHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class SwgTabbedPane
extends JTabbedPane {
    private static final long serialVersionUID = 2853643249591819890L;
    protected ImageIcon closeIcon;
    protected boolean delayedEvaluationEnabled;

    public SwgTabbedPane() {
    }

    public SwgTabbedPane(int tabPlacement) {
        super(tabPlacement);
    }

    public SwgTabbedPane(int tabPlacement, int tabLayoutPolicy) {
        super(tabPlacement, tabLayoutPolicy);
    }

    @Override
    public void addTab(String title, final Component component) {
        if (this.closeIcon == null) {
            super.addTab(title, component);
            return;
        }
        JPanel tab = new JPanel(new BorderLayout());
        tab.setOpaque(false);
        JLabel label = new JLabel(title);
        label.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 4));
        Dimension buttonSize = new Dimension(this.closeIcon.getIconWidth(), this.closeIcon.getIconHeight());
        JButton button = new JButton(this.closeIcon);
        button.setPreferredSize(buttonSize);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                SwgTabbedPane.this.removeTabAt(SwgTabbedPane.this.indexOfComponent(component));
            }
        });
        tab.add((Component)label, "West");
        tab.add((Component)button, "East");
        tab.setBorder(BorderFactory.createEmptyBorder(2, 1, 1, 1));
        super.addTab(null, component);
        this.setTabComponentAt(this.getTabCount() - 1, tab);
    }

    public void closeIconEnabled(boolean closeIconEnabled) throws Exception {
        if (closeIconEnabled) {
            ImageIcon imageIcon;
            Image image = AwtImageHelper.getImage_icon("cancel_64x64.png");
            this.closeIcon = imageIcon = new ImageIcon(image);
        } else {
            this.closeIcon = null;
        }
    }

    public boolean delayedEvaluationEnabled() {
        return this.delayedEvaluationEnabled;
    }

    public void setDelayedEvaluationEnabled(boolean delayedEvaluationEnabled) {
        this.delayedEvaluationEnabled = delayedEvaluationEnabled;
    }
}

