/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrockit.jfr;

import java.io.IOException;
import jdk.internal.instrumentation.InstrumentationMethod;
import jdk.internal.instrumentation.InstrumentationTarget;
import jdk.internal.instrumentation.TypeMapping;
import jdk.internal.instrumentation.TypeMappings;
import jdk.jfr.events.SocketWriteEvent;
import oracle.jrockit.jfr.VMJFR;

@InstrumentationTarget(value="java.net.SocketOutputStream")
@TypeMappings(value={@TypeMapping(from="oracle.jrockit.jfr.SocketOutputStreamInstrumentor$AbstractPlainSocketImpl", to="java.net.AbstractPlainSocketImpl"), @TypeMapping(from="oracle.jrockit.jfr.SocketOutputStreamInstrumentor$InetAddress", to="java.net.InetAddress"), @TypeMapping(from="oracle.jrockit.jfr.SocketOutputStreamInstrumentor$InetAddressHolder", to="java.net.InetAddress$InetAddressHolder")})
final class SocketOutputStreamInstrumentor {
    private AbstractPlainSocketImpl impl = null;

    private SocketOutputStreamInstrumentor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InstrumentationMethod
    private void socketWrite(byte[] byArray, int n, int n2) throws IOException {
        if (!VMJFR.socketWriteToken.isEnabled()) {
            this.socketWrite(byArray, n, n2);
            return;
        }
        SocketWriteEvent socketWriteEvent = new SocketWriteEvent(VMJFR.socketWriteToken);
        int n3 = -1;
        try {
            socketWriteEvent.begin();
            this.socketWrite(byArray, n, n2);
            n3 = n2;
        }
        finally {
            socketWriteEvent.end();
            if (socketWriteEvent.shouldWrite()) {
                socketWriteEvent.host = this.impl.address.holder().getHostName();
                socketWriteEvent.address = this.impl.address.getHostAddress();
                socketWriteEvent.port = this.impl.port;
                socketWriteEvent.bytesWritten = n3;
                socketWriteEvent.commit();
            }
        }
    }

    static class AbstractPlainSocketImpl {
        InetAddress address;
        int port;

        AbstractPlainSocketImpl() {
        }
    }

    class InetAddress {
        InetAddress() {
        }

        public String getHostAddress() {
            return null;
        }

        InetAddressHolder holder() {
            return null;
        }
    }

    class InetAddressHolder {
        InetAddressHolder() {
        }

        String getHostName() {
            return null;
        }
    }
}

