/*
 * Decompiled with CFR 0.152.
 */
package sun.misc;

import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.List;
import jdk.internal.util.EnvUtils;
import sun.usagetracker.UsageTrackerClient;

public class PostVMInitHook {
    private static final String ORCL_UT_CONFIG_FILE_NAME = "usagetracker.properties";

    public static void run() {
        PostVMInitHook.checkJarVerifierClassVersion();
        PostVMInitHook.trackJavaUsage();
    }

    private static void checkJarVerifierClassVersion() {
        try {
            Class<?> clazz = Class.forName("javax.crypto.JarVerifier", false, null);
            Method method = clazz.getDeclaredMethod("verifyJars", URL.class, List.class);
        }
        catch (Throwable throwable) {
            System.err.println("warning: JDK development build detected. No jar verification of crypto jars enforced.");
        }
    }

    private static void trackJavaUsage() {
        String string = System.getProperty("os.name");
        if (PostVMInitHook.getConfigFilePrivileged() != null || string.toLowerCase().startsWith("win") || string.contains("OS X")) {
            UsageTrackerClient usageTrackerClient = new UsageTrackerClient();
            usageTrackerClient.run("VM start", System.getProperty("sun.java.command"));
        }
    }

    private static File getConfigFilePrivileged() {
        File file = null;
        String[] stringArray = new String[]{System.getProperty("com.oracle.usagetracker.config.file"), PostVMInitHook.getOSSpecificConfigFilePath(), System.getProperty("java.home") + File.separator + "conf" + File.separator + "management" + File.separator + ORCL_UT_CONFIG_FILE_NAME};
        for (final String string : stringArray) {
            if (string != null && (file = AccessController.doPrivileged(new PrivilegedAction<File>(){

                @Override
                public File run() {
                    File file = new File(string);
                    return file.exists() ? file : null;
                }
            })) != null) break;
        }
        return file;
    }

    private static String getOSSpecificConfigFilePath() {
        String string = System.getProperty("os.name");
        if (string != null) {
            if ((string = string.toLowerCase()).startsWith("sunos")) {
                return "/etc/oracle/java/usagetracker.properties";
            }
            if (string.startsWith("mac")) {
                return "/Library/Application Support/Oracle/Java/usagetracker.properties";
            }
            if (string.startsWith("win")) {
                String string2 = PostVMInitHook.getEnvPrivileged("ProgramData");
                return string2 == null ? null : string2 + "\\Oracle\\Java\\" + ORCL_UT_CONFIG_FILE_NAME;
            }
            if (string.startsWith("linux")) {
                return "/etc/oracle/java/usagetracker.properties";
            }
        }
        return null;
    }

    private static String getEnvPrivileged(final String string) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return EnvUtils.getEnvVar(string);
            }
        });
    }
}

