/*
 * Decompiled with CFR 0.152.
 */
package sun.security.pkcs11.wrapper;

import java.security.ProviderException;
import sun.security.pkcs11.wrapper.Constants;
import sun.security.pkcs11.wrapper.Functions;

public class CK_RSA_PKCS_PSS_PARAMS {
    private final long hashAlg;
    private final long mgf;
    private final long sLen;

    public CK_RSA_PKCS_PSS_PARAMS(String string, String string2, String string3, int n) {
        this.hashAlg = Functions.getHashMechId(string);
        if (!string2.equals("MGF1")) {
            throw new ProviderException("Only MGF1 is supported");
        }
        this.mgf = Functions.getMGFId("CKG_MGF1_" + string3.replaceFirst("-", ""));
        this.sLen = n;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof CK_RSA_PKCS_PSS_PARAMS)) {
            return false;
        }
        CK_RSA_PKCS_PSS_PARAMS cK_RSA_PKCS_PSS_PARAMS = (CK_RSA_PKCS_PSS_PARAMS)object;
        return cK_RSA_PKCS_PSS_PARAMS.hashAlg == this.hashAlg && cK_RSA_PKCS_PSS_PARAMS.mgf == this.mgf && cK_RSA_PKCS_PSS_PARAMS.sLen == this.sLen;
    }

    public int hashCode() {
        return (int)(this.hashAlg << (int)(2L + this.mgf) << (int)(1L + this.sLen));
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("  ");
        stringBuilder.append("hashAlg: ");
        stringBuilder.append(Functions.toFullHexString(this.hashAlg));
        stringBuilder.append(Constants.NEWLINE);
        stringBuilder.append("  ");
        stringBuilder.append("mgf: ");
        stringBuilder.append(Functions.toFullHexString(this.mgf));
        stringBuilder.append(Constants.NEWLINE);
        stringBuilder.append("  ");
        stringBuilder.append("sLen(in bytes): ");
        stringBuilder.append(this.sLen);
        return stringBuilder.toString();
    }
}

