/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xfil.fx;

import ext.base.core.BcStringUtil;
import ext.base.log.BcLogUtil;
import ext.base.util.BcCollectionUtil;
import ext.lib.fx.control.FxButton;
import ext.lib.fx.control.FxLabel;
import ext.lib.fx.control.FxTextArea;
import ext.lib.fx.control.FxTextField;
import ext.lib.fx.layout.FxDecoratePane;
import ext.lib.fx.layout.FxFlowPane;
import ext.lib.fx.layout.FxNodeUnit;
import ext.lib.fx.layout.FxTitledPane;
import ext.lib.fx.scene.FxScene;
import ext.lib.fx.stage.FxStage;
import ext.lib.fx.util.FxDragAndDropHelper;
import ext.lib.fx.util.FxImageHelper;
import ext.lib.fx.util.FxUtil;
import ext.module.xfil.common.XfilCaptureParam;
import ext.module.xfil.common.XfilCaptureUtil;
import ext.module.xfil.common.XfilUtil;
import ext.module.xfil.common.XfilWords;
import ext.module.xfil.fx.XfilCaptureConditionPane;
import ext.module.xfil.model.XfilUriEntity;
import ext.module.xfil.model.XfilVCaptureCondition;
import ext.module.xfil.stub.XfilVideoCaptureStub;
import ext.scf4.fx.HfxTaskMonitor;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;

public class Y_XfilThumbnailCreatePane
extends FxDecoratePane {
    XfilCaptureConditionPane captureConditionPane = new XfilCaptureConditionPane();
    FxFlowPane centerPane = new FxFlowPane(11);
    FxTextField outputFileNameField = new FxTextField();
    FxTextArea filePathTextArea = new FxTextArea();
    FxButton fileBrowsButton = new FxButton("", (Node)FxImageHelper.createImageView_icon("find_64x64.png"));
    FileChooser fileChooser = new FileChooser();
    FxButton completionButton = FxUtil.createCompletionButton();
    FxButton cancelButton = FxUtil.createCancelButton();
    Stage stage;

    public Y_XfilThumbnailCreatePane() throws Exception {
        FxTitledPane titledPane1 = new FxTitledPane();
        titledPane1.setContentNode((Node)this.captureConditionPane);
        titledPane1.setTitle(XfilWords.getInstance().ScreenCapture.toPlain());
        titledPane1.setIconNode((Node)FxImageHelper.createImageView_icon("screenshot_64x64.png"));
        titledPane1.setPrefHeight(280.0);
        this.setTop((Node)titledPane1);
        this.outputFileNameField.setPrefColumnCount(120);
        this.outputFileNameField.setText("%fileNameBase%_%time");
        FxNodeUnit nodeUnit = new FxNodeUnit((Node)new FxLabel("\u30b5\u30e0\u30cd\u30a4\u30eb\u30d5\u30a1\u30a4\u30eb\u540d"), new Node[]{this.outputFileNameField});
        this.centerPane.addNodeUnit(nodeUnit);
        this.filePathTextArea.setPrefColumnCount(120);
        this.filePathTextArea.setText("X:\\parallels_share\\zodiac\\movie\\TRG-074 Tora Tora Gold 074 \u5e73\u702c\u308a\u3087\u3046=\u540d\u57ce\u7fe0.avi");
        nodeUnit = new FxNodeUnit((Node)new FxLabel(XfilWords.getInstance().CrawlName.toPlain()), new Node[]{this.filePathTextArea});
        this.fileBrowsButton.setOnAction(this.actionEventHandler);
        nodeUnit.addRightNodes(new Node[]{this.fileBrowsButton});
        this.centerPane.addNodeUnit(nodeUnit);
        this.setCenter((Node)this.centerPane);
        this.completionButton.setOnAction(this.actionEventHandler);
        this.getControlPane().addControl((Node)this.completionButton);
        this.cancelButton.setOnAction(this.actionEventHandler);
        this.getControlPane().addControl((Node)this.cancelButton);
        InnerDragAndDropHelper dragAndDropHelper = new InnerDragAndDropHelper();
        dragAndDropHelper.setup((Node)this.filePathTextArea);
        this.setPadding(new Insets(8.0));
        FxUtil.defaultInitialize((Node)this);
    }

    @Override
    protected void actionPerformed(ActionEvent ev) throws Exception {
        super.actionPerformed(ev);
        if (ev.getSource() == this.fileBrowsButton) {
            FxUtil.initFileChooser(this.fileChooser, this.filePathTextArea.getText());
            List fileList = this.fileChooser.showOpenMultipleDialog(this.getScene().getWindow());
            if (!BcCollectionUtil.isEmpty(fileList)) {
                this.filePathTextArea.setText(this.toFilesStr(fileList));
            }
        } else if (ev.getSource() == this.completionButton) {
            List<String> lineList = BcStringUtil.lineSeparete(this.filePathTextArea.getText());
            ArrayList<File> fileList = new ArrayList<File>();
            int i = 0;
            while (i < lineList.size()) {
                String line = lineList.get(i);
                BcLogUtil.debug("line=" + line);
                ArrayList<String> filePathList = new ArrayList<String>();
                filePathList.add(line);
                int j = 0;
                while (j < filePathList.size()) {
                    String filePath = (String)filePathList.get(j);
                    File file = new File(filePath);
                    fileList.add(file);
                    ++j;
                }
                ++i;
            }
            this.temp(fileList);
        } else if (ev.getSource() == this.cancelButton) {
            this.close();
        }
    }

    protected void temp(List<File> fileList) throws Exception {
        List<XfilUriEntity> uriEntityList = XfilUtil.createUriEntityList(fileList);
        XfilVCaptureCondition captureCondition = this.captureConditionPane.captureConditionSet.getCondition();
        BcLogUtil.debug("captureCondition.intervalSec=" + captureCondition.intervalSec);
        XfilCaptureParam videoCaptureParam = XfilCaptureUtil.convert(captureCondition);
        videoCaptureParam.outputFileName = this.outputFileNameField.getText();
        HfxTaskMonitor.getInstance().show();
        XfilVideoCaptureStub.getInstance().capture(videoCaptureParam, uriEntityList);
    }

    public void close() {
        this.stage.close();
    }

    public void show(File file) throws Exception {
        this.stage = new FxStage();
        this.stage.setOnShown((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent ev) {
            }
        });
        FxScene scene = new FxScene((Parent)this);
        this.stage.setScene((Scene)scene);
        this.stage.setWidth(1200.0);
        this.stage.setHeight(800.0);
        this.stage.setResizable(false);
        this.stage.setTitle(XfilWords.getInstance().Crawl.toPlain());
        FxImageHelper.setStageIcon(this.stage);
        this.stage.show();
    }

    public String toFilesStr(List<File> fileList) throws Exception {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < fileList.size()) {
            File file = fileList.get(i);
            BcLogUtil.debug("file=" + file.getPath());
            if (i > 0) {
                sb.append("\n");
            }
            sb.append(file.getPath());
            ++i;
        }
        return sb.toString();
    }

    class InnerDragAndDropHelper
    extends FxDragAndDropHelper {
        InnerDragAndDropHelper() {
        }

        @Override
        protected void cathFileList(List<File> fileList) {
            try {
                Y_XfilThumbnailCreatePane.this.filePathTextArea.setText(Y_XfilThumbnailCreatePane.this.toFilesStr(fileList));
            }
            catch (Exception ex) {
                BcLogUtil.error(ex);
            }
        }
    }
}

