/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import oracle.jdbc.OracleType;
import oracle.jdbc.VectorMetaData;

final class VectorMetaDataImpl
implements VectorMetaData {
    private final int length;
    private final OracleType type;
    private final Class<?> arrayClass;

    private VectorMetaDataImpl(int length, OracleType type, Class<?> arrayClass) {
        this.length = length;
        this.type = type;
        this.arrayClass = arrayClass;
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public OracleType type() {
        return this.type;
    }

    @Override
    public Class<?> arrayClass() {
        return this.arrayClass;
    }

    static VectorMetaDataImpl create(int length, int typeCode) {
        switch (typeCode) {
            case -105: {
                return new VectorMetaDataImpl(length, OracleType.VECTOR, double[].class);
            }
            case -108: {
                return new VectorMetaDataImpl(length, OracleType.VECTOR_FLOAT64, double[].class);
            }
            case -107: {
                return new VectorMetaDataImpl(length, OracleType.VECTOR_FLOAT32, float[].class);
            }
            case -106: {
                return new VectorMetaDataImpl(length, OracleType.VECTOR_INT8, byte[].class);
            }
            case -109: {
                return new VectorMetaDataImpl(length, OracleType.VECTOR_BINARY, byte[].class);
            }
        }
        throw new IllegalStateException("Not a VECTOR: " + typeCode);
    }
}

