/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.CounterMode;
import com.sun.crypto.provider.GaloisCounterMode;
import com.sun.crypto.provider.SymmetricCipher;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javax.crypto.IllegalBlockSizeException;

final class GCTR
extends CounterMode {
    GCTR(SymmetricCipher symmetricCipher, byte[] byArray) {
        super(symmetricCipher);
        if (byArray.length != 16) {
            throw new RuntimeException("length of initial counter block (" + byArray.length + ") not equal to AES_BLOCK_SIZE (" + 16 + ")");
        }
        this.iv = byArray;
        this.reset();
    }

    @Override
    String getFeedback() {
        return "GCTR";
    }

    private long blocksUntilRollover() {
        ByteBuffer byteBuffer = ByteBuffer.wrap(this.counter, this.counter.length - 4, 4);
        byteBuffer.order(ByteOrder.BIG_ENDIAN);
        long l = 0xFFFFFFFFL & (long)byteBuffer.getInt();
        long l2 = 0x100000000L - l;
        return l2;
    }

    int update(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        if (n2 - n > byArray.length) {
            throw new RuntimeException("input length out of bound");
        }
        if (n2 < 0 || n2 % 16 != 0) {
            throw new RuntimeException("input length unsupported");
        }
        if (byArray2.length - n3 < n2) {
            throw new RuntimeException("output buffer too small");
        }
        int n4 = n2 / 16;
        long l = this.blocksUntilRollover();
        if ((long)n4 >= l) {
            byte[] byArray3 = new byte[16];
            for (int i = 0; i < n4; ++i) {
                this.embeddedCipher.encryptBlock(this.counter, 0, byArray3, 0);
                for (int j = 0; j < 16; ++j) {
                    int n5 = i * 16 + j;
                    byArray2[n3 + n5] = (byte)(byArray[n + n5] ^ byArray3[j]);
                }
                GaloisCounterMode.increment32(this.counter);
            }
            return n2;
        }
        return this.encrypt(byArray, n, n2, byArray2, n3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int doFinal(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws IllegalBlockSizeException {
        try {
            if (n2 < 0) {
                throw new IllegalBlockSizeException("Negative input size!");
            }
            if (n2 > 0) {
                int n4 = n2 % 16;
                int n5 = n2 - n4;
                this.update(byArray, n, n5, byArray2, n3);
                if (n4 != 0) {
                    byte[] byArray3 = new byte[16];
                    this.embeddedCipher.encryptBlock(this.counter, 0, byArray3, 0);
                    for (int i = 0; i < n4; ++i) {
                        byArray2[n3 + n5 + i] = (byte)(byArray[n + n5 + i] ^ byArray3[i]);
                    }
                }
            }
        }
        finally {
            this.reset();
        }
        return n2;
    }
}

