/*
 * Decompiled with CFR 0.152.
 */
package ext.scf4.swg;

import ext.lib.swg.SwgComboBox;
import ext.lib.swg.SwgPanel;
import ext.lib.swg.SwgPeriodPanel;
import ext.lib.swg.SwgRadioButton;
import ext.lib.swg.SwgUtil;
import ext.scf4.stub.ScfCalendarStub;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Calendar;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;

public class HswgPeriodPanel
extends SwgPanel {
    private static final long serialVersionUID = 775852082445937887L;
    protected ItemType itemType;
    public SwgPeriodPanel datePeriodPanel;
    protected ItemListener itemListener = new ItemListener(){

        @Override
        public void itemStateChanged(ItemEvent ev) {
            try {
                HswgPeriodPanel.this.itemStateChanged2(ev);
            }
            catch (Exception ex) {
                HswgPeriodPanel.this.handleException(ex);
            }
        }
    };
    protected JPanel radioButtonPanel = new JPanel();
    protected ButtonGroup buttonGroup = new ButtonGroup();
    public SwgRadioButton noneRadioButton;
    public SwgRadioButton periodRadioButton;
    public SwgRadioButton weekRadioButton;
    public SwgRadioButton monthRadioButton;
    public SwgRadioButton yearRadioButton;
    public SwgComboBox periodComboBox;
    protected Window window;

    public HswgPeriodPanel() throws Exception {
        this(1);
    }

    public HswgPeriodPanel(int mode) throws Exception {
        this(mode, ItemType.COMBO_BOX);
    }

    public HswgPeriodPanel(ItemType itemType) throws Exception {
        this(1, itemType);
    }

    public HswgPeriodPanel(int mode, ItemType itemType) throws Exception {
        this.itemType = itemType;
        this.datePeriodPanel = new SwgPeriodPanel(mode);
        this.radioButtonPanel.setLayout(new FlowLayout(0, 0, 0));
        this.radioButtonPanel.getInsets().set(0, 0, 0, 0);
        int componentPanelWidth = 0;
        if (itemType == ItemType.COMBO_BOX) {
            this.periodComboBox = new SwgComboBox();
            PeriodNames[] periodNamesArray = PeriodNames.values();
            int n = periodNamesArray.length;
            int n2 = 0;
            while (n2 < n) {
                PeriodNames periodNames = periodNamesArray[n2];
                this.periodComboBox.addItem(periodNames.toString());
                ++n2;
            }
            this.periodComboBox.addActionListener(this.actionListener);
            this.periodComboBox.setSelectedIndex(PeriodNames.\u6307\u5b9a\u7121\u3057.ordinal());
            this.radioButtonPanel.add(this.periodComboBox);
            componentPanelWidth = this.periodComboBox.getPreferredSize().width + 20;
        } else if (itemType == ItemType.RADIO_BUTTON) {
            this.noneRadioButton = new SwgRadioButton(PeriodNames.\u6307\u5b9a\u7121\u3057.toString());
            this.periodRadioButton = new SwgRadioButton(PeriodNames.\u671f\u9593\u6307\u5b9a.toString());
            this.weekRadioButton = new SwgRadioButton(PeriodNames.\u4e00\u9031\u9593.toString());
            this.monthRadioButton = new SwgRadioButton(PeriodNames.\u4e00\u30f6\u6708.toString());
            this.yearRadioButton = new SwgRadioButton(PeriodNames.\u4e00\u5e74.toString());
            this.noneRadioButton.addItemListener(this.itemListener);
            this.buttonGroup.add(this.noneRadioButton);
            this.radioButtonPanel.add(this.noneRadioButton);
            this.periodRadioButton.addItemListener(this.itemListener);
            this.buttonGroup.add(this.periodRadioButton);
            this.radioButtonPanel.add(this.periodRadioButton);
            this.weekRadioButton.addItemListener(this.itemListener);
            this.buttonGroup.add(this.weekRadioButton);
            this.radioButtonPanel.add(this.weekRadioButton);
            this.monthRadioButton.addItemListener(this.itemListener);
            this.buttonGroup.add(this.monthRadioButton);
            this.radioButtonPanel.add(this.monthRadioButton);
            this.yearRadioButton.addItemListener(this.itemListener);
            this.buttonGroup.add(this.yearRadioButton);
            this.radioButtonPanel.add(this.yearRadioButton);
            this.setDefaultPeriod(PeriodNames.\u671f\u9593\u6307\u5b9a);
            componentPanelWidth = 320;
        }
        SwgUtil.setLocation(this, this.datePeriodPanel, 0.0, 0.0);
        this.periodComboBox.setPreferredSize(new Dimension(this.periodComboBox.getPreferredSize().width, this.datePeriodPanel.getPreferredSize().height));
        this.radioButtonPanel.setPreferredSize(new Dimension(componentPanelWidth, this.datePeriodPanel.getPreferredSize().height));
        SwgUtil.setLocation(this, this.radioButtonPanel, (double)(this.datePeriodPanel.getPreferredSize().width + 2), 0.0, (double)componentPanelWidth, (double)this.datePeriodPanel.getPreferredSize().height);
        this.setPreferredSize(new Dimension(this.radioButtonPanel.getX() + this.radioButtonPanel.getWidth(), this.datePeriodPanel.getPreferredSize().height));
    }

    @Override
    protected void actionPerformed2(ActionEvent ev) throws Exception {
        Calendar today = ScfCalendarStub.getInstance().getCalendar();
        if (ev.getSource() == this.periodComboBox) {
            String selectedItem = this.periodComboBox.getSelectedItemAsString();
            if (PeriodNames.\u6307\u5b9a\u7121\u3057.toString().equals(selectedItem)) {
                this.datePeriodPanel.dateTimeField1.setCalendar(null);
                this.datePeriodPanel.dateTimeField2.setCalendar(null);
            } else if (!PeriodNames.\u671f\u9593\u6307\u5b9a.toString().equals(selectedItem)) {
                if (PeriodNames.\u4e00\u9031\u9593.toString().equals(selectedItem)) {
                    Calendar calendar1 = (Calendar)today.clone();
                    calendar1.add(5, -7);
                    this.datePeriodPanel.dateTimeField1.setCalendar(calendar1);
                    Calendar calendar2 = (Calendar)today.clone();
                    this.datePeriodPanel.dateTimeField2.setCalendar(calendar2);
                } else if (PeriodNames.\u4e00\u30f6\u6708.toString().equals(selectedItem)) {
                    Calendar calendar1 = (Calendar)today.clone();
                    calendar1.add(2, -1);
                    this.datePeriodPanel.dateTimeField1.setCalendar(calendar1);
                    Calendar calendar2 = (Calendar)today.clone();
                    this.datePeriodPanel.dateTimeField2.setCalendar(calendar2);
                } else if (PeriodNames.\u4e00\u5e74.toString().equals(selectedItem)) {
                    Calendar calendar1 = (Calendar)today.clone();
                    calendar1.add(1, -1);
                    this.datePeriodPanel.dateTimeField1.setCalendar(calendar1);
                    Calendar calendar2 = (Calendar)today.clone();
                    this.datePeriodPanel.dateTimeField2.setCalendar(calendar2);
                }
            }
        }
    }

    protected void itemStateChanged2(ItemEvent ev) throws Exception {
        Calendar today = ScfCalendarStub.getInstance().getCalendar();
        if (ev.getSource() == this.noneRadioButton) {
            if (ev.getStateChange() == 1) {
                this.datePeriodPanel.dateTimeField1.setCalendar(null);
                this.datePeriodPanel.dateTimeField2.setCalendar(null);
            }
        } else if (ev.getSource() != this.periodRadioButton) {
            if (ev.getSource() == this.weekRadioButton) {
                if (ev.getStateChange() == 1) {
                    Calendar calendar1 = (Calendar)today.clone();
                    calendar1.add(5, -7);
                    this.datePeriodPanel.dateTimeField1.setCalendar(calendar1);
                    Calendar calendar2 = (Calendar)today.clone();
                    this.datePeriodPanel.dateTimeField2.setCalendar(calendar2);
                }
            } else if (ev.getSource() == this.monthRadioButton) {
                if (ev.getStateChange() == 1) {
                    Calendar calendar1 = (Calendar)today.clone();
                    calendar1.add(2, -1);
                    this.datePeriodPanel.dateTimeField1.setCalendar(calendar1);
                    Calendar calendar2 = (Calendar)today.clone();
                    this.datePeriodPanel.dateTimeField2.setCalendar(calendar2);
                }
            } else if (ev.getSource() == this.yearRadioButton && ev.getStateChange() == 1) {
                Calendar calendar1 = (Calendar)today.clone();
                calendar1.add(1, -1);
                this.datePeriodPanel.dateTimeField1.setCalendar(calendar1);
                Calendar calendar2 = (Calendar)today.clone();
                this.datePeriodPanel.dateTimeField2.setCalendar(calendar2);
            }
        }
    }

    public Calendar[] getPeriod() throws Exception {
        return this.datePeriodPanel.getCalendars();
    }

    public void setDefaultPeriod(PeriodNames periodNames) {
        if (this.itemType == ItemType.COMBO_BOX) {
            this.periodComboBox.setSelectedIndex(periodNames.ordinal());
        } else if (this.itemType == ItemType.RADIO_BUTTON) {
            if (PeriodNames.\u6307\u5b9a\u7121\u3057 == periodNames) {
                this.noneRadioButton.setSelected(true);
            } else if (PeriodNames.\u671f\u9593\u6307\u5b9a == periodNames) {
                this.periodRadioButton.setSelected(true);
            } else if (PeriodNames.\u4e00\u9031\u9593 == periodNames) {
                this.weekRadioButton.setSelected(true);
            } else if (PeriodNames.\u4e00\u30f6\u6708 == periodNames) {
                this.monthRadioButton.setSelected(true);
            } else if (PeriodNames.\u4e00\u5e74 == periodNames) {
                this.yearRadioButton.setSelected(true);
            }
        }
    }

    public static enum ItemType {
        RADIO_BUTTON,
        COMBO_BOX;

    }

    public static enum PeriodNames {
        \u6307\u5b9a\u7121\u3057,
        \u671f\u9593\u6307\u5b9a,
        \u4e00\u9031\u9593,
        \u4e00\u30f6\u6708,
        \u4e00\u5e74;

    }
}

