/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs;

import org.apache.xerces.impl.dv.ValidatedInfo;
import org.apache.xerces.impl.xs.PSVIErrorList;
import org.apache.xerces.impl.xs.util.StringListImpl;
import org.apache.xerces.xs.AttributePSVI;
import org.apache.xerces.xs.ItemPSVI;
import org.apache.xerces.xs.ShortList;
import org.apache.xerces.xs.StringList;
import org.apache.xerces.xs.XSAttributeDeclaration;
import org.apache.xerces.xs.XSSimpleTypeDefinition;
import org.apache.xerces.xs.XSTypeDefinition;
import org.apache.xerces.xs.XSValue;

public class AttributePSVImpl
implements AttributePSVI {
    protected XSAttributeDeclaration fDeclaration = null;
    protected XSTypeDefinition fTypeDecl = null;
    protected boolean fSpecified = false;
    protected ValidatedInfo fValue = new ValidatedInfo();
    protected short fValidationAttempted = 0;
    protected short fValidity = 0;
    protected String[] fErrors = null;
    protected String fValidationContext = null;
    protected boolean fIsConstant;

    public AttributePSVImpl() {
    }

    public AttributePSVImpl(boolean isConstant, AttributePSVI attrPSVI) {
        this.fDeclaration = attrPSVI.getAttributeDeclaration();
        this.fTypeDecl = attrPSVI.getTypeDefinition();
        this.fSpecified = attrPSVI.getIsSchemaSpecified();
        this.fValue.copyFrom(attrPSVI.getSchemaValue());
        this.fValidationAttempted = attrPSVI.getValidationAttempted();
        this.fValidity = attrPSVI.getValidity();
        if (attrPSVI instanceof AttributePSVImpl) {
            AttributePSVImpl attrPSVIImpl = (AttributePSVImpl)attrPSVI;
            this.fErrors = attrPSVIImpl.fErrors != null ? (String[])attrPSVIImpl.fErrors.clone() : null;
        } else {
            StringList errorCodes = attrPSVI.getErrorCodes();
            int length = errorCodes.getLength();
            if (length > 0) {
                StringList errorMessages = attrPSVI.getErrorMessages();
                String[] errors = new String[length << 1];
                int i = 0;
                int j = 0;
                while (i < length) {
                    errors[j++] = errorCodes.item(i);
                    errors[j++] = errorMessages.item(i);
                    ++i;
                }
                this.fErrors = errors;
            }
        }
        this.fValidationContext = attrPSVI.getValidationContext();
        this.fIsConstant = isConstant;
    }

    @Override
    public ItemPSVI constant() {
        if (this.isConstant()) {
            return this;
        }
        return new AttributePSVImpl(true, this);
    }

    @Override
    public boolean isConstant() {
        return this.fIsConstant;
    }

    @Override
    public String getSchemaDefault() {
        return this.fDeclaration == null ? null : this.fDeclaration.getConstraintValue();
    }

    @Override
    public String getSchemaNormalizedValue() {
        return this.fValue.getNormalizedValue();
    }

    @Override
    public boolean getIsSchemaSpecified() {
        return this.fSpecified;
    }

    @Override
    public short getValidationAttempted() {
        return this.fValidationAttempted;
    }

    @Override
    public short getValidity() {
        return this.fValidity;
    }

    @Override
    public StringList getErrorCodes() {
        if (this.fErrors == null || this.fErrors.length == 0) {
            return StringListImpl.EMPTY_LIST;
        }
        return new PSVIErrorList(this.fErrors, true);
    }

    @Override
    public StringList getErrorMessages() {
        if (this.fErrors == null || this.fErrors.length == 0) {
            return StringListImpl.EMPTY_LIST;
        }
        return new PSVIErrorList(this.fErrors, false);
    }

    @Override
    public String getValidationContext() {
        return this.fValidationContext;
    }

    @Override
    public XSTypeDefinition getTypeDefinition() {
        return this.fTypeDecl;
    }

    @Override
    public XSSimpleTypeDefinition getMemberTypeDefinition() {
        return this.fValue.getMemberTypeDefinition();
    }

    @Override
    public XSAttributeDeclaration getAttributeDeclaration() {
        return this.fDeclaration;
    }

    @Override
    public Object getActualNormalizedValue() {
        return this.fValue.getActualValue();
    }

    @Override
    public short getActualNormalizedValueType() {
        return this.fValue.getActualValueType();
    }

    @Override
    public ShortList getItemValueTypes() {
        return this.fValue.getListValueTypes();
    }

    @Override
    public XSValue getSchemaValue() {
        return this.fValue;
    }

    public void reset() {
        this.fValue.reset();
        this.fDeclaration = null;
        this.fTypeDecl = null;
        this.fSpecified = false;
        this.fValidationAttempted = 0;
        this.fValidity = 0;
        this.fErrors = null;
        this.fValidationContext = null;
    }
}

