/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xfil.fx;

import ext.base.log.BcLogUtil;
import ext.lib.fx.layout.FxBorderPane;
import ext.lib.fx.tree.FxTreeView;
import ext.lib.fx.util.FxImageHelper;
import ext.libx.fx.FxxMouseEventUtil;
import ext.libx.fx.viewer.FxxImageView;
import ext.libx.fx.viewer.FxxUrlEvent;
import ext.module.xdts.fx.XdtsMenuIF;
import ext.module.xfil.common.XfilUtil;
import ext.module.xfil.common.XfilWords;
import ext.module.xfil.fx.XfilCrawlIndicationPane;
import ext.module.xfil.fx.XfilExplorerPane;
import ext.module.xfil.fx.XfilFileIndexListPane;
import ext.module.xfil.fx.XfilFileTreeView;
import ext.module.xfil.fx.XfilFxHelper;
import ext.module.xfil.fx.XfilIndexTreeBasePane;
import ext.module.xfil.fx.XfilMainViewPane;
import ext.module.xfil.fx.Y_XfilThumbnailCreatePane;
import ext.module.xfil.model.XfilUriEntity;
import ext.module.xfil.model.XfilUriEntityWrap;
import ext.module.xfil.swg.XfilCrawlListPanel;
import ext.module.xfil.swg.XfilFileIndexListPanel;
import ext.scf3.stub.ScfDatabaseStub;
import java.awt.Desktop;
import java.io.File;
import java.util.List;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.MenuBar;
import javafx.scene.control.TreeItem;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.VBox;
import javax.swing.SwingUtilities;

public class XfilMenuPane
extends FxBorderPane
implements XdtsMenuIF {
    VBox vBox = new VBox(8.0);
    Button fileCrawlButton;
    Button screenCaptureButton;
    Button fileListButton;
    Button crawlListButton;
    Button settingButton;
    Button fileIndexListFxButton;
    Button test1Button;
    Button tree1Button;
    Button tree2Button;
    Button dbCheckButton;
    double bw;
    double bh;

    public XfilMenuPane() throws Exception {
        this.fileCrawlButton = new Button(XfilWords.getInstance().FileCrawl.toPlain());
        this.screenCaptureButton = new Button(XfilWords.getInstance().ScreenCapture.toPlain());
        this.fileListButton = new Button(XfilWords.getInstance().FileList.toPlain());
        this.crawlListButton = new Button(XfilWords.getInstance().CrawlList.toPlain());
        this.settingButton = new Button(XfilWords.getInstance().Setting.toPlain());
        this.fileIndexListFxButton = new Button("File Index List Fx");
        this.test1Button = new Button("TEST1");
        this.tree1Button = new Button("Tree1");
        this.tree2Button = new Button("Tree2");
        this.dbCheckButton = new Button("DB Check");
        this.bw = 220.0;
        this.bh = 32.0;
        this.setComponant();
    }

    protected void setComponant() throws Exception {
        this.fileCrawlButton.setOnAction(this.actionEventHandler);
        this.fileCrawlButton.setGraphic((Node)FxImageHelper.createImageView_icon("folder_view_64x64.png"));
        this.fileCrawlButton.setPrefSize(this.bw, this.bh);
        this.vBox.getChildren().add((Object)this.fileCrawlButton);
        this.screenCaptureButton.setOnAction(this.actionEventHandler);
        this.screenCaptureButton.setGraphic((Node)FxImageHelper.createImageView_icon("screenshot_64x64.png"));
        this.screenCaptureButton.setPrefSize(this.bw, this.bh);
        this.vBox.getChildren().add((Object)this.screenCaptureButton);
        this.fileListButton.setOnAction(this.actionEventHandler);
        this.fileListButton.setGraphic((Node)FxImageHelper.createImageView_icon("table_view_64x64.png"));
        this.fileListButton.setPrefSize(this.bw, this.bh);
        this.vBox.getChildren().add((Object)this.fileListButton);
        this.crawlListButton.setOnAction(this.actionEventHandler);
        this.crawlListButton.setGraphic((Node)FxImageHelper.createImageView_icon("table_view_64x64.png"));
        this.crawlListButton.setPrefSize(this.bw, this.bh);
        this.vBox.getChildren().add((Object)this.crawlListButton);
        this.settingButton.setOnAction(this.actionEventHandler);
        this.settingButton.setGraphic((Node)FxImageHelper.createImageView_icon("gear_64x64.png"));
        this.settingButton.setPrefSize(this.bw, this.bh);
        this.vBox.getChildren().add((Object)this.settingButton);
        this.fileIndexListFxButton.setOnAction(this.actionEventHandler);
        this.fileIndexListFxButton.setPrefSize(this.bw, this.bh);
        this.vBox.getChildren().add((Object)this.fileIndexListFxButton);
        this.test1Button.setOnAction(this.actionEventHandler);
        this.test1Button.setPrefSize(this.bw, this.bh);
        this.vBox.getChildren().add((Object)this.test1Button);
        this.tree1Button.setOnAction(this.actionEventHandler);
        this.tree1Button.setPrefSize(this.bw, this.bh);
        this.vBox.getChildren().add((Object)this.tree1Button);
        this.tree2Button.setOnAction(this.actionEventHandler);
        this.tree2Button.setPrefSize(this.bw, this.bh);
        this.vBox.getChildren().add((Object)this.tree2Button);
        this.dbCheckButton.setOnAction(this.actionEventHandler);
        this.dbCheckButton.setPrefSize(this.bw, this.bh);
        this.vBox.getChildren().add((Object)this.dbCheckButton);
        this.vBox.setAlignment(Pos.TOP_CENTER);
        this.setCenter((Node)this.vBox);
    }

    @Override
    public void actionPerformed(ActionEvent ev) throws Exception {
        super.actionPerformed(ev);
        if (ev.getSource() == this.fileCrawlButton || ev.getSource() == this.screenCaptureButton) {
            XfilCrawlIndicationPane.Mode mode = null;
            if (ev.getSource() == this.fileCrawlButton) {
                mode = XfilCrawlIndicationPane.Mode.fileCrawl;
            } else if (ev.getSource() == this.screenCaptureButton) {
                mode = XfilCrawlIndicationPane.Mode.videoCapture;
            }
            XfilCrawlIndicationPane crawlIndicationPane = new XfilCrawlIndicationPane(mode);
            crawlIndicationPane.show(null);
        } else if (ev.getSource() == this.fileListButton) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        XfilFileIndexListPanel fileIndexListPanel = new XfilFileIndexListPanel();
                        fileIndexListPanel.init();
                        fileIndexListPanel.showAsFrame();
                    }
                    catch (Exception ex) {
                        XfilMenuPane.this.handleException(ex);
                    }
                }
            });
        } else if (ev.getSource() == this.crawlListButton) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        XfilCrawlListPanel crawlListPanel = new XfilCrawlListPanel();
                        crawlListPanel.init();
                        crawlListPanel.showAsFrame();
                    }
                    catch (Exception ex) {
                        XfilMenuPane.this.handleException(ex);
                    }
                }
            });
        } else if (ev.getSource() == this.fileIndexListFxButton) {
            XfilFileIndexListPane fileIndexListPane = new XfilFileIndexListPane();
            fileIndexListPane.show(null, false);
        } else if (ev.getSource() == this.settingButton) {
            XfilFxHelper.getInstance().openSettingPane();
        } else if (ev.getSource() == this.test1Button) {
            Y_XfilThumbnailCreatePane thumbnailCreatePane = new Y_XfilThumbnailCreatePane();
            thumbnailCreatePane.show(null);
        } else if (ev.getSource() == this.tree1Button) {
            XfilIndexTreeBasePane indexTreeBasePane = new XfilIndexTreeBasePane();
            indexTreeBasePane.show();
        } else if (ev.getSource() == this.tree2Button) {
            XfilMenuPane.tree2();
        } else if (ev.getSource() == this.dbCheckButton) {
            ScfDatabaseStub.getInstance().checkDatasource();
        }
    }

    @Override
    public String getTitle() throws Exception {
        return XfilWords.getInstance().\u30d5\u30a1\u30a4\u30eb\u30e6\u30fc\u30c6\u30a3\u30ea\u30c6\u30a3;
    }

    @Override
    public void setMenu(MenuBar menuBar) throws Exception {
    }

    @Override
    public ImageView getImageView() throws Exception {
        return FxImageHelper.createImageView_icon("schedule_64x64.png");
    }

    public static void tree2() throws Exception {
        XfilFileTreeView fileTreeView = new XfilFileTreeView();
        XfilExplorerPane explorerPane = new XfilExplorerPane();
        explorerPane.addTab((Node)fileTreeView, 0);
        XfilMainViewPane mainViewPane = new XfilMainViewPane();
        mainViewPane.show(null);
        fileTreeView.setEventHandler((EventHandler<? super FxxUrlEvent>)((EventHandler)ev -> {
            if (ev.getEventType() == FxxUrlEvent.SELECTED) {
                try {
                    TreeItem treeItem = (TreeItem)ev.getSource();
                    BcLogUtil.debug("#### treeItem.getValue()=" + treeItem.getValue());
                    XfilUriEntityWrap uriEntityWrap = (XfilUriEntityWrap)treeItem.getValue();
                    BcLogUtil.debug("uriEntityWrap.uri=" + uriEntityWrap.uri);
                    if (XfilFileTreeView.dummyUrl.equals(uriEntityWrap.uriStr)) {
                        File file = fileTreeView.getFile(treeItem);
                        fileTreeView.setFiles_L2(file.toPath(), treeItem);
                    }
                    List<XfilUriEntityWrap> uriEntityWrapList = XfilUtil.createUriEntityWrapList(uriEntityWrap.uri);
                    explorerPane.clear();
                    for (XfilUriEntityWrap uriEntityWrap2 : uriEntityWrapList) {
                        explorerPane.addUriEntityWrap(uriEntityWrap2);
                    }
                }
                catch (Exception ex) {
                    BcLogUtil.error(ex);
                }
            }
        }));
        explorerPane.setEventHandler((EventHandler<? super FxxUrlEvent>)((EventHandler)ev -> {
            try {
                BcLogUtil.debug("FxxUrlEvent.URL_SELECTED:ev.getSource()=" + ev.getSource());
                if (ev.getEventType() == FxxUrlEvent.SELECTED) {
                    XfilUriEntityWrap uriEntityWrap = (XfilUriEntityWrap)ev.getSource();
                    if (FxxMouseEventUtil.isImageExtention(uriEntityWrap.uri)) {
                        Image image = FxxMouseEventUtil.createBaseImage(uriEntityWrap.uri);
                        FxxImageView imageView = new FxxImageView(image);
                        mainViewPane.addNode((Node)imageView);
                    } else if (FxxMouseEventUtil.isMediaExtention(uriEntityWrap.uri)) {
                        // empty if block
                    }
                    fileTreeView.setUri(uriEntityWrap.uri);
                } else if (ev.getEventType() == FxxUrlEvent.EXE) {
                    XfilUriEntityWrap uriEntityWrap = (XfilUriEntityWrap)ev.getSource();
                    if (!FxxMouseEventUtil.isImageExtention(uriEntityWrap.uri) && FxxMouseEventUtil.isMediaExtention(uriEntityWrap.uri)) {
                        File file = new File(uriEntityWrap.uri.getPath());
                        BcLogUtil.debug("file.getPath()=" + file.getPath() + " exists=" + file.exists());
                        if (file.exists()) {
                            Desktop.getDesktop().open(file);
                        }
                    }
                }
            }
            catch (Exception ex) {
                BcLogUtil.error(ex);
            }
        }));
        explorerPane.show(null);
    }

    protected class FavoriteTreeView<T>
    extends FxTreeView {
        public FavoriteTreeView(TreeItem<T> rootTreeItem) {
            super(rootTreeItem);
        }

        protected void selectionChanged(ObservableValue observable, TreeItem oldTreeItem, TreeItem newTreeItem) throws Exception {
            XfilUriEntity uriEntity = (XfilUriEntity)newTreeItem.getValue();
        }

        protected void treeItemCollapsed(TreeItem.TreeModificationEvent ev) throws Exception {
        }
    }
}

