/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xdts.dao;

import ext.lib.datasource.DtsSession;
import ext.lib.orm.dao.OrmAbstractDAO;
import ext.lib.sql.SqlUtil;
import ext.lib.sql.context.SqlContext;
import ext.lib.sql.model.SqlSelectQuery;
import ext.lib.sql.model.SqlUpdateQuery;
import ext.lib.sql.model.SqlWhereElement;
import ext.libx.etc.model.EtcWord;
import java.util.List;

public class XdtsWordDAO
extends OrmAbstractDAO<EtcWord> {
    public XdtsWordDAO() {
        super(new EtcWord[0]);
        this.setTableName("xdts_word");
    }

    public static XdtsWordDAO getInstance() {
        return SingletonHolder.instance;
    }

    public EtcWord getByCode(DtsSession dtsSession, int profileId, String code, String lang) throws Exception {
        SqlContext sqlContext = dtsSession.getSqlContext();
        SqlSelectQuery selectQuery = new SqlSelectQuery();
        selectQuery.getSelectColumnList().addAll(this.getColumnNameList(null));
        selectQuery.setFromClause(this.tableName);
        SqlWhereElement whereElement = new SqlWhereElement();
        whereElement.setLogical_AND();
        whereElement.setFormula("profile_id = " + profileId);
        selectQuery.addWhereElement(whereElement);
        whereElement = new SqlWhereElement();
        whereElement.setLogical_AND();
        whereElement.setFormula("code " + sqlContext.toCondition_string("=", code));
        selectQuery.addWhereElement(whereElement);
        whereElement = new SqlWhereElement();
        whereElement.setLogical_AND();
        whereElement.setFormula("lang " + sqlContext.toCondition_string("=", lang));
        selectQuery.addWhereElement(whereElement);
        String query = sqlContext.buildSelectQuery(selectQuery);
        return (EtcWord)this.getEntity(dtsSession, query);
    }

    public List<EtcWord> getListByProfileId(DtsSession dtsSession, int profileId) throws Exception {
        SqlContext sqlContext = dtsSession.getSqlContext();
        SqlSelectQuery selectQuery = new SqlSelectQuery();
        selectQuery.getSelectColumnList().addAll(this.getColumnNameList(null));
        selectQuery.setFromClause(this.tableName);
        SqlWhereElement whereElement = new SqlWhereElement();
        whereElement.setLogical_AND();
        whereElement.setFormula("profile_id = " + profileId);
        selectQuery.addWhereElement(whereElement);
        String query = sqlContext.buildSelectQuery(selectQuery);
        return this.getEntityList(dtsSession, query);
    }

    public int deleteByProfileId(DtsSession dtsSession, int profileId) throws Exception {
        SqlContext sqlContext = dtsSession.getSqlContext();
        SqlUpdateQuery updateQuery = new SqlUpdateQuery();
        updateQuery.tableName = this.tableName;
        SqlWhereElement whereElement = new SqlWhereElement();
        whereElement.setLogical_AND();
        whereElement.setFormula("profile_id = " + profileId);
        updateQuery.addWhereElement(whereElement);
        String query = sqlContext.buildDeleteQuery(updateQuery);
        return SqlUtil.executeUpdate(dtsSession.getConnection(), query);
    }

    private static final class SingletonHolder {
        private static final XdtsWordDAO instance = new XdtsWordDAO();

        private SingletonHolder() {
        }
    }
}

