/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.fx.control;

import ext.base.util.BcWords;
import ext.lib.fx.util.FxImageHelper;
import ext.lib.fx.util.FxUtil;
import ext.lib.swg.SwgUtil;
import java.util.Map;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.Labeled;
import javafx.scene.control.MenuItem;
import javafx.scene.image.ImageView;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;

public class FxLabel
extends Label {
    protected ContextMenu contextMenu = new ContextMenu();
    protected MenuItem copyMenuItem;
    protected EventHandler<MouseEvent> mouseEventHandler;
    protected EventHandler contextMeneEventHandler;

    public FxLabel() {
        this.copyMenuItem = new MenuItem(BcWords.getInstance().copy);
        this.mouseEventHandler = new EventHandler<MouseEvent>(){

            public void handle(MouseEvent ev) {
                try {
                    FxLabel.this.mouseEvent(ev);
                }
                catch (Exception ex) {
                    FxLabel.this.handleException(ex);
                }
            }
        };
        this.contextMeneEventHandler = new EventHandler(){

            public void handle(Event ev) {
                try {
                    FxLabel.this.contextMenuHandle(ev);
                }
                catch (Exception ex) {
                    FxLabel.this.handleException(ex);
                }
            }
        };
        this.init();
    }

    public FxLabel(String text) {
        super(text);
        this.copyMenuItem = new MenuItem(BcWords.getInstance().copy);
        this.mouseEventHandler = new /* invalid duplicate definition of identical inner class */;
        this.contextMeneEventHandler = new /* invalid duplicate definition of identical inner class */;
        this.init();
    }

    public FxLabel(String text, Node graphic) {
        super(text, graphic);
        this.copyMenuItem = new MenuItem(BcWords.getInstance().copy);
        this.mouseEventHandler = new /* invalid duplicate definition of identical inner class */;
        this.contextMeneEventHandler = new /* invalid duplicate definition of identical inner class */;
        this.init();
    }

    protected void init() {
        this.setOnMouseClicked(this.mouseEventHandler);
        this.styleProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                try {
                    FxLabel.this.styleChanged(oldValue, newValue);
                }
                catch (Exception ex) {
                    FxLabel.this.handleException(ex);
                }
            }
        });
        this.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                try {
                    FxLabel.this.textChanged(oldValue, newValue);
                }
                catch (Exception ex) {
                    FxLabel.this.handleException(ex);
                }
            }
        });
        this.contextMenu.getItems().add((Object)this.copyMenuItem);
        this.copyMenuItem.setOnAction(this.contextMeneEventHandler);
        try {
            ImageView imageView = FxImageHelper.createImageView_icon("copy_64x64.png");
            this.copyMenuItem.setGraphic((Node)imageView);
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    protected void mouseEvent(MouseEvent ev) throws Exception {
        if (ev.getButton().equals((Object)MouseButton.SECONDARY)) {
            this.setContextMenu(this.contextMenu);
        }
    }

    public void contextMenuHandle(Event ev) throws Exception {
        if (ev.getSource() == this.copyMenuItem) {
            Clipboard clipboard = Clipboard.getSystemClipboard();
            ClipboardContent content = new ClipboardContent();
            content.putString(this.getText());
            clipboard.setContent((Map)content);
        }
    }

    protected void textChanged(String oldValue, String newValue) throws Exception {
        FxUtil.setPrefSize_Labeled((Labeled)this);
    }

    protected void styleChanged(String oldValue, String newValue) throws Exception {
        FxUtil.setPrefSize_Labeled((Labeled)this);
    }

    protected void handleException(Throwable throwable) {
        SwgUtil.getExceptionHandler().handleException(throwable, (Object)this);
    }
}

