/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jnlp;

import com.sun.applet2.preloader.CancelException;
import com.sun.applet2.preloader.Preloader;
import com.sun.applet2.preloader.event.ConfigEvent;
import com.sun.applet2.preloader.event.InitEvent;
import com.sun.applet2.preloader.event.PreloaderEvent;
import com.sun.deploy.cache.Cache;
import com.sun.deploy.model.Resource;
import com.sun.deploy.model.ResourceProvider;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.uitoolkit.ToolkitStore;
import com.sun.javaws.CacheUtil;
import com.sun.javaws.LaunchDownload;
import com.sun.javaws.jnl.ExtensionDesc;
import com.sun.javaws.jnl.JARDesc;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.jnl.LaunchDescFactory;
import com.sun.javaws.jnl.ResourceVisitor;
import com.sun.javaws.jnl.ResourcesDesc;
import com.sun.javaws.progress.CustomProgress2PreloaderAdapter;
import com.sun.javaws.progress.PreloaderDelegate;
import com.sun.jnlp.JNLPClassLoaderIf;
import com.sun.jnlp.JNLPClassLoaderUtil;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.jar.JarFile;
import javax.jnlp.DownloadService;
import javax.jnlp.DownloadServiceListener;

public final class DownloadServiceImpl
implements DownloadService {
    private static DownloadServiceImpl _sharedInstance = null;
    private DownloadServiceListener _defaultProgressHelper = null;

    private DownloadServiceImpl() {
    }

    static synchronized void reset() {
        _sharedInstance = null;
    }

    public static synchronized DownloadServiceImpl getInstance() {
        DownloadServiceImpl.initialize();
        return _sharedInstance;
    }

    public static synchronized void initialize() {
        if (_sharedInstance == null) {
            _sharedInstance = new DownloadServiceImpl();
        }
    }

    public DownloadServiceListener getDefaultProgressWindow() {
        if (this._defaultProgressHelper == null) {
            this._defaultProgressHelper = (DownloadServiceListener)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    Preloader preloader = ToolkitStore.get().getDefaultPreloader();
                    try {
                        preloader.handleEvent((PreloaderEvent)new ConfigEvent(3, JNLPClassLoaderUtil.getInstance().getLaunchDesc().getAppInfo()));
                        preloader.handleEvent((PreloaderEvent)new InitEvent(1));
                    }
                    catch (CancelException cancelException) {
                        Trace.ignoredException((Exception)((Object)cancelException));
                    }
                    return new PreloaderDelegate(preloader);
                }
            });
        }
        return this._defaultProgressHelper;
    }

    public boolean isResourceCached(final URL uRL, final String string) {
        Boolean bl = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (DownloadServiceImpl.this.isResourceValid(uRL, string) && ResourceProvider.get().isCached(uRL, string)) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        });
        return bl;
    }

    public boolean isPartCached(String string) {
        return this.isPartCached(new String[]{string});
    }

    public boolean isPartCached(final String[] stringArray) {
        Boolean bl = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                LaunchDesc launchDesc = JNLPClassLoaderUtil.getInstance().getLaunchDesc();
                ResourcesDesc resourcesDesc = launchDesc.getResources();
                if (resourcesDesc == null) {
                    return Boolean.FALSE;
                }
                JARDesc[] jARDescArray = resourcesDesc.getPartJars(stringArray);
                return new Boolean(DownloadServiceImpl.this.isJARInCache(jARDescArray, true));
            }
        });
        return bl;
    }

    public boolean isExtensionPartCached(URL uRL, String string, String string2) {
        return this.isExtensionPartCached(uRL, string, new String[]{string2});
    }

    public boolean isExtensionPartCached(final URL uRL, final String string, final String[] stringArray) {
        Boolean bl = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                LaunchDesc launchDesc = JNLPClassLoaderUtil.getInstance().getLaunchDesc();
                ResourcesDesc resourcesDesc = launchDesc.getResources();
                if (resourcesDesc == null) {
                    return Boolean.FALSE;
                }
                JARDesc[] jARDescArray = resourcesDesc.getExtensionPart(uRL, string, stringArray);
                return new Boolean(DownloadServiceImpl.this.isJARInCache(jARDescArray, true));
            }
        });
        return bl;
    }

    public void loadResource(final URL uRL, final String string, final DownloadServiceListener downloadServiceListener) throws IOException {
        Trace.println((String)(this.getClass().getName() + ".loadResource(" + uRL + "," + downloadServiceListener.getClass().getName() + ")"));
        if (this.isResourceValid(uRL, string)) {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws IOException {
                        CustomProgress2PreloaderAdapter customProgress2PreloaderAdapter = new CustomProgress2PreloaderAdapter(downloadServiceListener);
                        PreloaderDelegate preloaderDelegate = DownloadServiceImpl.this.getProgressHelper(customProgress2PreloaderAdapter);
                        int n = ResourceProvider.get().incrementInternalUse();
                        try {
                            if (uRL.toString().endsWith(".jar")) {
                                JNLPClassLoaderIf jNLPClassLoaderIf = JNLPClassLoaderUtil.getInstance();
                                if (string != null) {
                                    ToolkitStore.get().getAppContext().put((Object)("deploy-" + uRL.toString()), (Object)string);
                                }
                                jNLPClassLoaderIf.addResource(uRL, string, null);
                                if (!DownloadServiceImpl.this.isResourceCached(uRL, string)) {
                                    LaunchDownload.downloadResource(jNLPClassLoaderIf.getLaunchDesc(), uRL, string, preloaderDelegate, true);
                                }
                            } else {
                                Resource resource = ResourceProvider.get().getResource(uRL, string);
                                if (resource.isJNLPFile()) {
                                    DownloadServiceImpl.this.loadResourceRecursivly(resource, downloadServiceListener);
                                }
                            }
                        }
                        catch (Exception exception) {
                            throw new IOException(exception.getMessage());
                        }
                        finally {
                            preloaderDelegate.forceFlushForTCK();
                            ResourceProvider.get().decrementInternalUse(n);
                        }
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw (IOException)privilegedActionException.getException();
            }
        }
    }

    private void loadResourceRecursivly(Resource resource, final DownloadServiceListener downloadServiceListener) {
        try {
            File file = new File(resource.getResourceFilename());
            URL uRL = new URL(resource.getURL());
            LaunchDesc launchDesc = LaunchDescFactory.buildDescriptor(file, null, null, uRL);
            ResourcesDesc resourcesDesc = launchDesc.getResources();
            if (resourcesDesc != null) {
                resourcesDesc.visit(new ResourceVisitor(){

                    public void visitJARDesc(JARDesc jARDesc) {
                        try {
                            DownloadServiceImpl.this.loadResource(jARDesc.getLocation(), jARDesc.getVersion(), downloadServiceListener);
                        }
                        catch (IOException iOException) {
                            Trace.ignored((Throwable)iOException);
                        }
                    }

                    public void visitExtensionDesc(ExtensionDesc extensionDesc) {
                        try {
                            DownloadServiceImpl.this.loadResource(extensionDesc.getLocation(), extensionDesc.getVersion(), downloadServiceListener);
                        }
                        catch (IOException iOException) {
                            Trace.ignored((Throwable)iOException);
                        }
                    }
                });
            }
        }
        catch (Exception exception) {
            Trace.ignored((Throwable)exception);
        }
    }

    public void loadPart(String string, DownloadServiceListener downloadServiceListener) throws IOException {
        this.loadPart(new String[]{string}, downloadServiceListener);
    }

    public void loadPart(final String[] stringArray, final DownloadServiceListener downloadServiceListener) throws IOException {
        Trace.println((String)(this.getClass().getName() + ".loadPart(" + Arrays.asList(stringArray) + "," + downloadServiceListener.getClass().getName() + ")"), (TraceLevel)TraceLevel.TEMP);
        if (this.isPartCached(stringArray)) {
            return;
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    CustomProgress2PreloaderAdapter customProgress2PreloaderAdapter = new CustomProgress2PreloaderAdapter(downloadServiceListener);
                    PreloaderDelegate preloaderDelegate = DownloadServiceImpl.this.getProgressHelper(customProgress2PreloaderAdapter);
                    try {
                        LaunchDownload.downloadParts(JNLPClassLoaderUtil.getInstance().getLaunchDesc(), stringArray, preloaderDelegate, true);
                    }
                    catch (Exception exception) {
                        throw new IOException(exception.getMessage());
                    }
                    finally {
                        preloaderDelegate.forceFlushForTCK();
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
    }

    public void loadExtensionPart(URL uRL, String string, String string2, DownloadServiceListener downloadServiceListener) throws IOException {
        this.loadExtensionPart(uRL, string, new String[]{string2}, downloadServiceListener);
    }

    public void loadExtensionPart(final URL uRL, final String string, final String[] stringArray, final DownloadServiceListener downloadServiceListener) throws IOException {
        try {
            Trace.println((String)(this.getClass().getName() + ".loadExtensionPart(" + Arrays.asList(stringArray) + "," + downloadServiceListener.getClass().getName() + ")"));
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    CustomProgress2PreloaderAdapter customProgress2PreloaderAdapter = new CustomProgress2PreloaderAdapter(downloadServiceListener);
                    PreloaderDelegate preloaderDelegate = DownloadServiceImpl.this.getProgressHelper(customProgress2PreloaderAdapter);
                    try {
                        LaunchDownload.downloadExtensionPart(JNLPClassLoaderUtil.getInstance().getLaunchDesc(), uRL, string, stringArray, preloaderDelegate, true);
                    }
                    catch (Exception exception) {
                        throw new IOException(exception.getMessage());
                    }
                    finally {
                        preloaderDelegate.forceFlushForTCK();
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
    }

    public void removeResource(final URL uRL, final String string) throws IOException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    if (DownloadServiceImpl.this.isResourceValid(uRL, string)) {
                        Resource resource;
                        if (uRL.toString().endsWith("jnlp")) {
                            CacheUtil.remove(Cache.getCacheEntry((URL)uRL, (String)string));
                        }
                        if ((resource = ResourceProvider.get().getCachedResource(uRL, string)) != null) {
                            ResourceProvider.get().markRetired(resource, true);
                        }
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
    }

    public void removePart(String string) throws IOException {
        this.removePart(new String[]{string});
    }

    public void removePart(final String[] stringArray) throws IOException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    LaunchDesc launchDesc = JNLPClassLoaderUtil.getInstance().getLaunchDesc();
                    ResourcesDesc resourcesDesc = launchDesc.getResources();
                    if (resourcesDesc == null) {
                        return null;
                    }
                    JARDesc[] jARDescArray = resourcesDesc.getPartJars(stringArray);
                    DownloadServiceImpl.this.removeJARFromCache(jARDescArray);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
    }

    public void removeExtensionPart(URL uRL, String string, String string2) throws IOException {
        this.removeExtensionPart(uRL, string, new String[]{string2});
    }

    public void removeExtensionPart(final URL uRL, final String string, final String[] stringArray) throws IOException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    LaunchDesc launchDesc = JNLPClassLoaderUtil.getInstance().getLaunchDesc();
                    ResourcesDesc resourcesDesc = launchDesc.getResources();
                    if (resourcesDesc == null) {
                        return null;
                    }
                    JARDesc[] jARDescArray = resourcesDesc.getExtensionPart(uRL, string, stringArray);
                    DownloadServiceImpl.this.removeJARFromCache(jARDescArray);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
    }

    private void removeJARFromCache(JARDesc[] jARDescArray) throws IOException {
        if (jARDescArray == null) {
            return;
        }
        if (jARDescArray.length == 0) {
            return;
        }
        for (int i = 0; i < jARDescArray.length; ++i) {
            Resource resource = ResourceProvider.get().getCachedResource(jARDescArray[i].getLocation(), jARDescArray[i].getVersion());
            ResourceProvider.get().markRetired(resource, true);
        }
    }

    private boolean isJARInCache(JARDesc[] jARDescArray, boolean bl) {
        if (jARDescArray == null) {
            return false;
        }
        if (jARDescArray.length == 0) {
            return false;
        }
        boolean bl2 = true;
        for (int i = 0; i < jARDescArray.length; ++i) {
            JarFile jarFile = ResourceProvider.get().getCachedJarFile(jARDescArray[i].getLocation(), jARDescArray[i].getVersion());
            if (jarFile != null) {
                if (bl) continue;
                return true;
            }
            bl2 = false;
        }
        return bl2;
    }

    private boolean isResourceValid(URL uRL, String string) {
        LaunchDesc launchDesc = JNLPClassLoaderUtil.getInstance().getLaunchDesc();
        JARDesc[] jARDescArray = launchDesc.getResources().getEagerOrAllJarDescs(true);
        if (launchDesc.getSecurityModel() != 0) {
            return true;
        }
        for (int i = 0; i < jARDescArray.length; ++i) {
            if (!uRL.toString().equals(jARDescArray[i].getLocation().toString()) || string != null && !string.equals(jARDescArray[i].getVersion())) continue;
            return true;
        }
        URL uRL2 = launchDesc.getMainJarURL();
        return uRL2 != null && uRL != null && uRL.toString().startsWith(uRL2.toString());
    }

    private PreloaderDelegate getProgressHelper(CustomProgress2PreloaderAdapter customProgress2PreloaderAdapter) {
        return new PreloaderDelegate(customProgress2PreloaderAdapter);
    }
}

