/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.bcel.Const;
import org.apache.bcel.classfile.ClassFormatException;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantCP;
import org.apache.bcel.classfile.ConstantClass;
import org.apache.bcel.classfile.ConstantDouble;
import org.apache.bcel.classfile.ConstantFloat;
import org.apache.bcel.classfile.ConstantInteger;
import org.apache.bcel.classfile.ConstantInvokeDynamic;
import org.apache.bcel.classfile.ConstantLong;
import org.apache.bcel.classfile.ConstantMethodHandle;
import org.apache.bcel.classfile.ConstantMethodType;
import org.apache.bcel.classfile.ConstantModule;
import org.apache.bcel.classfile.ConstantNameAndType;
import org.apache.bcel.classfile.ConstantPackage;
import org.apache.bcel.classfile.ConstantString;
import org.apache.bcel.classfile.ConstantUtf8;
import org.apache.bcel.classfile.Node;
import org.apache.bcel.classfile.Utility;
import org.apache.bcel.classfile.Visitor;

public class ConstantPool
implements Cloneable,
Node {
    private Constant[] constant_pool;

    public ConstantPool(Constant[] constant_pool) {
        this.constant_pool = constant_pool;
    }

    public ConstantPool(DataInput input) throws IOException, ClassFormatException {
        int constant_pool_count = input.readUnsignedShort();
        this.constant_pool = new Constant[constant_pool_count];
        int i = 1;
        while (i < constant_pool_count) {
            this.constant_pool[i] = Constant.readConstant(input);
            byte tag = this.constant_pool[i].getTag();
            if (tag == 6 || tag == 5) {
                ++i;
            }
            ++i;
        }
    }

    @Override
    public void accept(Visitor v) {
        v.visitConstantPool(this);
    }

    public String constantToString(Constant c) throws ClassFormatException {
        String str;
        byte tag = c.getTag();
        switch (tag) {
            case 7: {
                int i = ((ConstantClass)c).getNameIndex();
                c = this.getConstant(i, (byte)1);
                str = Utility.compactClassName(((ConstantUtf8)c).getBytes(), false);
                break;
            }
            case 8: {
                int i = ((ConstantString)c).getStringIndex();
                c = this.getConstant(i, (byte)1);
                str = "\"" + ConstantPool.escape(((ConstantUtf8)c).getBytes()) + "\"";
                break;
            }
            case 1: {
                str = ((ConstantUtf8)c).getBytes();
                break;
            }
            case 6: {
                str = String.valueOf(((ConstantDouble)c).getBytes());
                break;
            }
            case 4: {
                str = String.valueOf(((ConstantFloat)c).getBytes());
                break;
            }
            case 5: {
                str = String.valueOf(((ConstantLong)c).getBytes());
                break;
            }
            case 3: {
                str = String.valueOf(((ConstantInteger)c).getBytes());
                break;
            }
            case 12: {
                str = String.valueOf(this.constantToString(((ConstantNameAndType)c).getNameIndex(), (byte)1)) + " " + this.constantToString(((ConstantNameAndType)c).getSignatureIndex(), (byte)1);
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                str = String.valueOf(this.constantToString(((ConstantCP)c).getClassIndex(), (byte)7)) + "." + this.constantToString(((ConstantCP)c).getNameAndTypeIndex(), (byte)12);
                break;
            }
            case 15: {
                ConstantMethodHandle cmh = (ConstantMethodHandle)c;
                str = String.valueOf(Const.getMethodHandleName(cmh.getReferenceKind())) + " " + this.constantToString(cmh.getReferenceIndex(), this.getConstant(cmh.getReferenceIndex()).getTag());
                break;
            }
            case 16: {
                ConstantMethodType cmt = (ConstantMethodType)c;
                str = this.constantToString(cmt.getDescriptorIndex(), (byte)1);
                break;
            }
            case 18: {
                ConstantInvokeDynamic cid = (ConstantInvokeDynamic)c;
                str = String.valueOf(cid.getBootstrapMethodAttrIndex()) + ":" + this.constantToString(cid.getNameAndTypeIndex(), (byte)12);
                break;
            }
            case 19: {
                int i = ((ConstantModule)c).getNameIndex();
                c = this.getConstant(i, (byte)1);
                str = Utility.compactClassName(((ConstantUtf8)c).getBytes(), false);
                break;
            }
            case 20: {
                int i = ((ConstantPackage)c).getNameIndex();
                c = this.getConstant(i, (byte)1);
                str = Utility.compactClassName(((ConstantUtf8)c).getBytes(), false);
                break;
            }
            default: {
                throw new RuntimeException("Unknown constant type " + tag);
            }
        }
        return str;
    }

    private static String escape(String str) {
        int len = str.length();
        StringBuilder buf = new StringBuilder(len + 5);
        char[] ch = str.toCharArray();
        int i = 0;
        while (i < len) {
            switch (ch[i]) {
                case '\n': {
                    buf.append("\\n");
                    break;
                }
                case '\r': {
                    buf.append("\\r");
                    break;
                }
                case '\t': {
                    buf.append("\\t");
                    break;
                }
                case '\b': {
                    buf.append("\\b");
                    break;
                }
                case '\"': {
                    buf.append("\\\"");
                    break;
                }
                default: {
                    buf.append(ch[i]);
                }
            }
            ++i;
        }
        return buf.toString();
    }

    public String constantToString(int index, byte tag) throws ClassFormatException {
        Constant c = this.getConstant(index, tag);
        return this.constantToString(c);
    }

    public void dump(DataOutputStream file) throws IOException {
        file.writeShort(this.constant_pool.length);
        int i = 1;
        while (i < this.constant_pool.length) {
            if (this.constant_pool[i] != null) {
                this.constant_pool[i].dump(file);
            }
            ++i;
        }
    }

    public Constant getConstant(int index) {
        if (index >= this.constant_pool.length || index < 0) {
            throw new ClassFormatException("Invalid constant pool reference: " + index + ". Constant pool size is: " + this.constant_pool.length);
        }
        return this.constant_pool[index];
    }

    public Constant getConstant(int index, byte tag) throws ClassFormatException {
        Constant c = this.getConstant(index);
        if (c == null) {
            throw new ClassFormatException("Constant pool at index " + index + " is null.");
        }
        if (c.getTag() != tag) {
            throw new ClassFormatException("Expected class `" + Const.getConstantName(tag) + "' at index " + index + " and got " + c);
        }
        return c;
    }

    public Constant[] getConstantPool() {
        return this.constant_pool;
    }

    public String getConstantString(int index, byte tag) throws ClassFormatException {
        int i;
        Constant c = this.getConstant(index, tag);
        switch (tag) {
            case 7: {
                i = ((ConstantClass)c).getNameIndex();
                break;
            }
            case 8: {
                i = ((ConstantString)c).getStringIndex();
                break;
            }
            case 19: {
                i = ((ConstantModule)c).getNameIndex();
                break;
            }
            case 20: {
                i = ((ConstantPackage)c).getNameIndex();
                break;
            }
            default: {
                throw new RuntimeException("getConstantString called with illegal tag " + tag);
            }
        }
        c = this.getConstant(i, (byte)1);
        return ((ConstantUtf8)c).getBytes();
    }

    public int getLength() {
        return this.constant_pool == null ? 0 : this.constant_pool.length;
    }

    public void setConstant(int index, Constant constant) {
        this.constant_pool[index] = constant;
    }

    public void setConstantPool(Constant[] constant_pool) {
        this.constant_pool = constant_pool;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        int i = 1;
        while (i < this.constant_pool.length) {
            buf.append(i).append(")").append(this.constant_pool[i]).append("\n");
            ++i;
        }
        return buf.toString();
    }

    public ConstantPool copy() {
        ConstantPool c = null;
        try {
            c = (ConstantPool)this.clone();
            c.constant_pool = new Constant[this.constant_pool.length];
            int i = 1;
            while (i < this.constant_pool.length) {
                if (this.constant_pool[i] != null) {
                    c.constant_pool[i] = this.constant_pool[i].copy();
                }
                ++i;
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return c;
    }
}

