/*
 * Decompiled with CFR 0.152.
 */
package ext.libx.etc.util;

import java.util.List;

public class EtcPagination {
    private int dataCount;
    private int pageCount;
    public int countPerPage = 10;
    private int pageNum;
    private int pageNumReq;
    private int startId;
    private int endId;

    public int getDataCount() throws Exception {
        return this.dataCount;
    }

    public void setDataCount(int dataCount) throws Exception {
        this.dataCount = dataCount;
        this.pageCount = (int)Math.ceil((double)dataCount / (double)this.countPerPage);
        this.setPageNumReq(this.pageNumReq);
    }

    public int getPageCount() throws Exception {
        return this.pageCount;
    }

    public int getPageNum() throws Exception {
        return this.pageNum;
    }

    public int getPageNumReq() throws Exception {
        return this.pageNumReq;
    }

    public void setPageNumReq(int pageNumReq) {
        this.pageNumReq = pageNumReq;
        this.pageNum = Math.min(this.pageCount, Math.max(pageNumReq, 1));
        if (this.pageNum > 0) {
            this.startId = (this.pageNum - 1) * this.countPerPage;
            this.endId = this.startId + this.countPerPage - 1;
            this.endId = Math.min(this.endId, this.dataCount - 1);
        } else {
            this.startId = -1;
            this.endId = -1;
        }
    }

    public int getStartId() throws Exception {
        return this.startId;
    }

    public int getEndId() throws Exception {
        return this.endId;
    }

    protected <T> List<T> subList(List<T> list) throws Exception {
        if (this.startId >= 0) {
            List<T> subList = list.subList(this.startId, this.endId + 1);
            return subList;
        }
        return list;
    }

    public <T> List<T> newList(List<T> list) throws Exception {
        List<T> subList = this.subList(list);
        List newList = (List)list.getClass().newInstance();
        newList.addAll(subList);
        return newList;
    }
}

