/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.Container;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Enumeration;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultButtonModel;
import javax.swing.InputMap;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import javax.swing.LayoutComparator;
import javax.swing.SortingFocusTraversalPolicy;
import javax.swing.SwingDefaultFocusTraversalPolicy;
import sun.awt.SunToolkit;

public class LayoutFocusTraversalPolicy
extends SortingFocusTraversalPolicy
implements Serializable {
    private static final SwingDefaultFocusTraversalPolicy fitnessTestPolicy = new SwingDefaultFocusTraversalPolicy();

    public LayoutFocusTraversalPolicy() {
        super(new LayoutComparator());
    }

    LayoutFocusTraversalPolicy(Comparator<? super Component> comparator) {
        super(comparator);
    }

    @Override
    public Component getComponentAfter(Container container, Component component) {
        if (container == null || component == null) {
            throw new IllegalArgumentException("aContainer and aComponent cannot be null");
        }
        Comparator<? super Component> comparator = this.getComparator();
        if (comparator instanceof LayoutComparator) {
            ((LayoutComparator)comparator).setComponentOrientation(container.getComponentOrientation());
        }
        return super.getComponentAfter(container, component);
    }

    @Override
    public Component getComponentBefore(Container container, Component component) {
        if (container == null || component == null) {
            throw new IllegalArgumentException("aContainer and aComponent cannot be null");
        }
        Comparator<? super Component> comparator = this.getComparator();
        if (comparator instanceof LayoutComparator) {
            ((LayoutComparator)comparator).setComponentOrientation(container.getComponentOrientation());
        }
        return super.getComponentBefore(container, component);
    }

    @Override
    public Component getFirstComponent(Container container) {
        if (container == null) {
            throw new IllegalArgumentException("aContainer cannot be null");
        }
        Comparator<? super Component> comparator = this.getComparator();
        if (comparator instanceof LayoutComparator) {
            ((LayoutComparator)comparator).setComponentOrientation(container.getComponentOrientation());
        }
        return super.getFirstComponent(container);
    }

    @Override
    public Component getLastComponent(Container container) {
        if (container == null) {
            throw new IllegalArgumentException("aContainer cannot be null");
        }
        Comparator<? super Component> comparator = this.getComparator();
        if (comparator instanceof LayoutComparator) {
            ((LayoutComparator)comparator).setComponentOrientation(container.getComponentOrientation());
        }
        return super.getLastComponent(container);
    }

    @Override
    protected boolean accept(Component component) {
        if (!super.accept(component)) {
            return false;
        }
        if (SunToolkit.isInstanceOf(component, "javax.swing.JTable")) {
            return true;
        }
        if (SunToolkit.isInstanceOf(component, "javax.swing.JComboBox")) {
            JComboBox jComboBox = (JComboBox)component;
            return jComboBox.getUI().isFocusTraversable(jComboBox);
        }
        if (component instanceof JComponent) {
            Serializable serializable;
            Object object;
            if (SunToolkit.isInstanceOf(component, "javax.swing.JToggleButton") && (object = ((JToggleButton)component).getModel()) instanceof DefaultButtonModel && (serializable = ((DefaultButtonModel)object).getGroup()) != null) {
                Enumeration<AbstractButton> enumeration = ((ButtonGroup)serializable).getElements();
                int n = 0;
                while (enumeration.hasMoreElements()) {
                    AbstractButton abstractButton = enumeration.nextElement();
                    if (!(abstractButton instanceof JToggleButton) || !abstractButton.isVisible() || !abstractButton.isDisplayable() || !abstractButton.isEnabled() || !abstractButton.isFocusable()) continue;
                    if (abstractButton == component) {
                        return n == 0;
                    }
                    ++n;
                }
            }
            object = (JComponent)component;
            for (serializable = ((JComponent)object).getInputMap(0, false); serializable != null && ((InputMap)serializable).size() == 0; serializable = ((InputMap)serializable).getParent()) {
            }
            if (serializable != null) {
                return true;
            }
        }
        return fitnessTestPolicy.accept(component);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.getComparator());
        objectOutputStream.writeBoolean(this.getImplicitDownCycleTraversal());
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.setComparator((Comparator)objectInputStream.readObject());
        this.setImplicitDownCycleTraversal(objectInputStream.readBoolean());
    }
}

